/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.decay.DecayManager;
import thebetweenlands.entities.mobs.EntityTarBeast;
import thebetweenlands.event.render.DecayRenderHandler;
import thebetweenlands.forgeevent.client.PostRenderHandEvent;
import thebetweenlands.items.BLMaterial;

public class OverlayHandler {
    public static final OverlayHandler INSTANCE = new OverlayHandler();
    private static final ResourceLocation RES_UNDERWATER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
    private static final ResourceLocation RES_TAR_OVERLAY = new ResourceLocation("thebetweenlands:textures/gui/overlay/tarOverlay.png");
    private static final ResourceLocation RES_MUD_OVERLAY = new ResourceLocation("thebetweenlands:textures/blocks/mud.png");
    private static final ResourceLocation RES_STAGNANT_OVERLAY = new ResourceLocation("thebetweenlands:textures/gui/overlay/stagnantWaterOverlay.png");
    private Method mERrenderHand;
    private boolean cancelOverlay = false;
    private ModelArmOverride modelArmOverride = null;
    private boolean ignoreRenderHandEvent = false;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        if (this.cancelOverlay) {
            event.setCanceled(true);
            return;
        }
        if (event.overlayType == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(true);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(RES_UNDERWATER_OVERLAY);
            int colorMultiplier = BLBlockRegistry.swampWater.func_149720_d((IBlockAccess)mc.field_71441_e, MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)mc.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v));
            float r = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f / 2.0f;
            float g = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f / 2.0f;
            float b = (float)(colorMultiplier & 0xFF) / 255.0f / 2.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            this.renderWarpedTextureOverlay(event.renderPartialTicks);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
        }
    }

    public void renderHand(float partialTicks, int renderPass, boolean overlay) {
        block6: {
            if (this.ignoreRenderHandEvent) {
                return;
            }
            this.ignoreRenderHandEvent = true;
            if (this.mERrenderHand == null) {
                try {
                    this.mERrenderHand = ReflectionHelper.findMethod(EntityRenderer.class, null, (String[])new String[]{"renderHand", "func_78476_b", "b"}, (Class[])new Class[]{Float.TYPE, Integer.TYPE});
                    this.mERrenderHand.setAccessible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.cancelOverlay = !overlay;
            try {
                this.mERrenderHand.invoke((Object)Minecraft.func_71410_x().field_71460_t, Float.valueOf(partialTicks), renderPass);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getCause() == null) break block6;
                e.getCause().printStackTrace();
            }
        }
        this.cancelOverlay = false;
        this.ignoreRenderHandEvent = false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderHand(PostRenderHandEvent event) {
        EntityLivingBase view = Minecraft.func_71410_x().field_71451_h;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (view != null && world != null) {
            boolean inBlock;
            float f1;
            float f2;
            Vec3 vec = Vec3.func_72443_a((double)RenderManager.field_78725_b, (double)RenderManager.field_78726_c, (double)RenderManager.field_78723_d);
            ChunkPosition chunkposition = new ChunkPosition(vec);
            Block viewBlock = world.func_147439_a(chunkposition.field_151329_a, chunkposition.field_151327_b, chunkposition.field_151328_c);
            if (viewBlock.func_149688_o().func_76224_d() && vec.field_72448_b >= (double)(f2 = (float)(chunkposition.field_151327_b + 1) - (f1 = BlockLiquid.func_149801_b((int)world.func_72805_g(chunkposition.field_151329_a, chunkposition.field_151327_b, chunkposition.field_151328_c)) - 0.11111111f))) {
                viewBlock = world.func_147439_a(chunkposition.field_151329_a, chunkposition.field_151327_b + 1, chunkposition.field_151328_c);
            }
            List entitiesInside = world.func_72872_a(EntityTarBeast.class, view.field_70121_D.func_72314_b(-0.25, -0.25, -0.25));
            boolean inTar = viewBlock.func_149688_o() == BLMaterial.tar || entitiesInside != null && entitiesInside.size() > 0;
            boolean inStagnantWater = viewBlock == BLBlockRegistry.stagnantWaterFluid;
            int bx = MathHelper.func_76128_c((double)view.field_70165_t);
            int by = MathHelper.func_76128_c((double)view.field_70163_u);
            int bz = MathHelper.func_76128_c((double)view.field_70161_v);
            Block block = world.func_147439_a(bx, by, bz);
            boolean inMud = block.func_149688_o() == BLMaterial.mud;
            boolean bl = inBlock = inTar || inMud || inStagnantWater;
            if (inBlock && !this.cancelOverlay) {
                Minecraft mc = Minecraft.func_71410_x();
                GL11.glEnable((int)3042);
                GL11.glDepthMask((boolean)false);
                if (inTar) {
                    mc.func_110434_K().func_110577_a(RES_TAR_OVERLAY);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.985f);
                } else if (inMud) {
                    GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    GL11.glDisable((int)3042);
                    GL11.glDepthMask((boolean)true);
                    mc.func_110434_K().func_110577_a(RES_MUD_OVERLAY);
                } else if (inStagnantWater) {
                    mc.func_110434_K().func_110577_a(RES_STAGNANT_OVERLAY);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                }
                this.renderWarpedTextureOverlay(event.partialTicks);
                GL11.glDepthMask((boolean)true);
                GL11.glDisable((int)3042);
            }
        }
        if (!this.ignoreRenderHandEvent) {
            GL11.glClear((int)256);
            RenderPlayer playerRenderer = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)Minecraft.func_71410_x().field_71439_g);
            if (playerRenderer.getClass() == RenderPlayer.class && playerRenderer.field_77109_a.getClass() == ModelBiped.class) {
                if (this.modelArmOverride == null && playerRenderer.field_77109_a != null) {
                    this.modelArmOverride = new ModelArmOverride((ModelBase)playerRenderer.field_77109_a);
                }
                this.modelArmOverride.parent = playerRenderer.field_77109_a.field_78112_f;
                this.modelArmOverride.entity = (EntityPlayer)Minecraft.func_71410_x().field_71439_g;
                ModelRenderer previousModel = playerRenderer.field_77109_a.field_78112_f;
                playerRenderer.field_77109_a.field_78112_f = this.modelArmOverride;
                this.renderHand(event.partialTicks, event.renderPass, false);
                playerRenderer.field_77109_a.field_78112_f = previousModel;
            }
        }
    }

    private void renderWarpedTextureOverlay(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.field_78398_a;
        float brightness = mc.field_71439_g.func_70013_c(partialTicks);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glPushMatrix();
        float tu = 4.0f;
        float tv = 4.0f;
        float minX = -1.0f;
        float maxX = 1.0f;
        float minY = -1.0f;
        float maxY = 1.0f;
        float z = -0.5f;
        float tuOffset = -mc.field_71439_g.field_70177_z / 64.0f;
        float tvOffset = mc.field_71439_g.field_70125_A / 64.0f;
        tessellator.func_78380_c((int)(brightness * 255.0f));
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)minX, (double)minY, (double)z, (double)(tu + tuOffset), (double)(tu + tvOffset));
        tessellator.func_78374_a((double)maxX, (double)minY, (double)z, (double)(0.0f + tuOffset), (double)(tu + tvOffset));
        tessellator.func_78374_a((double)maxX, (double)maxY, (double)z, (double)(0.0f + tuOffset), (double)(0.0f + tvOffset));
        tessellator.func_78374_a((double)minX, (double)maxY, (double)z, (double)(tu + tuOffset), (double)(0.0f + tvOffset));
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static class ModelArmOverride
    extends ModelRenderer {
        public boolean holdingItem = false;
        private ModelRenderer parent;
        private EntityPlayer entity;

        public ModelArmOverride(ModelBase modelBase) {
            super(modelBase);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78785_a(float partialTicks) {
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(DecayRenderHandler.PLAYER_CORRUPTION_TEXTURE);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float glow = (float)((Math.cos((double)this.entity.field_70173_aa / 10.0) + 1.0) / 2.0) * 0.15f;
            float transparency = 0.85f * (float)DecayManager.getCorruptionLevel(this.entity) / 10.0f - glow;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            this.parent.func_78785_a(partialTicks);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71439_g.func_110306_p());
            GL11.glPopMatrix();
        }
    }
}

