/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.render;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.terrain.BlockSwampWater;
import thebetweenlands.event.debugging.DebugHandlerClient;
import thebetweenlands.herblore.elixirs.ElixirEffectRegistry;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.events.EnvironmentEventRegistry;
import thebetweenlands.world.storage.chunk.storage.location.LocationAmbience;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class FogHandler {
    public static final FogHandler INSTANCE = new FogHandler();
    private float currentFogStart = -1.0f;
    private float currentFogEnd = -1.0f;
    private float lastFogStart = -1.0f;
    private float lastFogEnd = -1.0f;
    private float currentFogColorMultiplier = -1.0f;
    private float lastFogColorMultiplier = -1.0f;
    private float farPlaneDistance = 0.0f;
    private int fogMode;

    public float getCurrentFogStart() {
        return this.currentFogStart;
    }

    public float getCurrentFogEnd() {
        return this.currentFogEnd;
    }

    public int getCurrentFogMode() {
        return this.fogMode;
    }

    public boolean hasDenseFog() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.field_73011_w instanceof WorldProviderBetweenlands && Minecraft.func_71410_x().field_71439_g.field_70163_u > 70.0) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
            EnvironmentEventRegistry eeRegistry = provider.getWorldData().getEnvironmentEventRegistry();
            boolean denseFog = false;
            if (!ConfigHandler.DEBUG && eeRegistry.DENSE_FOG.isActive() || DebugHandlerClient.INSTANCE.denseFog && ConfigHandler.DEBUG && !eeRegistry.DENSE_FOG.isActive() || !DebugHandlerClient.INSTANCE.denseFog && ConfigHandler.DEBUG && eeRegistry.DENSE_FOG.isActive()) {
                denseFog = true;
            }
            return denseFog;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogRenderEvent(EntityViewRenderEvent.RenderFogEvent event) {
        World world = TheBetweenlands.proxy.getClientWorld();
        if (world == null || !(world.field_73011_w instanceof WorldProviderBetweenlands)) {
            return;
        }
        if (world.field_72995_K) {
            this.farPlaneDistance = event.farPlaneDistance;
            float partialTicks = (float)event.renderPartialTicks;
            float fogStart = this.currentFogStart + (this.currentFogStart - this.lastFogStart) * partialTicks;
            float fogEnd = this.currentFogEnd + (this.currentFogEnd - this.lastFogEnd) * partialTicks;
            this.fogMode = 9729;
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)fogStart);
            GL11.glFogf((int)2916, (float)fogEnd);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        LocationAmbience ambience;
        World world = TheBetweenlands.proxy.getClientWorld();
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (world == null || player == null || this.farPlaneDistance == 0.0f || player.field_71093_bK != ConfigHandler.DIMENSION_ID) {
            return;
        }
        BiomeGenBase biome = world.func_72807_a(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70161_v));
        float fogStart = this.farPlaneDistance * 0.25f;
        float fogEnd = this.farPlaneDistance;
        if (biome instanceof BiomeGenBaseBetweenlands) {
            BiomeGenBaseBetweenlands bgbb = (BiomeGenBaseBetweenlands)biome;
            fogStart = bgbb.getFogStart(this.farPlaneDistance);
            fogEnd = bgbb.getFogEnd(this.farPlaneDistance);
        }
        float uncloudedStrength = 0.0f;
        if (ElixirEffectRegistry.EFFECT_UNCLOUDED.isActive((EntityLivingBase)player)) {
            uncloudedStrength += Math.min((float)(ElixirEffectRegistry.EFFECT_UNCLOUDED.getStrength((EntityLivingBase)player) + 1) / 3.0f, 1.0f);
        }
        if (ElixirEffectRegistry.EFFECT_FOGGEDMIND.isActive((EntityLivingBase)player)) {
            float additionalFogStrength = (float)(ElixirEffectRegistry.EFFECT_FOGGEDMIND.getStrength((EntityLivingBase)player) + 1) * 0.85f;
            fogStart /= additionalFogStrength * 2.0f;
            fogEnd /= additionalFogStrength;
        }
        if (this.hasDenseFog()) {
            fogStart /= 5.0f / (1.0f + uncloudedStrength * 4.0f);
            fogEnd /= 3.0f / (1.0f + uncloudedStrength * 2.0f);
        }
        float multiplier = 1.0f;
        if (player.field_70163_u < 70.0) {
            float targettedMultiplier;
            multiplier = (float)(70.0 - player.field_70163_u) / 70.0f;
            multiplier = 1.0f - multiplier;
            multiplier = (float)((double)multiplier * Math.pow(multiplier, 8.5));
            multiplier = multiplier * 0.95f + 0.05f;
            if (player.field_70163_u <= 34.0 && multiplier < (targettedMultiplier = 0.3f)) {
                multiplier = (float)((double)multiplier + Math.pow((double)((targettedMultiplier - multiplier) / 34.0f) * (34.0 - player.field_70163_u), 0.85f));
            }
            fogStart *= Math.min(multiplier * (1.0f + uncloudedStrength * (1.0f / multiplier - 1.0f)), 1.0f);
            fogEnd *= Math.min(multiplier * 1.5f * (1.0f + uncloudedStrength * (1.0f / (multiplier * 1.5f) - 1.0f)), 1.0f);
        }
        if ((ambience = LocationStorage.getAmbience((Entity)player)) != null) {
            if (ambience.hasFogRange()) {
                fogStart = ambience.getFogStart();
                fogEnd = ambience.getFogEnd();
            }
            if (ambience.hasFogRangeMultiplier()) {
                fogStart *= ambience.getFogRangeMultiplier();
                fogEnd *= ambience.getFogRangeMultiplier();
            }
            if (ambience.hasFogColorMultiplier()) {
                multiplier = ambience.getFogColorMultiplier();
            }
        }
        fogStart = Math.max(fogStart, 2.0f);
        fogEnd = Math.max(fogEnd, 6.0f);
        if (this.currentFogStart < 0.0f || this.currentFogEnd < 0.0f) {
            this.currentFogStart = fogStart;
            this.currentFogEnd = fogEnd;
        }
        float fogDistIncrMultiplier = player.field_70163_u <= 70.0 ? 2.0f : 1.0f;
        this.lastFogStart = this.currentFogStart;
        this.lastFogEnd = this.currentFogEnd;
        if (Math.abs(this.currentFogStart - fogStart) > fogDistIncrMultiplier) {
            float currentFogStartIncr = Math.abs(this.currentFogStart - fogStart) / this.farPlaneDistance / 2.0f * fogDistIncrMultiplier;
            if (this.currentFogStart > fogStart) {
                this.currentFogStart -= currentFogStartIncr;
            } else if (this.currentFogStart < fogStart) {
                this.currentFogStart += currentFogStartIncr;
            }
        }
        if (Math.abs(this.currentFogEnd - fogEnd) > fogDistIncrMultiplier) {
            float currentFogEndIncr = Math.abs(this.currentFogEnd - fogEnd) / this.farPlaneDistance / 2.0f * fogDistIncrMultiplier;
            if (this.currentFogEnd > fogEnd) {
                this.currentFogEnd -= currentFogEndIncr;
            } else if (this.currentFogEnd < fogEnd) {
                this.currentFogEnd += currentFogEndIncr;
            }
        }
        float targettedFogColorMultiplier = MathHelper.func_76131_a((float)(multiplier * 2.0f), (float)0.0f, (float)1.0f);
        if (this.currentFogColorMultiplier < 0.0f) {
            this.currentFogColorMultiplier = targettedFogColorMultiplier;
            this.lastFogColorMultiplier = targettedFogColorMultiplier;
        }
        this.lastFogColorMultiplier = this.currentFogColorMultiplier;
        float fogColorMultiplierIncr = 0.005f;
        if (Math.abs(this.currentFogColorMultiplier - targettedFogColorMultiplier) > fogColorMultiplierIncr) {
            if (this.currentFogColorMultiplier > targettedFogColorMultiplier) {
                this.currentFogColorMultiplier -= fogColorMultiplierIncr;
            } else if (this.currentFogColorMultiplier < targettedFogColorMultiplier) {
                this.currentFogColorMultiplier += fogColorMultiplierIncr;
            }
        } else {
            this.currentFogColorMultiplier = targettedFogColorMultiplier;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world == null || !(world.field_73011_w instanceof WorldProviderBetweenlands)) {
            return;
        }
        if (world.field_72995_K) {
            EntityLivingBase renderView = Minecraft.func_71410_x().field_71451_h;
            if (renderView == null || renderView.field_71093_bK != ConfigHandler.DIMENSION_ID) {
                return;
            }
            Block block = ActiveRenderInfo.func_151460_a((World)world, (EntityLivingBase)renderView, (float)((float)event.renderPartialTicks));
            float fogColorMultiplier = (float)((double)this.currentFogColorMultiplier + (double)(this.currentFogColorMultiplier - this.lastFogColorMultiplier) * event.renderPartialTicks);
            if (block instanceof BlockSwampWater) {
                BiomeGenBase biome = world.func_72807_a(MathHelper.func_76128_c((double)renderView.field_70165_t), MathHelper.func_76128_c((double)renderView.field_70161_v));
                if (biome instanceof BiomeGenBaseBetweenlands) {
                    int colorMultiplier = BLBlockRegistry.swampWater.func_149720_d((IBlockAccess)world, MathHelper.func_76128_c((double)renderView.field_70165_t), MathHelper.func_76128_c((double)renderView.field_70163_u), MathHelper.func_76128_c((double)renderView.field_70161_v));
                    event.red = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
                    event.green = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
                    event.blue = (float)(colorMultiplier & 0xFF) / 255.0f;
                    double waterFogColorMultiplier = Math.pow(fogColorMultiplier, 6.0);
                    event.red = (float)((double)event.red * waterFogColorMultiplier);
                    event.green = (float)((double)event.green * waterFogColorMultiplier);
                    event.blue = (float)((double)event.blue * waterFogColorMultiplier);
                }
            } else {
                event.red *= fogColorMultiplier;
                event.green *= fogColorMultiplier;
                event.blue *= fogColorMultiplier;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world == null || !(world.field_73011_w instanceof WorldProviderBetweenlands)) {
            return;
        }
        if (world.field_72995_K) {
            EntityLivingBase renderView = Minecraft.func_71410_x().field_71451_h;
            if (renderView == null || renderView.field_71093_bK != ConfigHandler.DIMENSION_ID) {
                return;
            }
            Block block = ActiveRenderInfo.func_151460_a((World)world, (EntityLivingBase)renderView, (float)((float)event.renderPartialTicks));
            if (block instanceof BlockSwampWater) {
                this.fogMode = 2048;
                GL11.glFogi((int)2917, (int)2048);
                event.density = renderView.func_70644_a(Potion.field_76427_o) ? 0.1f : 0.4f;
                event.setCanceled(true);
            }
        }
    }
}

