/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.decay.DecayManager;

public class DecayRenderHandler {
    public static final DecayRenderHandler INSTANCE = new DecayRenderHandler();
    public static final ResourceLocation PLAYER_CORRUPTION_TEXTURE = new ResourceLocation("thebetweenlands:textures/player/playerCorruption.png");
    private final ModelBipedOverride modelBipedOverride = new ModelBipedOverride();
    private boolean ignoreEvent = false;
    private Field f_mainModel = ReflectionHelper.findField(RendererLivingEntity.class, (String[])new String[]{"mainModel", "field_77045_g", "i"});
    private ItemStack[] prevArmor = new ItemStack[4];
    private ItemStack prevHeldItem = null;

    public void removeVisibleEntityItems(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            for (int i = 0; i < 4; ++i) {
                this.prevArmor[i] = ((EntityPlayer)entity).field_71071_by.field_70460_b[i];
                ((EntityPlayer)entity).field_71071_by.field_70460_b[i] = null;
            }
        }
        this.prevHeldItem = entity.func_70694_bm();
        entity.func_70062_b(0, null);
    }

    public void restoreVisibleEntityItems(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            for (int i = 0; i < 4; ++i) {
                ((EntityPlayer)entity).field_71071_by.field_70460_b[i] = this.prevArmor[i];
            }
        }
        entity.func_70062_b(0, this.prevHeldItem);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!DecayManager.isDecayEnabled(event.entityPlayer) || DecayManager.getCorruptionLevel(event.entityPlayer) == 0 || this.ignoreEvent) {
            return;
        }
        event.setCanceled(true);
        this.ignoreEvent = true;
        double renderX = 0.0;
        double renderY = 0.0;
        double renderZ = 0.0;
        if (event.entityPlayer != Minecraft.func_71410_x().field_71451_h) {
            renderX = event.entity.field_70165_t + (event.entity.field_70165_t - event.entity.field_70142_S) * (double)event.partialRenderTick - RenderManager.field_78725_b;
            renderY = event.entity.field_70163_u + (event.entity.field_70163_u - event.entity.field_70137_T) * (double)event.partialRenderTick - RenderManager.field_78726_c;
            renderZ = event.entity.field_70161_v + (event.entity.field_70161_v - event.entity.field_70136_U) * (double)event.partialRenderTick - RenderManager.field_78723_d;
        }
        float yaw = event.entity.field_70177_z + (event.entity.field_70177_z - event.entity.field_70126_B) * event.partialRenderTick;
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)0.01f, (float)1.0f);
        event.renderer.func_76986_a((EntityLivingBase)event.entityPlayer, renderX, renderY, renderZ, yaw, event.partialRenderTick);
        GL11.glPolygonOffset((float)-0.01f, (float)1.0f);
        GL11.glDisable((int)32823);
        ModelBiped prev = null;
        try {
            prev = (ModelBiped)this.f_mainModel.get(event.renderer);
            this.modelBipedOverride.parent = prev;
            this.f_mainModel.set(event.renderer, (Object)this.modelBipedOverride);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.modelBipedOverride.holdingItem = event.entityPlayer.func_70694_bm() != null;
        this.removeVisibleEntityItems((EntityLivingBase)event.entityPlayer);
        event.renderer.func_76986_a((EntityLivingBase)event.entityPlayer, renderX, renderY, renderZ, yaw, event.partialRenderTick);
        this.restoreVisibleEntityItems((EntityLivingBase)event.entityPlayer);
        try {
            this.f_mainModel.set(event.renderer, prev);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ignoreEvent = false;
    }

    static class ModelBipedOverride
    extends ModelBiped {
        public boolean holdingItem = false;
        private ModelBiped parent;

        ModelBipedOverride() {
        }

        public void func_78088_a(Entity entity, float x, float y, float z, float yaw, float pitch, float partialTicks) {
            this.parent.field_78120_m = this.holdingItem ? 1 : 0;
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(PLAYER_CORRUPTION_TEXTURE);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float glow = (float)((Math.cos((double)entity.field_70173_aa / 10.0) + 1.0) / 2.0) * 0.15f;
            float transparency = 0.85f * (float)DecayManager.getCorruptionLevel((EntityPlayer)entity) / 10.0f - glow;
            boolean isHurt = ((EntityPlayer)entity).field_70737_aN > 0;
            GL11.glColor4f((float)1.0f, (float)(isHurt ? 0.5f : 1.0f), (float)(isHurt ? 0.5f : 1.0f), (float)(isHurt ? transparency / 2.0f : transparency));
            this.parent.func_78088_a(entity, x, y, z, yaw, pitch, partialTicks);
            GL11.glPopMatrix();
        }
    }
}

