/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import thebetweenlands.entities.ICameraOffset;
import thebetweenlands.entities.IScreenShake;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesRingInput;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.items.BLItemRegistry;

public class CameraPositionHandler {
    public static CameraPositionHandler INSTANCE = new CameraPositionHandler();
    private double prevPosX;
    private double prevPosY;
    private double prevPosZ;
    private boolean didChange = false;

    private float getShakeStrength(float delta) {
        float screenShake = 0.0f;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityLivingBase renderViewEntity = Minecraft.func_71410_x().field_71451_h;
        for (Entity entity : world.field_72996_f) {
            if (!(entity instanceof IScreenShake)) continue;
            IScreenShake shake = (IScreenShake)entity;
            screenShake += shake.getShakeIntensity(renderViewEntity, delta);
        }
        return MathHelper.func_76131_a((float)screenShake, (float)0.0f, (float)0.15f);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTickStart(TickEvent.RenderTickEvent event) {
        boolean shouldChange;
        EntityLivingBase renderViewEntity = Minecraft.func_71410_x().field_71451_h;
        if (renderViewEntity == null) {
            return;
        }
        float shakeStrength = this.getShakeStrength(event.renderTickTime);
        ArrayList<ICameraOffset> offsetEntities = new ArrayList<ICameraOffset>();
        for (Entity entity : renderViewEntity.field_70170_p.field_72996_f) {
            if (!(entity instanceof ICameraOffset)) continue;
            offsetEntities.add((ICameraOffset)entity);
        }
        for (EntityPlayer player : renderViewEntity.field_70170_p.field_73010_i) {
            if (!((double)player.func_70032_d((Entity)renderViewEntity) < 32.0)) continue;
            EquipmentInventory equipmentInventory = EquipmentInventory.getEquipmentInventory((Entity)player);
            for (Equipment equipment : equipmentInventory.getEquipment(EnumEquipmentCategory.RING)) {
                EntityPropertiesRingInput prop;
                int useTime;
                if (equipment.item.func_77973_b() != BLItemRegistry.ringOfSummoning || equipment.item.field_77990_d == null || !equipment.item.field_77990_d.func_74764_b("useTime") || (useTime = equipment.item.field_77990_d.func_74762_e("useTime")) >= 100 || equipment.item.field_77990_d.func_74764_b("useCooldown") && equipment.item.field_77990_d.func_74762_e("useCooldown") > 0 || (prop = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)player, EntityPropertiesRingInput.class)) == null || !prop.isInUse()) continue;
                shakeStrength += (float)(100 - useTime) / 100.0f * 0.1f + 0.01f;
            }
        }
        boolean bl = shouldChange = shakeStrength > 0.0f || !offsetEntities.isEmpty();
        if (!(shouldChange && !Minecraft.func_71410_x().func_147113_T() || this.didChange)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.prevPosX = renderViewEntity.field_70165_t;
            this.prevPosY = renderViewEntity.field_70163_u;
            this.prevPosZ = renderViewEntity.field_70161_v;
            Random rnd = renderViewEntity.field_70170_p.field_73012_v;
            renderViewEntity.field_70165_t += (double)(rnd.nextFloat() * shakeStrength);
            renderViewEntity.field_70163_u += (double)(rnd.nextFloat() * shakeStrength);
            renderViewEntity.field_70161_v += (double)(rnd.nextFloat() * shakeStrength);
            if (!offsetEntities.isEmpty()) {
                ICameraOffset offset;
                Iterator iterator = offsetEntities.iterator();
                while (iterator.hasNext() && !(offset = (ICameraOffset)iterator.next()).applyOffset(renderViewEntity, event.renderTickTime)) {
                }
            }
            this.didChange = true;
        } else {
            renderViewEntity.field_70165_t = this.prevPosX;
            renderViewEntity.field_70163_u = this.prevPosY;
            renderViewEntity.field_70161_v = this.prevPosZ;
            this.didChange = false;
        }
    }
}

