/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.player;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.manual.widgets.text.FormatTags;
import thebetweenlands.manual.widgets.text.TextContainer;
import thebetweenlands.utils.ColorUtils;
import thebetweenlands.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.world.storage.chunk.storage.ChunkStorage;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class PlayerLocationHandler {
    public static final PlayerLocationHandler INSTANCE = new PlayerLocationHandler();
    private static final ResourceLocation TITLE_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/locationTitle.png");
    private TextContainer titleContainer = null;
    private String currentLocation = "";
    private int titleTicks = 0;
    private int maxTitleTicks = 120;
    private static final List<Block> EXCLUDED_BLOCKS = new ArrayList<Block>();

    public static List<LocationStorage> getVisibleLocations(Entity entity) {
        ArrayList<LocationStorage> locations = new ArrayList<LocationStorage>();
        Chunk chunk = entity.field_70170_p.func_72938_d(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v));
        if (chunk != null) {
            BetweenlandsChunkData chunkData = BetweenlandsChunkData.forChunk(entity.field_70170_p, chunk);
            for (ChunkStorage storage : chunkData.getStorage()) {
                if (!(storage instanceof LocationStorage) || !((LocationStorage)storage).isInside(entity) || !((LocationStorage)storage).isVisible(entity)) continue;
                locations.add((LocationStorage)storage);
            }
        }
        return locations;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().func_147113_T() && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            if (this.titleTicks > 0) {
                --this.titleTicks;
            }
            String prevLocation = this.currentLocation;
            List<LocationStorage> locations = PlayerLocationHandler.getVisibleLocations((Entity)player);
            if (locations.isEmpty()) {
                String location;
                Object strippedName;
                if (player.field_70163_u < 60.0) {
                    strippedName = StatCollector.func_74838_a((String)"location.wilderness.name");
                    if (((String)strippedName).contains(":")) {
                        int startIndex = ((String)strippedName).indexOf(":");
                        strippedName = ((String)strippedName).substring(startIndex + 1, ((String)strippedName).length());
                    }
                    if (this.currentLocation.equals(strippedName)) {
                        prevLocation = "";
                    }
                    location = StatCollector.func_74838_a((String)"location.caverns.name");
                } else {
                    strippedName = StatCollector.func_74838_a((String)"location.caverns.name");
                    if (((String)strippedName).contains(":")) {
                        int startIndex = ((String)strippedName).indexOf(":");
                        strippedName = ((String)strippedName).substring(startIndex + 1, ((String)strippedName).length());
                    }
                    if (this.currentLocation.equals(strippedName)) {
                        prevLocation = "";
                    }
                    location = StatCollector.func_74838_a((String)"location.wilderness.name");
                }
                this.currentLocation = location;
            } else {
                LocationStorage highestLocation = null;
                for (LocationStorage storage : locations) {
                    if (highestLocation != null && storage.getLayer() <= highestLocation.getLayer()) continue;
                    highestLocation = storage;
                }
                this.currentLocation = highestLocation.getLocalizedName();
            }
            if (this.currentLocation.length() > 0) {
                if (this.currentLocation.contains(":")) {
                    int startIndex = this.currentLocation.indexOf(":");
                    String ticks = this.currentLocation.substring(0, startIndex);
                    this.currentLocation = this.currentLocation.substring(startIndex + 1, this.currentLocation.length());
                    try {
                        this.maxTitleTicks = Integer.parseInt(ticks);
                    }
                    catch (Exception ex) {
                        this.maxTitleTicks = 80;
                    }
                }
                if (prevLocation != null && prevLocation.length() > 0 && !prevLocation.equals(this.currentLocation)) {
                    this.titleTicks = this.maxTitleTicks;
                    this.titleContainer = new TextContainer(2048.0, 2048.0, this.currentLocation, TheBetweenlands.proxy.getCustomFontRenderer());
                    this.titleContainer.setCurrentScale(2.0f).setCurrentColor(-1);
                    this.titleContainer.registerTag(new FormatTags.TagNewLine());
                    this.titleContainer.registerTag(new FormatTags.TagScale(2.0f));
                    this.titleContainer.registerTag(new FormatTags.TagSimple("bold", EnumChatFormatting.BOLD));
                    this.titleContainer.registerTag(new FormatTags.TagSimple("obfuscated", EnumChatFormatting.OBFUSCATED));
                    this.titleContainer.registerTag(new FormatTags.TagSimple("italic", EnumChatFormatting.ITALIC));
                    this.titleContainer.registerTag(new FormatTags.TagSimple("strikethrough", EnumChatFormatting.STRIKETHROUGH));
                    this.titleContainer.registerTag(new FormatTags.TagSimple("underline", EnumChatFormatting.UNDERLINE));
                    try {
                        this.titleContainer.parse();
                    }
                    catch (Exception e) {
                        this.titleContainer = null;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderScreen(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT && this.titleTicks > 0 && this.titleContainer != null && !this.titleContainer.getPages().isEmpty()) {
            TextContainer.TextPage page = this.titleContainer.getPages().get(0);
            int width = event.resolution.func_78326_a();
            int height = event.resolution.func_78328_b();
            double strWidth = page.getTextWidth();
            double strHeight = page.getTextHeight();
            double strX = (double)width / 2.0 - strWidth / 2.0;
            double strY = (double)height / 5.0;
            GL11.glPushMatrix();
            GL11.glTranslated((double)strX, (double)strY, (double)0.0);
            float fade = Math.min(1.0f, ((float)this.maxTitleTicks - (float)this.titleTicks) / Math.min(40.0f, (float)this.maxTitleTicks - 5.0f) + 0.02f) - Math.max(0.0f, (float)(-this.titleTicks + 5) / 5.0f);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glEnable((int)3042);
            float averageScale = 0.0f;
            for (TextContainer.TextSegment segment : page.getSegments()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)segment.x, (double)segment.y, (double)0.0);
                GL11.glScalef((float)segment.scale, (float)segment.scale, (float)1.0f);
                float[] rgba = ColorUtils.getRGBA(segment.color);
                segment.font.func_78276_b(segment.text, 0, 0, ColorUtils.toHex(rgba[0], rgba[1], rgba[2], rgba[3] * fade));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                averageScale += segment.scale;
            }
            averageScale /= (float)page.getSegments().size();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TITLE_TEXTURE);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)fade);
            GL11.glDisable((int)2884);
            double sidePadding = 6.0;
            double yOffset = 5.0;
            double sy = strY + strHeight - yOffset * (double)averageScale;
            double ey = strY + strHeight - yOffset * (double)averageScale + (double)(15.0f * averageScale);
            this.renderTexturedRect(strX - sidePadding * (double)averageScale, sy, strX - sidePadding * (double)averageScale + (double)(9.0f * averageScale), ey, 0.0, 0.0703125, 0.0, 1.0);
            this.renderTexturedRect(strX - sidePadding * (double)averageScale + (double)(9.0f * averageScale), sy, strX + strWidth / 2.0 - (double)(6.0f * averageScale), ey, 0.0703125, 0.453125, 0.0, 1.0);
            this.renderTexturedRect(strX + strWidth / 2.0 - (double)(6.0f * averageScale), sy, strX + strWidth / 2.0 + (double)(6.0f * averageScale), ey, 0.453125, 0.546875, 0.0, 1.0);
            this.renderTexturedRect(strX + strWidth / 2.0 + (double)(6.0f * averageScale), sy, strX + strWidth + sidePadding * (double)averageScale - (double)(9.0f * averageScale), ey, 0.546875, 0.9296875, 0.0, 1.0);
            this.renderTexturedRect(strX + strWidth + sidePadding * (double)averageScale - (double)(9.0f * averageScale), sy, strX + strWidth + sidePadding * (double)averageScale, ey, 0.9296875, 1.0, 0.0, 1.0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderTexturedRect(double x, double y, double x2, double y2, double umin, double umax, double vmin, double vmax) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)umin, (double)vmin);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glTexCoord2d((double)umin, (double)vmax);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glTexCoord2d((double)umax, (double)vmax);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glTexCoord2d((double)umax, (double)vmin);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glEnd();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!LocationStorage.isInLocationType((Entity)event.player, EnumLocationType.WIGHT_TOWER)) {
            event.player.getEntityData().func_74768_a("thebetweenlands.blGuardWarnings", 0);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        Chunk chunk;
        if (event.world.field_73013_u != EnumDifficulty.PEACEFUL && (chunk = event.world.func_72964_e(event.x / 16, event.z / 16)) != null && !event.world.field_72995_K && event.player != null && !event.player.field_71075_bZ.field_75098_d && LocationStorage.isLocationGuarded((Entity)event.player)) {
            int warnings = event.player.getEntityData().func_74762_e("thebetweenlands.blGuardWarnings");
            if (warnings < 6) {
                event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.guard.warning1", new Object[0]));
                event.player.getEntityData().func_74768_a("thebetweenlands.blGuardWarnings", warnings + 1);
            } else {
                event.player.getEntityData().func_74768_a("thebetweenlands.blGuardWarnings", 0);
                event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.guard.warning2", new Object[0]));
                this.spawnGuards(event.player);
            }
            EntityWight wight = new EntityWight(event.player.field_70170_p);
            wight.setRepairGuard(event.x, event.y, event.z);
            wight.setVolatile(true);
            double rx = event.player.field_70170_p.field_73012_v.nextDouble() - 0.5;
            double ry = event.player.field_70170_p.field_73012_v.nextDouble() - 0.5;
            double rz = event.player.field_70170_p.field_73012_v.nextDouble() - 0.5;
            Vec3 dir = Vec3.func_72443_a((double)rx, (double)ry, (double)rz);
            dir = dir.func_72432_b();
            rx = dir.field_72450_a * 4.0;
            ry = dir.field_72448_b * 4.0;
            rz = dir.field_72449_c * 4.0;
            wight.func_70012_b((double)event.x + rx, (double)event.y + ry, (double)event.z + rz, 0.0f, 0.0f);
            event.player.field_70170_p.func_72838_d((Entity)wight);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player;
        Chunk chunk;
        if (event.world.field_73013_u != EnumDifficulty.PEACEFUL && (chunk = event.world.func_72964_e(event.x / 16, event.z / 16)) != null && (player = event.getPlayer()) != null && !player.field_71075_bZ.field_75098_d && LocationStorage.isLocationGuarded((Entity)player) && !EXCLUDED_BLOCKS.contains(event.block)) {
            if (!event.world.field_72995_K) {
                int warnings = player.getEntityData().func_74762_e("thebetweenlands.blGuardWarnings");
                if (warnings < 6) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.guard.warning1", new Object[0]));
                    player.getEntityData().func_74768_a("thebetweenlands.blGuardWarnings", warnings + 1);
                } else {
                    player.getEntityData().func_74768_a("thebetweenlands.blGuardWarnings", 0);
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.guard.warning2", new Object[0]));
                    this.spawnGuards(player);
                }
                EntityWight wight = new EntityWight(player.field_70170_p);
                wight.setRepairGuard(event.block, event.x, event.y, event.z, event.blockMetadata);
                wight.setVolatile(true);
                double rx = player.field_70170_p.field_73012_v.nextDouble() - 0.5;
                double ry = player.field_70170_p.field_73012_v.nextDouble() - 0.5;
                double rz = player.field_70170_p.field_73012_v.nextDouble() - 0.5;
                Vec3 dir = Vec3.func_72443_a((double)rx, (double)ry, (double)rz);
                dir = dir.func_72432_b();
                rx = dir.field_72450_a * 4.0;
                ry = dir.field_72448_b * 4.0;
                rz = dir.field_72449_c * 4.0;
                wight.func_70012_b((double)event.x + rx, (double)event.y + ry, (double)event.z + rz, 0.0f, 0.0f);
                player.field_70170_p.func_72838_d((Entity)wight);
                event.world.func_147449_b(event.x, event.y, event.z, Blocks.field_150350_a);
                event.setCanceled(true);
            } else {
                event.world.func_72889_a(null, 2001, event.x, event.y, event.z, Block.func_149682_b((Block)event.block));
                event.world.func_147449_b(event.x, event.y, event.z, Blocks.field_150350_a);
                event.setCanceled(true);
            }
        }
    }

    private void spawnGuards(EntityPlayer player) {
        if (player.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            AxisAlignedBB checkAABB = player.field_70121_D.func_72314_b(12.0, 12.0, 12.0);
            List wights = player.field_70170_p.func_72872_a(EntityWight.class, checkAABB);
            int guards = 0;
            for (EntityWight wight : wights) {
                if (!wight.isLocationGuard()) continue;
                ++guards;
            }
            if (guards < 3) {
                for (int i = 0; i < 3 - guards; ++i) {
                    EntityWight wight;
                    wight = new EntityWight(player.field_70170_p);
                    wight.setLocationGuard(player);
                    wight.setVolatile(true);
                    double rx = player.field_70170_p.field_73012_v.nextDouble() - 0.5;
                    double ry = player.field_70170_p.field_73012_v.nextDouble() - 0.5;
                    double rz = player.field_70170_p.field_73012_v.nextDouble() - 0.5;
                    Vec3 dir = Vec3.func_72443_a((double)rx, (double)ry, (double)rz);
                    dir = dir.func_72432_b();
                    rx = dir.field_72450_a * 6.0;
                    ry = dir.field_72448_b * 6.0;
                    rz = dir.field_72449_c * 6.0;
                    wight.func_70012_b(player.field_70165_t + rx, player.field_70163_u + ry, player.field_70161_v + rz, 0.0f, 0.0f);
                    wight.func_70625_a((Entity)player, 360.0f, 360.0f);
                    wight.func_70624_b((EntityLivingBase)player);
                    player.field_70170_p.func_72838_d((Entity)wight);
                }
            }
        }
    }

    static {
        EXCLUDED_BLOCKS.add(BLBlockRegistry.weedwoodChest);
        EXCLUDED_BLOCKS.add((Block)BLBlockRegistry.blSpawner);
        EXCLUDED_BLOCKS.add((Block)BLBlockRegistry.itemCage);
        EXCLUDED_BLOCKS.add(BLBlockRegistry.lootPot1);
        EXCLUDED_BLOCKS.add(BLBlockRegistry.lootPot2);
        EXCLUDED_BLOCKS.add(BLBlockRegistry.lootPot3);
        EXCLUDED_BLOCKS.add(BLBlockRegistry.octineBlock);
        EXCLUDED_BLOCKS.add(BLBlockRegistry.valoniteBlock);
        EXCLUDED_BLOCKS.add(BLBlockRegistry.syrmoriteBlock);
    }
}

