/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.player;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.food.ItemRottenFood;
import thebetweenlands.lib.ModInfo;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class OverworldItemEventHandler {
    private static final ImmutableList<Item> EXCEPTION_INSTS;

    @SubscribeEvent
    public void onPlayerTorchPlacement(BlockEvent.PlaceEvent event) {
        ItemStack itemstack = event.player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && event.player.field_71093_bK == ConfigHandler.DIMENSION_ID) {
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        Block block = event.world.func_147439_a(event.x + x, event.y + y, event.z + z);
                        if (block != Blocks.field_150478_aa) continue;
                        int meta = event.world.func_72805_g(event.x + x, event.y + y, event.z + z);
                        event.world.func_147465_d(event.x + x, event.y + y, event.z + z, BLBlockRegistry.dampTorch, meta, 3);
                        event.world.func_72908_a((double)event.x, (double)(event.y + 1), (double)event.z, "random.fizz", 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onUseItem(PlayerInteractEvent event) {
        ItemStack item;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (item = event.entityPlayer.func_70694_bm()) != null && event.entityPlayer.field_71093_bK == ConfigHandler.DIMENSION_ID && item.func_77973_b() == Items.field_151033_d) {
            event.useItem = Event.Result.DENY;
            event.setCanceled(true);
            if (event.world.field_72995_K) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.flintandsteel", new Object[]{new ChatComponentTranslation(item.func_77977_a() + ".name", new Object[0])}));
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && !((EntityPlayer)event.entity).field_71075_bZ.field_75098_d) {
            this.updatePlayerInventory((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70173_aa % 5 == 0 && !event.player.field_71075_bZ.field_75098_d) {
            this.updatePlayerInventory(event.player);
        }
    }

    private void updatePlayerInventory(EntityPlayer player) {
        int invCount = player.field_71071_by.func_70302_i_();
        if (player.field_71093_bK == ModInfo.DIMENSION_ID) {
            for (int i = 0; i < invCount; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null) continue;
                if (this.isRotting(stack)) {
                    ItemStack rottenFoodStack = new ItemStack((Item)BLItemRegistry.rottenFood, stack.field_77994_a);
                    stack.field_77994_a = 1;
                    BLItemRegistry.rottenFood.setOriginalStack(rottenFoodStack, stack);
                    player.field_71071_by.func_70299_a(i, rottenFoodStack);
                    continue;
                }
                if (!this.isTainting(stack)) continue;
                ItemStack taintedPotionStack = new ItemStack((Item)BLItemRegistry.taintedPotion, stack.field_77994_a);
                stack.field_77994_a = 1;
                BLItemRegistry.taintedPotion.setOriginalStack(taintedPotionStack, stack);
                player.field_71071_by.func_70299_a(i, taintedPotionStack);
            }
        } else {
            for (int i = 0; i < invCount; ++i) {
                ItemStack originalStack;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null) continue;
                if (stack.func_77973_b() == BLItemRegistry.rottenFood) {
                    originalStack = BLItemRegistry.rottenFood.getOriginalStack(stack);
                    if (originalStack != null) {
                        originalStack.field_77994_a = stack.field_77994_a;
                        player.field_71071_by.func_70299_a(i, originalStack);
                        continue;
                    }
                    player.field_71071_by.func_70299_a(i, null);
                    continue;
                }
                if (stack.func_77973_b() != BLItemRegistry.taintedPotion) continue;
                originalStack = BLItemRegistry.taintedPotion.getOriginalStack(stack);
                if (originalStack != null) {
                    originalStack.field_77994_a = stack.field_77994_a;
                    player.field_71071_by.func_70299_a(i, originalStack);
                    continue;
                }
                player.field_71071_by.func_70299_a(i, null);
            }
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack;
        if (event.entityPlayer != null && !event.entityPlayer.field_70170_p.field_72995_K && !event.entityPlayer.field_71075_bZ.field_75098_d && (stack = event.item.func_92059_d()) != null) {
            if (event.entityPlayer.field_71093_bK == ModInfo.DIMENSION_ID) {
                if (this.isRotting(stack)) {
                    ItemStack rottenFoodStack = new ItemStack((Item)BLItemRegistry.rottenFood, stack.field_77994_a);
                    BLItemRegistry.rottenFood.setOriginalStack(rottenFoodStack, stack);
                    event.item.func_92058_a(rottenFoodStack);
                } else if (this.isTainting(stack)) {
                    ItemStack taintedPotionStack = new ItemStack((Item)BLItemRegistry.taintedPotion, stack.field_77994_a);
                    BLItemRegistry.taintedPotion.setOriginalStack(taintedPotionStack, stack);
                    event.item.func_92058_a(taintedPotionStack);
                }
            } else if (stack.func_77973_b() == BLItemRegistry.rottenFood) {
                ItemStack originalStack = BLItemRegistry.rottenFood.getOriginalStack(stack);
                if (originalStack != null) {
                    event.item.func_92058_a(originalStack);
                } else {
                    event.item.func_70106_y();
                    event.setCanceled(true);
                }
            } else if (stack.func_77973_b() == BLItemRegistry.taintedPotion) {
                ItemStack originalStack = BLItemRegistry.taintedPotion.getOriginalStack(stack);
                if (originalStack != null) {
                    event.item.func_92058_a(originalStack);
                } else {
                    event.item.func_70106_y();
                    event.setCanceled(true);
                }
            }
        }
    }

    public boolean isRotting(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFood && !EXCEPTION_INSTS.contains((Object)stack.func_77973_b());
    }

    public boolean isTainting(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPotion && !EXCEPTION_INSTS.contains((Object)stack.func_77973_b());
    }

    static {
        ArrayList<ItemRottenFood> items = new ArrayList<ItemRottenFood>();
        items.add(BLItemRegistry.rottenFood);
        items.add((ItemRottenFood)Items.field_151078_bh);
        items.addAll(BLItemRegistry.ITEMS);
        EXCEPTION_INSTS = ImmutableList.copyOf(items);
    }
}

