/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.player;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.decay.DecayStats;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesDecay;
import thebetweenlands.entities.properties.list.EntityPropertiesFood;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.food.IDecayFood;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class FoodSicknessEventHandler {
    public static final FoodSicknessEventHandler INSTANCE = new FoodSicknessEventHandler();
    private ItemStack lastUsedItem = null;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (!(player == null || this.lastUsedItem == null || player.func_70694_bm() != null && player.func_70694_bm().func_77969_a(this.lastUsedItem))) {
            this.lastUsedItem = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addSicknessMessage(EntityPlayer player, ItemStack item, Sickness sickness) {
        if (this.lastUsedItem == null || !item.func_77969_a(this.lastUsedItem)) {
            player.func_146105_b((IChatComponent)new ChatComponentText(sickness.getRandomLine(player.func_70681_au())));
        }
        this.lastUsedItem = item;
    }

    @SubscribeEvent
    public void onStartItemUse(PlayerUseItemEvent.Start event) {
        if (event.entityPlayer != null && event.entityPlayer.field_71093_bK == ConfigHandler.DIMENSION_ID && event.item != null && event.item.func_77973_b() instanceof ItemFood && BLItemRegistry.ITEMS.contains(event.item.func_77973_b())) {
            EntityPropertiesFood property = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityPlayer, EntityPropertiesFood.class);
            ItemFood food = (ItemFood)event.item.func_77973_b();
            Sickness sickness = property.getSickness(food);
            if (event.entityPlayer.field_70170_p.field_72995_K && sickness == Sickness.SICK) {
                this.addSicknessMessage(event.entityPlayer, event.item, sickness);
            }
        }
    }

    @SubscribeEvent
    public void onFinishItemUse(PlayerUseItemEvent.Finish event) {
        if (event.entityPlayer != null && event.entityPlayer.field_71093_bK == ConfigHandler.DIMENSION_ID && event.item != null && event.item.func_77973_b() instanceof ItemFood && BLItemRegistry.ITEMS.contains(event.item.func_77973_b())) {
            EntityPropertiesFood property = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityPlayer, EntityPropertiesFood.class);
            ItemFood food = (ItemFood)event.item.func_77973_b();
            if (event.entityPlayer.field_70170_p.field_72995_K && property.getLastSickness() == Sickness.SICK) {
                this.addSicknessMessage(event.entityPlayer, event.item, property.getSickness(food));
            }
            int prevFoodHatred = property.getFoodHatred(food);
            Sickness currentSickness = property.getSickness(food);
            if (currentSickness == Sickness.SICK) {
                int foodLevel = ((ItemFood)event.item.func_77973_b()).func_150905_g(event.item);
                double foodLoss = 0.6666666666666666;
                if (event.entityPlayer.field_70170_p.field_72995_K) {
                    event.entityPlayer.func_71024_bL().func_75122_a(-Math.min(MathHelper.func_76143_f((double)((double)foodLevel * foodLoss)), foodLevel), 0.0f);
                } else {
                    int minFoodGain = event.entityPlayer.field_70170_p.field_73012_v.nextInt(4) == 0 ? 1 : 0;
                    event.entityPlayer.func_71024_bL().func_75122_a(-Math.min(MathHelper.func_76143_f((double)((double)foodLevel * foodLoss)), Math.max(foodLevel - minFoodGain, 0)), 0.0f);
                }
                if (event.item.func_77973_b() instanceof IDecayFood) {
                    int decayLevel = ((IDecayFood)event.item.func_77973_b()).getDecayHealAmount(event.item);
                    EntityPropertiesDecay props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityPlayer, EntityPropertiesDecay.class);
                    if (props != null) {
                        DecayStats decayStats = props.decayStats;
                        double decayLoss = 0.6666666666666666;
                        if (event.entityPlayer.field_70170_p.field_72995_K) {
                            decayStats.addStats(-Math.min(MathHelper.func_76143_f((double)((double)decayLevel * decayLoss)), decayLevel), 0.0f);
                        } else {
                            int minDecayGain = event.entityPlayer.field_70170_p.field_73012_v.nextInt(4) == 0 ? 1 : 0;
                            decayStats.addStats(-Math.min(MathHelper.func_76143_f((double)((double)decayLevel * decayLoss)), Math.max(decayLevel - minDecayGain, 0)), 0.0f);
                        }
                    }
                }
                if (!event.entityPlayer.field_70170_p.field_72995_K) {
                    property.increaseFoodHatred(food, 5, 0);
                }
            } else if (!event.entityPlayer.field_70170_p.field_72995_K) {
                property.increaseFoodHatred(food, 5, prevFoodHatred <= 10 ? 4 : 3);
            }
        }
    }

    public static enum Sickness {
        FINE(30),
        HALF(60),
        SICK(120);

        public final String[] lines;
        public final int maxHatred;
        public static Sickness[] VALUES;

        private Sickness(int maxHatred) {
            this.maxHatred = maxHatred;
            int index = 0;
            ArrayList<String> lineList = new ArrayList<String>();
            while (StatCollector.func_94522_b((String)("chat.food_sickness." + this.name().toLowerCase() + "." + index))) {
                lineList.add(StatCollector.func_74838_a((String)("chat.food_sickness." + this.name().toLowerCase() + "." + index)));
                ++index;
            }
            this.lines = lineList.toArray(new String[index]);
        }

        public String[] getLines() {
            return this.lines;
        }

        public String getRandomLine(Random rnd) {
            return this.getLines()[rnd.nextInt(this.getLines().length)];
        }

        public static Sickness getSicknessForHatred(int hatred) {
            for (Sickness sickness : VALUES) {
                if (sickness.maxHatred <= hatred) continue;
                return sickness;
            }
            return VALUES[VALUES.length - 1];
        }

        static {
            VALUES = Sickness.values();
        }
    }
}

