/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.player;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import thebetweenlands.decay.DecayManager;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesDecay;
import thebetweenlands.items.food.IDecayFood;
import thebetweenlands.world.BLGamerules;

public class DecayEventHandler {
    public static DecayEventHandler INSTANCE = new DecayEventHandler();
    private int syncTimer = 0;

    private boolean isInRenderRange(EntityPlayer player, double dst) {
        double d1 = player.field_70121_D.func_72320_b();
        return dst < (d1 *= 64.0 * player.field_70155_l) * d1;
    }

    @SubscribeEvent
    public void useItem(PlayerUseItemEvent.Finish event) {
        if (event.item != null && DecayManager.isDecayEnabled(event.entityPlayer) && event.item.func_77973_b() instanceof IDecayFood) {
            IDecayFood food = (IDecayFood)event.item.func_77973_b();
            DecayManager.getDecayStats(event.entityPlayer).addStats(food.getDecayHealAmount(event.item), 0.6f);
        }
    }

    @SubscribeEvent
    public void useItemStart(PlayerUseItemEvent.Start event) {
        if (event.item == null) {
            return;
        }
        boolean isDecayFood = event.item.func_77973_b() instanceof IDecayFood;
        if (isDecayFood) {
            boolean eatDecay;
            boolean eatFood = event.entityPlayer.func_71024_bL().func_75121_c() && event.item.func_77973_b() instanceof ItemFood && ((ItemFood)event.item.func_77973_b()).func_150905_g(event.item) > 0;
            boolean bl = eatDecay = DecayManager.getDecayLevel(event.entityPlayer) < 20;
            if (!eatFood && !eatDecay) {
                event.duration = -1;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (DecayManager.isDecayEnabled(event.player) && event.phase == TickEvent.Phase.END) {
            float maxHealth = (int)(DecayManager.getPlayerHearts(event.player) / 2.0f) * 2;
            event.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
            if (event.player.func_110143_aJ() > maxHealth) {
                event.player.func_70606_j(maxHealth);
            }
            if (DecayManager.getDecayLevel(event.player) <= 4) {
                event.player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 1, 2, true));
                event.player.field_70747_aH = 0.001f;
            } else if (DecayManager.getDecayLevel(event.player) <= 7) {
                event.player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 1, 1, true));
                event.player.field_70747_aH = 0.002f;
            } else if (DecayManager.getDecayLevel(event.player) <= 10) {
                event.player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 1, 0, true));
            }
            if (BLGamerules.getGameRuleBooleanValue("blDecay")) {
                EntityPropertiesDecay prop = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.player, EntityPropertiesDecay.class);
                if (!event.player.field_70170_p.field_72995_K) {
                    prop.decayStats.onUpdate(event.player);
                }
            }
        } else if (event.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() != 20.0) {
            event.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else if (!event.player.field_70170_p.field_72995_K && !BLGamerules.getGameRuleBooleanValue("blDecay") && DecayManager.getDecayLevel(event.player) != 20) {
            DecayManager.setDecayLevel(20, event.player);
        }
    }
}

