/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesFood;
import thebetweenlands.event.item.ExclusionEntry;
import thebetweenlands.event.item.ExclusionEntryClass;
import thebetweenlands.event.player.FoodSicknessEventHandler;
import thebetweenlands.gemcircle.CircleGem;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.ICorrodible;
import thebetweenlands.items.IEquippable;
import thebetweenlands.recipes.misc.CompostRecipe;

public class ItemTooltipHandler {
    public static final ItemTooltipHandler INSTANCE = new ItemTooltipHandler();
    private static final Map<Item, ExclusionEntry> ITEM_EXCLUSIONS = new HashMap<Item, ExclusionEntry>();
    private static final List<ExclusionEntryClass> CLASS_EXCLUSIONS = new ArrayList<ExclusionEntryClass>();
    private static final List<String> NULL_EXCLUSIONS = new ArrayList<String>(0);
    private Minecraft mc = Minecraft.func_71410_x();
    private Field remainingHighlightTicksField = ReflectionHelper.findField(GuiIngame.class, (String[])new String[]{"remainingHighlightTicks", "field_92017_k", "r"});
    private ItemStack highlightingItemStack;
    private int remainingHighlightTicks = 0;

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.mc.field_71474_y.field_92117_D && this.mc.field_71439_g != null) {
            ItemStack itemStack = this.mc.field_71439_g.field_71071_by.func_70448_g();
            if (itemStack == null) {
                this.remainingHighlightTicks = 0;
            } else if (this.highlightingItemStack != null && itemStack.func_77973_b() == this.highlightingItemStack.func_77973_b() && ItemTooltipHandler.areItemStackTagsEqual(itemStack, this.highlightingItemStack, ItemTooltipHandler.getExclusions(itemStack)) && (itemStack.func_77984_f() || itemStack.func_77960_j() == this.highlightingItemStack.func_77960_j())) {
                if (this.remainingHighlightTicks > 0) {
                    --this.remainingHighlightTicks;
                }
            } else {
                this.remainingHighlightTicks = 40;
            }
            this.highlightingItemStack = itemStack;
            this.overrideRemainingHighlightTicks();
        }
    }

    private void overrideRemainingHighlightTicks() {
        try {
            this.remainingHighlightTicksField.set(this.mc.field_71456_v, this.remainingHighlightTicks);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static boolean areItemStackTagsEqual(ItemStack a, ItemStack b, List<String> exclusions) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            if (a.field_77990_d == null && b.field_77990_d == null) {
                return true;
            }
            if (a.field_77990_d == null ^ b.field_77990_d == null) {
                return false;
            }
            return ItemTooltipHandler.areNBTCompoundsEquals(a.field_77990_d, b.field_77990_d, exclusions);
        }
        return false;
    }

    public static boolean areNBTCompoundsEquals(NBTTagCompound a, NBTTagCompound b, List<String> exclusions) {
        Stack<String> tagOwners = new Stack<String>();
        Stack<NBTTagCompound> aTagCompounds = new Stack<NBTTagCompound>();
        Stack<NBTTagCompound> bTagCompounds = new Stack<NBTTagCompound>();
        tagOwners.push("");
        aTagCompounds.push(a);
        bTagCompounds.push(b);
        while (!aTagCompounds.isEmpty()) {
            String tagOwner = (String)tagOwners.pop();
            NBTTagCompound aCurrentTagCompound = (NBTTagCompound)aTagCompounds.pop();
            NBTTagCompound bCurrentTagCompound = (NBTTagCompound)bTagCompounds.pop();
            Set aKeys = aCurrentTagCompound.func_150296_c();
            Set bKeys = bCurrentTagCompound.func_150296_c();
            for (String key : bKeys) {
                if (exclusions.contains(key) || aKeys.contains(key)) continue;
                return false;
            }
            for (String key : aKeys) {
                String totalKey;
                String string = totalKey = tagOwner == "" ? key : tagOwner + '.' + key;
                if (exclusions.contains(totalKey)) continue;
                NBTBase aTag = aCurrentTagCompound.func_74781_a(key);
                NBTBase bTag = bCurrentTagCompound.func_74781_a(key);
                if (aTag instanceof NBTTagCompound && bTag instanceof NBTTagCompound) {
                    tagOwners.push(totalKey);
                    aTagCompounds.push((NBTTagCompound)aTag);
                    bTagCompounds.push((NBTTagCompound)bTag);
                    continue;
                }
                if (aTag.equals((Object)bTag)) continue;
                return false;
            }
        }
        return true;
    }

    public static void registerExclusion(Item item, List<String> exclusionList) {
        ITEM_EXCLUSIONS.put(item, new ExclusionEntry(exclusionList));
    }

    public static void registerExclusion(Class<?> clazz, List<String> exclusionList) {
        CLASS_EXCLUSIONS.add(new ExclusionEntryClass(clazz, exclusionList));
    }

    public static void registerExclusion(Item item, ExclusionEntry entry) {
        ITEM_EXCLUSIONS.put(item, entry);
    }

    private static List<String> getExclusions(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (ITEM_EXCLUSIONS.containsKey(item)) {
            return ITEM_EXCLUSIONS.get(item).getExclusionList(itemStack);
        }
        for (ExclusionEntryClass entry : CLASS_EXCLUSIONS) {
            if (!entry.appliesFor(itemStack)) continue;
            return entry.getExclusionList(itemStack);
        }
        return NULL_EXCLUSIONS;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        EntityPlayer player;
        CircleGem circleGem;
        if (CompostRecipe.getCompostRecipe(event.itemStack) != null) {
            event.toolTip.add(StatCollector.func_74838_a((String)"compost.compostable"));
        }
        if ((circleGem = CircleGem.getGem(event.itemStack)) != CircleGem.NONE) {
            String colorPrefix = "";
            switch (circleGem) {
                case AQUA: {
                    colorPrefix = "\u00a79";
                    break;
                }
                case CRIMSON: {
                    colorPrefix = "\u00a7c";
                    break;
                }
                case GREEN: {
                    colorPrefix = "\u00a7a";
                    break;
                }
            }
            event.toolTip.add(colorPrefix + StatCollector.func_74838_a((String)("circlegem." + circleGem.name)));
        }
        if (event.itemStack.func_77973_b() instanceof ItemFood && event.itemStack.func_77973_b() != BLItemRegistry.chiromawWing && event.itemStack.func_77973_b() != BLItemRegistry.rottenFood && BLItemRegistry.ITEMS.contains(event.itemStack.func_77973_b()) && (player = TheBetweenlands.proxy.getClientPlayer()) != null) {
            EntityPropertiesFood property = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityPlayer, EntityPropertiesFood.class);
            FoodSicknessEventHandler.Sickness sickness = property.getSickness((ItemFood)event.itemStack.func_77973_b());
            event.toolTip.add(StatCollector.func_74838_a((String)("food_sickness.state." + sickness.name().toLowerCase())));
        }
        if (event.itemStack.func_77973_b() instanceof IEquippable) {
            event.toolTip.add(StatCollector.func_74838_a((String)"item.equippable"));
        }
    }

    public static List<String> splitTooltip(String tooltip, int indent) {
        String indentStr = new String(new char[indent]).replace('\u0000', ' ');
        ArrayList<String> lines = new ArrayList<String>();
        String[] splits = tooltip.split("\\\\n");
        for (int i = 0; i < splits.length; ++i) {
            splits[i] = indentStr + splits[i];
        }
        lines.addAll(Arrays.asList(splits));
        return lines;
    }

    static {
        ItemTooltipHandler.registerExclusion(ICorrodible.class, Arrays.asList("Corrosion"));
    }
}

