/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.equipment.EntityPropertiesEquipment;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.items.IEquippable;
import thebetweenlands.network.base.SubscribePacket;
import thebetweenlands.network.packet.client.PacketEquipment;

public class ItemEquipmentHandler {
    public static final ItemEquipmentHandler INSTANCE = new ItemEquipmentHandler();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.tickEquipment(event.world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        World world;
        if (event.phase == TickEvent.Phase.END && (world = TheBetweenlands.proxy.getClientWorld()) != null && !Minecraft.func_71410_x().func_147113_T()) {
            this.tickEquipment(world);
        }
    }

    private void tickEquipment(World world) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            EntityPropertiesEquipment property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesEquipment.class);
            if (property == null) continue;
            EquipmentInventory equipmentInventory = property.getEquipmentInventory();
            for (Equipment equipment : equipmentInventory.getEquipment()) {
                if (equipment.item == null || !(equipment.item.func_77973_b() instanceof IEquippable)) continue;
                ((IEquippable)equipment.item.func_77973_b()).onEquipmentTick(equipment.item, entity);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entityPlayer != null && event.target != null && !(event.target instanceof EntityPlayer)) {
            if (!event.entityPlayer.func_70093_af() && event.entityPlayer.func_70694_bm() != null) {
                EntityPropertiesEquipment property;
                if (event.entityPlayer.func_70694_bm().func_77973_b() instanceof IEquippable && (property = BLEntityPropertiesRegistry.HANDLER.getProperties(event.target, EntityPropertiesEquipment.class)) != null && ((IEquippable)event.entityPlayer.func_70694_bm().func_77973_b()).canEquipOnRightClick(event.entityPlayer.func_70694_bm(), event.entityPlayer, event.target, property.getEquipmentInventory())) {
                    if (ItemEquipmentHandler.tryPlayerEquip(event.entityPlayer, event.target, event.entityPlayer.func_70694_bm())) {
                        event.setCanceled(true);
                    }
                    if (event.entityPlayer.func_70694_bm().field_77994_a <= 0) {
                        event.entityPlayer.func_70062_b(0, null);
                    }
                }
            } else if (event.entityPlayer.func_70093_af() && event.entityPlayer.func_70694_bm() == null && ItemEquipmentHandler.tryPlayerUnequip(event.entityPlayer, event.target)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent event) {
        EntityPropertiesEquipment property;
        if ((event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() instanceof IEquippable && (property = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityPlayer, EntityPropertiesEquipment.class)) != null && ((IEquippable)event.entityPlayer.func_70694_bm().func_77973_b()).canEquipOnRightClick(event.entityPlayer.func_70694_bm(), event.entityPlayer, (Entity)event.entityPlayer, property.getEquipmentInventory())) {
            ItemEquipmentHandler.tryPlayerEquip(event.entityPlayer, (Entity)event.entityPlayer, event.entityPlayer.func_70694_bm());
            if (event.entityPlayer.func_70694_bm().field_77994_a <= 0) {
                event.entityPlayer.func_70062_b(0, null);
            }
        }
    }

    public static boolean tryPlayerEquip(EntityPlayer player, Entity target, ItemStack stack) {
        if (EquipmentInventory.equipItem(player, target, stack) != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            player.func_71038_i();
            return true;
        }
        return false;
    }

    public static boolean tryPlayerUnequip(EntityPlayer player, Entity target) {
        ItemStack unequipped = EquipmentInventory.unequipItem(player, target);
        if (unequipped != null) {
            if (!player.field_71071_by.func_70441_a(unequipped)) {
                target.func_70099_a(unequipped, target.func_70047_e());
            }
            player.func_71038_i();
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onDeathDrops(LivingDropsEvent event) {
        EquipmentInventory equipmentInventory;
        EntityLivingBase entity = event.entityLiving;
        if (entity != null && !entity.field_70170_p.field_72995_K && !entity.field_70170_p.func_82736_K().func_82766_b("keepInventory") && (equipmentInventory = EquipmentInventory.getEquipmentInventory(event.entity)) != null) {
            for (Equipment equipment : equipmentInventory.getEquipment()) {
                if (!((IEquippable)equipment.item.func_77973_b()).canDrop(equipment.item, (Entity)entity, equipmentInventory)) continue;
                EntityItem equipmentDrop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, equipment.item.func_77946_l());
                equipmentDrop.field_145804_b = 10;
                event.drops.add(equipmentDrop);
            }
        }
    }

    @SubscribePacket
    public static void onPacketEquipment(PacketEquipment packet) {
        EntityPlayerMP sender;
        if (packet.getContext().getServerHandler() != null && (sender = packet.getContext().getServerHandler().field_147369_b) != null) {
            EquipmentInventory equipmentInventory = EquipmentInventory.getEquipmentInventory((Entity)sender);
            switch (packet.getMode()) {
                default: {
                    IEquippable equippable;
                    ItemStack item;
                    if (packet.getSlot() >= sender.field_71071_by.func_70302_i_() || (item = sender.field_71071_by.func_70301_a(packet.getSlot())) == null || !(item.func_77973_b() instanceof IEquippable) || !(equippable = (IEquippable)item.func_77973_b()).canEquip(item, (EntityPlayer)sender, (Entity)sender, equipmentInventory)) break;
                    ItemEquipmentHandler.tryPlayerEquip((EntityPlayer)sender, (Entity)sender, item);
                    if (item.field_77994_a > 0) break;
                    sender.field_71071_by.func_70299_a(packet.getSlot(), null);
                    break;
                }
                case 1: {
                    Equipment equipment;
                    if (packet.getSlot() >= equipmentInventory.getEquipment().size() || (equipment = equipmentInventory.getEquipment().get(packet.getSlot())) == null || !equipment.equippable.canUnequip(equipment.item, (EntityPlayer)sender, (Entity)sender, equipmentInventory)) break;
                    EquipmentInventory.unequipItem((Entity)sender, equipment);
                    if (sender.field_71071_by.func_70441_a(equipment.item)) break;
                    sender.func_70099_a(equipment.item, sender.func_70047_e());
                }
            }
        }
    }
}

