/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.entity;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.EntityBerserkerGuardian;
import thebetweenlands.entities.mobs.EntityDreadfulMummy;
import thebetweenlands.entities.mobs.EntityMeleeGuardian;
import thebetweenlands.entities.mobs.EntityTempleGuardian;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBoss;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.entities.properties.list.recruitment.EntityPropertiesRecruit;
import thebetweenlands.entities.properties.list.recruitment.EntityPropertiesRecruiter;
import thebetweenlands.items.equipment.ItemRingOfRecruitment;
import thebetweenlands.network.base.SubscribePacket;
import thebetweenlands.network.packet.client.PacketRecruitmentState;

public class RecruitmentRingHandler {
    public static final RecruitmentRingHandler INSTANCE = new RecruitmentRingHandler();
    private static final List<Class<? extends EntityLivingBase>> DISALOWWED_ENTITIES = new ArrayList<Class<? extends EntityLivingBase>>();
    private boolean ignoreSetAttackTarget = false;
    private boolean wasPressed = false;

    @SubscribeEvent
    public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (!this.ignoreSetAttackTarget) {
            EntityPropertiesRecruit props;
            if (event.entityLiving instanceof EntityLiving && ((EntityLiving)event.entityLiving).func_70638_az() != null && (props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityLiving, EntityPropertiesRecruit.class)) != null && props.isRecruited() && event.target == props.getRecruiter()) {
                this.ignoreSetAttackTarget = true;
                EntityLivingBase newTarget = props.getMobToAttack();
                ((EntityLiving)event.entityLiving).func_70624_b(newTarget);
                event.entityLiving.func_70604_c(newTarget);
                if (event.entityLiving instanceof EntityCreature) {
                    EntityCreature creature = (EntityCreature)event.entityLiving;
                    creature.func_70784_b((Entity)newTarget);
                }
            }
        } else {
            this.ignoreSetAttackTarget = false;
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPropertiesRecruit props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityLiving, EntityPropertiesRecruit.class);
        if (props != null && props.isRecruited()) {
            if (event.entityLiving.field_70170_p.field_72995_K) {
                BLParticle.PORTAL.spawn(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + (double)(event.entityLiving.func_70047_e() / 4.0f * 3.0f), event.entityLiving.field_70161_v, (event.entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f, (event.entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f, (event.entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f, 1.0f, new Object[0]);
            } else {
                props.update();
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entityPlayer != null && event.target instanceof EntityLiving && !event.entityPlayer.field_70170_p.field_72995_K && !DISALOWWED_ENTITIES.contains(event.target.getClass())) {
            EquipmentInventory equipmentInventory = EquipmentInventory.getEquipmentInventory((Entity)event.entityPlayer);
            List<Equipment> equipmentList = equipmentInventory.getEquipment(EnumEquipmentCategory.RING);
            for (Equipment equipment : equipmentList) {
                EntityPropertiesRecruiter prop;
                if (!(equipment.item.func_77973_b() instanceof ItemRingOfRecruitment) || !((ItemRingOfRecruitment)equipment.item.func_77973_b()).isActive(equipment.item) || (prop = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.entityPlayer, EntityPropertiesRecruiter.class)) == null || prop.isRecruiting() || !prop.canRecruit()) continue;
                prop.startRecruiting((EntityLiving)event.target);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPropertiesRecruiter prop;
        if (event.phase == TickEvent.Phase.START && event.player != null && (prop = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)event.player, EntityPropertiesRecruiter.class)) != null && prop.isRecruiting()) {
            if (event.player.field_70170_p.field_72995_K) {
                Vec3 vec = Vec3.func_72443_a((double)(prop.getRecruit().field_70165_t - event.player.field_70165_t), (double)(prop.getRecruit().field_70163_u + (double)prop.getRecruit().func_70047_e() - event.player.field_70163_u), (double)(prop.getRecruit().field_70161_v - event.player.field_70161_v));
                vec = vec.func_72432_b();
                vec = vec.func_72441_c((double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f), (double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f), (double)((event.player.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 3.0f));
                vec = vec.func_72432_b();
                double dist = event.player.func_70032_d((Entity)prop.getRecruit());
                vec = Vec3.func_72443_a((double)(vec.field_72450_a * dist / 15.0), (double)(vec.field_72448_b * dist / 15.0), (double)(vec.field_72449_c * dist / 15.0));
                BLParticle.PORTAL.spawn(event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u + (double)event.player.func_70047_e(), event.player.field_70161_v, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.0f, new Object[0]);
            } else {
                prop.update();
            }
            event.player.field_70159_w *= 0.05;
            event.player.field_70179_y *= 0.05;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onInput(InputEvent event) {
        this.updateClientRecruitmentState();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClientRecruitmentState() {
        if (!this.wasPressed && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            this.wasPressed = true;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketRecruitmentState(true)));
        } else if (this.wasPressed && !Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            this.wasPressed = false;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketRecruitmentState(false)));
        }
    }

    @SubscribePacket
    public static void onPacketEquipment(PacketRecruitmentState packet) {
        EntityPropertiesRecruiter prop;
        EntityPlayerMP sender;
        if (!packet.isPressed() && packet.getContext().getServerHandler() != null && (sender = packet.getContext().getServerHandler().field_147369_b) != null && (prop = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)sender, EntityPropertiesRecruiter.class)) != null) {
            prop.stopRecruiting();
        }
    }

    static {
        DISALOWWED_ENTITIES.add(EntityWight.class);
        DISALOWWED_ENTITIES.add(EntityTempleGuardian.class);
        DISALOWWED_ENTITIES.add(EntityMeleeGuardian.class);
        DISALOWWED_ENTITIES.add(EntityBerserkerGuardian.class);
        DISALOWWED_ENTITIES.add(EntityDreadfulMummy.class);
        DISALOWWED_ENTITIES.add(EntityFortressBoss.class);
    }
}

