/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.entity;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import thebetweenlands.entities.mobs.EntityDreadfulMummy;
import thebetweenlands.entities.mobs.EntityPeatMummy;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.entities.mobs.EntityTarBeast;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.gemcircle.CircleGem;
import thebetweenlands.gemcircle.EntityGem;
import thebetweenlands.items.equipment.ItemAmulet;

public class EntitySpawnHandler {
    public static final EntitySpawnHandler INSTANCE = new EntitySpawnHandler();
    public static final int AMULET_SPAWN_CHANCE = 40;
    public static final List<Class<? extends EntityLivingBase>> AMULET_SPAWNS = new ArrayList<Class<? extends EntityLivingBase>>();

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        EntityThrowable entityThrown;
        if (event.entity instanceof EntityArrow) {
            EntityArrow entityArrow = (EntityArrow)event.entity;
            if (entityArrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase source = (EntityLivingBase)entityArrow.field_70250_c;
                this.copyGemModifier(source, (Entity)entityArrow);
            }
        }
        if (event.entity instanceof EntityThrowable && (entityThrown = (EntityThrowable)event.entity).func_85052_h() != null) {
            this.copyGemModifier(entityThrown.func_85052_h(), (Entity)entityThrown);
        }
        if (AMULET_SPAWNS.contains(event.entity.getClass()) && event.entity.getEntityData() != null && event.entity.field_70170_p.field_73012_v.nextInt(40) == 0) {
            CircleGem gem = CircleGem.TYPES[event.entity.field_70170_p.field_73012_v.nextInt(CircleGem.TYPES.length - 1)];
            ItemAmulet.addAmulet(gem, event.entity, false, false);
        }
    }

    private void copyGemModifier(EntityLivingBase source, Entity entity) {
        CircleGem gem;
        if (source.func_70694_bm() != null && (gem = CircleGem.getGem(source.func_70694_bm())) != CircleGem.NONE) {
            CircleGem.addGem(entity, gem, EntityGem.Type.OFFENSIVE);
        }
    }

    static {
        AMULET_SPAWNS.add(EntitySwampHag.class);
        AMULET_SPAWNS.add(EntityDreadfulMummy.class);
        AMULET_SPAWNS.add(EntityPeatMummy.class);
        AMULET_SPAWNS.add(EntityTarBeast.class);
        AMULET_SPAWNS.add(EntityWight.class);
    }
}

