/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.elixirs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBow;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import thebetweenlands.herblore.elixirs.ElixirEffectRegistry;

public class ElixirCommonHandler {
    public static final ElixirCommonHandler INSTANCE = new ElixirCommonHandler();
    private boolean ignoreSetAttackTarget = false;
    private static final AttributeModifier FOLLOW_RANGE_MODIFIER = new AttributeModifier("24ce3c60-ae87-4e31-8fc3-bf3f40ab37ca", 10.0, 0);

    @SubscribeEvent
    public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (!this.ignoreSetAttackTarget) {
            if (event.entityLiving instanceof EntityLiving && ((EntityLiving)event.entityLiving).func_70638_az() != null && !ElixirEffectRegistry.EFFECT_MASKING.canEntityBeSeenBy(((EntityLiving)event.entityLiving).func_70638_az(), event.entityLiving)) {
                this.ignoreSetAttackTarget = true;
                ((EntityLiving)event.entityLiving).func_70624_b(null);
            }
        } else {
            this.ignoreSetAttackTarget = false;
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        if (player != null) {
            if (ElixirEffectRegistry.EFFECT_SWIFTARM.isActive((EntityLivingBase)player) && ElixirEffectRegistry.EFFECT_SWIFTARM.getStrength((EntityLivingBase)player) >= 0) {
                event.newSpeed *= 1.0f + (float)(ElixirEffectRegistry.EFFECT_SWIFTARM.getStrength((EntityLivingBase)player) + 1) * 0.3f;
            }
            if (ElixirEffectRegistry.EFFECT_SLUGARM.isActive((EntityLivingBase)player) && ElixirEffectRegistry.EFFECT_SLUGARM.getStrength((EntityLivingBase)player) >= 0) {
                event.newSpeed /= 1.0f + (float)(ElixirEffectRegistry.EFFECT_SLUGARM.getStrength((EntityLivingBase)player) + 1) * 0.3f;
            }
        }
    }

    @SubscribeEvent
    public void onStartUseItem(PlayerUseItemEvent.Start event) {
        EntityPlayer player = event.entityPlayer;
        if (player != null) {
            float newDuration;
            if (ElixirEffectRegistry.EFFECT_SWIFTARM.isActive((EntityLivingBase)player) && ElixirEffectRegistry.EFFECT_SWIFTARM.getStrength((EntityLivingBase)player) >= 0) {
                newDuration = event.duration;
                event.duration = MathHelper.func_76123_f((float)(newDuration *= 1.0f - 0.125f * (float)(ElixirEffectRegistry.EFFECT_SWIFTARM.getStrength((EntityLivingBase)player) + 1)));
            }
            if (ElixirEffectRegistry.EFFECT_SLUGARM.isActive((EntityLivingBase)player) && ElixirEffectRegistry.EFFECT_SLUGARM.getStrength((EntityLivingBase)player) >= 0 && event.item != null && !(event.item.func_77973_b() instanceof ItemBow)) {
                newDuration = event.duration;
                event.duration = MathHelper.func_76123_f((float)(newDuration /= 1.0f - 0.125f * (float)(ElixirEffectRegistry.EFFECT_SLUGARM.getStrength((EntityLivingBase)player) + 1)));
            }
        }
    }

    @SubscribeEvent
    public void onShootArrow(ArrowLooseEvent event) {
        if (ElixirEffectRegistry.EFFECT_WEAKBOW.isActive(event.entityLiving)) {
            event.charge = Math.min(event.charge, 10);
            event.charge = (int)((float)event.charge * (1.0f - (float)(ElixirEffectRegistry.EFFECT_WEAKBOW.getStrength(event.entityLiving) + 1) / 4.0f * 0.75f));
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLiving entityLiving;
        IAttributeInstance followRangeAttrib;
        Block blockBelow;
        float relStrength;
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (ElixirEffectRegistry.EFFECT_SPIDERBREED.isActive(entityLivingBase)) {
            int strength = ElixirEffectRegistry.EFFECT_SPIDERBREED.getStrength(entityLivingBase);
            relStrength = Math.min((float)(strength + 1) / 4.0f, 1.0f);
            Vec3 lookVec = entityLivingBase.func_70040_Z().func_72432_b();
            if (entityLivingBase.field_70701_bs < 0.0f) {
                lookVec.field_72448_b *= -1.0;
            }
            if ((!entityLivingBase.field_70122_E || this.isEntityOnWall(entityLivingBase)) && (entityLivingBase.field_70123_F || entityLivingBase.field_70124_G)) {
                entityLivingBase.field_70181_x = entityLivingBase instanceof EntityPlayer ? lookVec.field_72448_b * (double)0.22f * (double)relStrength : (double)(0.22f * relStrength);
            }
            if (!entityLivingBase.field_70122_E && this.isEntityOnWall(entityLivingBase)) {
                if (entityLivingBase.field_70181_x < 0.0 && (lookVec.field_72448_b > 0.0 || entityLivingBase.field_70701_bs == 0.0f && entityLivingBase.field_70702_br == 0.0f)) {
                    entityLivingBase.field_70181_x *= (double)(0.9f - relStrength * 0.5f);
                }
                if (entityLivingBase.func_70093_af()) {
                    entityLivingBase.field_70181_x *= (double)(0.15f * (1.0f - relStrength));
                }
                entityLivingBase.field_70159_w *= (double)relStrength;
                entityLivingBase.field_70179_y *= (double)relStrength;
                entityLivingBase.field_70143_R = 0.0f;
            }
        }
        if (ElixirEffectRegistry.EFFECT_LIGHTWEIGHT.isActive(entityLivingBase) && !entityLivingBase.func_70090_H() && (blockBelow = entityLivingBase.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entityLivingBase.field_70165_t), MathHelper.func_76128_c((double)(entityLivingBase.field_70121_D.field_72338_b - 0.1)), MathHelper.func_76128_c((double)entityLivingBase.field_70161_v))).func_149688_o().func_76224_d()) {
            relStrength = Math.min((float)ElixirEffectRegistry.EFFECT_LIGHTWEIGHT.getStrength(entityLivingBase) / 4.0f, 1.0f);
            entityLivingBase.field_70159_w *= (double)(0.1f + relStrength * 0.9f);
            entityLivingBase.field_70179_y *= (double)(0.1f + relStrength * 0.9f);
            if (entityLivingBase.field_70181_x < 0.0) {
                entityLivingBase.field_70181_x = 0.0;
            }
            entityLivingBase.field_70122_E = true;
            entityLivingBase.field_70143_R = 0.0f;
        }
        if (entityLivingBase.func_70090_H() && ElixirEffectRegistry.EFFECT_HEAVYWEIGHT.isActive(entityLivingBase) && entityLivingBase.field_70181_x > (double)-0.1f) {
            entityLivingBase.field_70181_x -= (double)0.04f;
        }
        if (ElixirEffectRegistry.EFFECT_CATSEYES.isActive(entityLivingBase)) {
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76439_r.func_76396_c(), ElixirEffectRegistry.EFFECT_CATSEYES.getDuration(entityLivingBase), ElixirEffectRegistry.EFFECT_CATSEYES.getStrength(entityLivingBase)));
            ElixirEffectRegistry.EFFECT_CATSEYES.removeElixir(entityLivingBase);
        }
        if (ElixirEffectRegistry.EFFECT_POISONSTING.isActive(entityLivingBase)) {
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), ElixirEffectRegistry.EFFECT_POISONSTING.getDuration(entityLivingBase), ElixirEffectRegistry.EFFECT_POISONSTING.getStrength(entityLivingBase)));
            ElixirEffectRegistry.EFFECT_POISONSTING.removeElixir(entityLivingBase);
        }
        if (ElixirEffectRegistry.EFFECT_DRUNKARD.isActive(entityLivingBase)) {
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76431_k.func_76396_c(), ElixirEffectRegistry.EFFECT_DRUNKARD.getDuration(entityLivingBase), ElixirEffectRegistry.EFFECT_DRUNKARD.getStrength(entityLivingBase)));
            ElixirEffectRegistry.EFFECT_DRUNKARD.removeElixir(entityLivingBase);
        }
        if (ElixirEffectRegistry.EFFECT_BLINDMAN.isActive(entityLivingBase)) {
            entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), ElixirEffectRegistry.EFFECT_BLINDMAN.getDuration(entityLivingBase), ElixirEffectRegistry.EFFECT_BLINDMAN.getStrength(entityLivingBase)));
            ElixirEffectRegistry.EFFECT_BLINDMAN.removeElixir(entityLivingBase);
        }
        if (!(entityLivingBase instanceof EntityPlayer) && entityLivingBase instanceof EntityMob && (followRangeAttrib = (entityLiving = (EntityLiving)entityLivingBase).func_110148_a(SharedMonsterAttributes.field_111265_b)) != null) {
            List<EntityPlayer> stenchingPlayers = this.getStenchingPlayersInRange((EntityLivingBase)entityLiving);
            if (stenchingPlayers.isEmpty()) {
                if (followRangeAttrib.func_111127_a(FOLLOW_RANGE_MODIFIER.func_111167_a()) != null) {
                    followRangeAttrib.func_111124_b(FOLLOW_RANGE_MODIFIER);
                }
            } else {
                AttributeModifier currentModifier = followRangeAttrib.func_111127_a(FOLLOW_RANGE_MODIFIER.func_111167_a());
                if (entityLiving.func_70638_az() == null || entityLiving.func_70643_av() == null || entityLiving instanceof EntityCreature && ((EntityCreature)entityLiving).func_70777_m() == null) {
                    EntityPlayer closestPlayer = null;
                    for (EntityPlayer player : stenchingPlayers) {
                        if (closestPlayer != null && !(player.func_70068_e((Entity)entityLiving) < closestPlayer.func_70068_e((Entity)entityLiving))) continue;
                        closestPlayer = player;
                    }
                    if (entityLiving.field_70173_aa % 20 == 0) {
                        boolean shouldApplyModifier;
                        int strength = ElixirEffectRegistry.EFFECT_STENCHING.getStrength((EntityLivingBase)closestPlayer);
                        AttributeModifier stenchModifier = this.getFollowRangeModifier(strength);
                        boolean bl = shouldApplyModifier = currentModifier == null || currentModifier.func_111164_d() < stenchModifier.func_111164_d();
                        if (shouldApplyModifier) {
                            if (currentModifier != null) {
                                followRangeAttrib.func_111124_b(currentModifier);
                            }
                            followRangeAttrib.func_111121_a(this.getFollowRangeModifier(strength));
                        }
                        entityLiving.func_70624_b((EntityLivingBase)closestPlayer);
                        entityLiving.func_70604_c((EntityLivingBase)closestPlayer);
                        if (entityLiving instanceof EntityCreature) {
                            ((EntityCreature)entityLiving).func_70784_b((Entity)closestPlayer);
                        }
                    }
                }
            }
        }
    }

    private AttributeModifier getFollowRangeModifier(int strength) {
        return new AttributeModifier(FOLLOW_RANGE_MODIFIER.func_111167_a(), FOLLOW_RANGE_MODIFIER.func_111166_b() + " " + strength, FOLLOW_RANGE_MODIFIER.func_111164_d() / 4.0 * (double)Math.min(strength, 4), FOLLOW_RANGE_MODIFIER.func_111169_c());
    }

    private List<EntityPlayer> getStenchingPlayersInRange(EntityLivingBase entity) {
        ArrayList<EntityPlayer> playerList = new ArrayList<EntityPlayer>();
        for (EntityPlayer player : entity.field_70170_p.field_73010_i) {
            if (!ElixirEffectRegistry.EFFECT_STENCHING.isActive((EntityLivingBase)player)) continue;
            int strength = ElixirEffectRegistry.EFFECT_STENCHING.getStrength((EntityLivingBase)player);
            double spottingRange = this.getSpottingRange(entity, strength);
            if (!(player.func_70068_e((Entity)entity) <= spottingRange * spottingRange)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    private double getSpottingRange(EntityLivingBase entity, int strength) {
        IAttributeInstance followRangeAttrib = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
        AttributeModifier rangeMod = followRangeAttrib.func_111127_a(FOLLOW_RANGE_MODIFIER.func_111167_a());
        if (rangeMod != null) {
            followRangeAttrib.func_111124_b(rangeMod);
        }
        AttributeModifier tempRangeMod = this.getFollowRangeModifier(strength);
        followRangeAttrib.func_111121_a(tempRangeMod);
        double spottingRange = followRangeAttrib == null ? 16.0 + FOLLOW_RANGE_MODIFIER.func_111164_d() / 4.0 * (double)Math.min(strength, 4) : followRangeAttrib.func_111126_e();
        followRangeAttrib.func_111124_b(tempRangeMod);
        if (rangeMod != null) {
            followRangeAttrib.func_111121_a(rangeMod);
        }
        return spottingRange;
    }

    private boolean isEntityOnWall(EntityLivingBase entity) {
        AxisAlignedBB bb = entity.field_70121_D.func_72314_b(0.05, 0.05, 0.05);
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)(bb.field_72338_b + 0.06));
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e - 0.06) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    AxisAlignedBB boundingBox;
                    Block block = entity.field_70170_p.func_147439_a(x2, y2, z2);
                    if (block != null && block.func_149703_v() && (boundingBox = block.func_149668_a(entity.field_70170_p, x2, y2, z2)) != null && boundingBox.func_72326_a(bb)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase living = event.entityLiving;
        if (ElixirEffectRegistry.EFFECT_LIGHTWEIGHT.isActive(living)) {
            float relStrength = Math.min((float)ElixirEffectRegistry.EFFECT_LIGHTWEIGHT.getStrength(living) / 9.0f, 0.4f);
            living.field_70181_x *= (double)(1.0f + relStrength);
        }
    }
}

