/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.elixirs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.event.elixirs.ArrowPredictionRenderer;
import thebetweenlands.herblore.elixirs.ElixirEffectRegistry;

public class ElixirClientHandler {
    public static final ElixirClientHandler INSTANCE = new ElixirClientHandler();
    private Map<Entity, EntityTrail> entityTrails = new HashMap<Entity, EntityTrail>();
    private Vec3 playerPos;
    private final Comparator<TrailPos> dstSorter = new Comparator<TrailPos>(){

        @Override
        public int compare(TrailPos v1, TrailPos v2) {
            double d2;
            double d1 = v1.pos.func_72438_d(ElixirClientHandler.this.playerPos);
            if (d1 < (d2 = v2.pos.func_72438_d(ElixirClientHandler.this.playerPos))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    };
    private final Method f_swingHand = ReflectionHelper.findMethod(Minecraft.class, null, (String[])new String[]{"func_147116_af", "al"}, (Class[])new Class[0]);
    private final Method f_damageBlock = ReflectionHelper.findMethod(Minecraft.class, null, (String[])new String[]{"func_147115_a", "a"}, (Class[])new Class[]{Boolean.TYPE});

    public EntityTrail getTrail(Entity entity) {
        EntityTrail trail = this.entityTrails.get(entity);
        if (trail == null) {
            trail = new EntityTrail(entity);
            this.entityTrails.put(entity, trail);
        }
        return trail;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase == TickEvent.Phase.END) {
            if (player != null && player.field_70170_p != null && player.field_70170_p.field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
                int strength;
                if (ElixirEffectRegistry.EFFECT_HUNTERSSENSE.isActive((EntityLivingBase)player)) {
                    Map.Entry<Entity, EntityTrail> entry;
                    Vec3 pos;
                    strength = ElixirEffectRegistry.EFFECT_HUNTERSSENSE.getStrength((EntityLivingBase)player);
                    World world = player.field_70170_p;
                    List entityList = world.func_72872_a(Entity.class, player.field_70121_D.func_72314_b(50.0, 50.0, 50.0));
                    ArrayList<TrailPos> availablePositions = new ArrayList<TrailPos>();
                    for (Entity e : entityList) {
                        if (e == player) continue;
                        EntityTrail trail = this.getTrail(e);
                        trail.update(strength);
                        TrailPos lastPos = null;
                        for (int i = 0; i < trail.cachedPositions.size(); ++i) {
                            pos = (Vec3)trail.cachedPositions.get(i);
                            if (lastPos != null) {
                                lastPos.nextPos = pos;
                            }
                            TrailPos tp = new TrailPos(pos, i, e);
                            availablePositions.add(tp);
                            lastPos = tp;
                        }
                    }
                    this.playerPos = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
                    Collections.sort(availablePositions, this.dstSorter);
                    int maxPointCount = 200;
                    int pointCount = Math.min(maxPointCount, availablePositions.size());
                    int crawlTicks = MathHelper.func_76128_c((double)(140.0f - 30.0f * (float)strength));
                    for (int i = 0; i < pointCount; ++i) {
                        TrailPos tp = (TrailPos)availablePositions.get(i);
                        if ((player.field_70173_aa - MathHelper.func_76141_d((float)((float)crawlTicks / 80.0f * (float)tp.index))) % crawlTicks != 0) continue;
                        pos = tp.pos;
                        if (tp.nextPos != null) {
                            int subSegments = 10;
                            Vec3 nextPos = tp.nextPos;
                            for (int s = 0; s <= subSegments; ++s) {
                                if ((player.field_70173_aa - MathHelper.func_76141_d((float)((float)crawlTicks / 80.0f * ((float)tp.index + (float)s / (float)subSegments)))) % crawlTicks != 0) continue;
                                double tpx = pos.field_72450_a + 0.5;
                                double tpy = pos.field_72448_b + (double)0.05f;
                                double tpz = pos.field_72449_c + 0.5;
                                double tpx2 = nextPos.field_72450_a + 0.5;
                                double tpy2 = nextPos.field_72448_b;
                                double tpz2 = nextPos.field_72449_c + 0.5;
                                double tpxi = tpx + (tpx2 - tpx) / (double)subSegments * (double)s;
                                double tpyi = tpy + (tpy2 - tpy) / (double)subSegments * (double)s;
                                double tpzi = tpz + (tpz2 - tpz) / (double)subSegments * (double)s;
                                BLParticle.BUBBLE_PRUIFIER.spawn(world, tpxi, tpyi, tpzi, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                            }
                            continue;
                        }
                        double tpx = pos.field_72450_a + 0.5;
                        double tpy = pos.field_72448_b + (double)0.05f;
                        double tpz = pos.field_72449_c + 0.5;
                        BLParticle.BUBBLE_PRUIFIER.spawn(world, tpx, tpy, tpz, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    }
                    Iterator<Map.Entry<Entity, EntityTrail>> it = this.entityTrails.entrySet().iterator();
                    while (it.hasNext() && (entry = it.next()) != null) {
                        EntityTrail trail = entry.getValue();
                        if (trail.entity != null && !((EntityTrail)trail).entity.field_70128_L && entityList.contains(entry.getKey())) continue;
                        it.remove();
                    }
                } else {
                    this.entityTrails.clear();
                }
                if (ElixirEffectRegistry.EFFECT_SWIFTARM.isActive((EntityLivingBase)player) && Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && !player.func_70632_aY()) {
                    try {
                        MovingObjectPosition target = Minecraft.func_71410_x().field_71476_x;
                        if (target == null || target.field_72308_g != null || target.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
                            this.f_swingHand.invoke((Object)Minecraft.func_71410_x(), new Object[0]);
                        } else if (target != null && !player.field_82175_bq) {
                            this.f_damageBlock.invoke((Object)Minecraft.func_71410_x(), true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ElixirEffectRegistry.EFFECT_SLUGARM.isActive((EntityLivingBase)player) && player.field_82175_bq) {
                    strength = ElixirEffectRegistry.EFFECT_SLUGARM.getStrength((EntityLivingBase)player);
                    if (player.field_110158_av != 0) {
                        --player.field_110158_av;
                        if (player.field_70173_aa % (2 << strength) == 0) {
                            ++player.field_110158_av;
                        }
                        if (player.field_70732_aI < player.field_70733_aJ) {
                            player.field_70733_aJ -= player.field_70733_aJ - player.field_70732_aI;
                            player.field_70732_aI = player.field_70733_aJ;
                            player.field_70733_aJ += 0.16666667f / (float)(2 << strength);
                        }
                        if (player.field_110158_av < 0 || player.field_70733_aJ < 0.0f) {
                            player.field_110158_av = 0;
                            player.field_70733_aJ = 0.0f;
                        }
                    }
                }
            } else {
                this.entityTrails.clear();
            }
        }
    }

    @SubscribeEvent
    public void onShootArrow(ArrowLooseEvent event) {
        if (event.entityPlayer == Minecraft.func_71410_x().field_71439_g) {
            ArrowPredictionRenderer.setRandomYawPitch();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p != null && ElixirEffectRegistry.EFFECT_SAGITTARIUS.isActive((EntityLivingBase)player)) {
            ArrowPredictionRenderer.render(Math.min((float)(ElixirEffectRegistry.EFFECT_SAGITTARIUS.getStrength((EntityLivingBase)player) + 1) / 3.0f, 1.0f));
        }
    }

    private static class TrailPos {
        private final Vec3 pos;
        private Vec3 nextPos;
        private final Entity entity;
        private final int index;

        private TrailPos(Vec3 pos, int index, Entity entity) {
            this.pos = pos;
            this.index = index;
            this.entity = entity;
        }
    }

    private static class EntityTrail {
        private static final int MAX_CACHE_SIZE = 80;
        private Entity entity;
        private List<Vec3> cachedPositions = new ArrayList<Vec3>();

        private EntityTrail(Entity entity) {
            this.entity = entity;
        }

        private void update(int strength) {
            if (this.entity != null && !this.entity.field_70128_L) {
                Vec3 newPos = Vec3.func_72443_a((double)this.entity.field_70165_t, (double)this.entity.field_70163_u, (double)this.entity.field_70161_v);
                if (this.cachedPositions.size() > 0) {
                    Vec3 lastPos = this.cachedPositions.get(this.cachedPositions.size() - 1);
                    if (lastPos.func_72438_d(newPos) > 0.5) {
                        this.cachedPositions.add(newPos);
                    }
                    if (this.cachedPositions.size() > 80 + 20 * (strength + 1)) {
                        this.cachedPositions.remove(0);
                    }
                } else {
                    this.cachedPositions.add(newPos);
                }
            }
        }
    }
}

