/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.elixirs;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ArrowPredictionRenderer {
    private static float randYaw = 0.0f;
    private static float randPitch = 0.0f;
    private static boolean randomYawPitchSet = false;
    private static float lastQuality = 0.0f;

    public static void setRandomYawPitch() {
        randomYawPitchSet = false;
    }

    public static void render(float quality) {
        if (Minecraft.func_71410_x().field_71439_g.func_71045_bC() == null || !(Minecraft.func_71410_x().field_71439_g.func_71045_bC().func_77973_b() instanceof ItemBow)) {
            randomYawPitchSet = false;
            return;
        }
        if (lastQuality != quality || !randomYawPitchSet) {
            randomYawPitchSet = true;
            lastQuality = quality;
            float maxOffset = 3.0f;
            randYaw = (maxOffset / 2.0f - Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat() * maxOffset * 2.0f) * (1.0f - quality);
            randPitch = (maxOffset / 2.0f - Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat() * maxOffset * 2.0f) * (1.0f - quality);
        }
        int maxDur = Minecraft.func_71410_x().field_71439_g.func_71045_bC().func_77973_b().func_77626_a(Minecraft.func_71410_x().field_71439_g.func_71045_bC()) - Minecraft.func_71410_x().field_71439_g.func_71052_bv();
        float strength = (float)maxDur / 20.0f;
        if ((strength = (strength * strength + strength * 2.0f) / 3.0f) < 0.1f || strength > 1.0f) {
            strength = 1.0f;
        }
        double px = Minecraft.func_71410_x().field_71439_g.field_70165_t;
        double py = Minecraft.func_71410_x().field_71439_g.field_70163_u;
        double pz = Minecraft.func_71410_x().field_71439_g.field_70161_v;
        float pYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z;
        float pPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        Minecraft.func_71410_x().field_71439_g.field_70165_t = RenderManager.field_78725_b;
        Minecraft.func_71410_x().field_71439_g.field_70163_u = RenderManager.field_78726_c;
        Minecraft.func_71410_x().field_71439_g.field_70161_v = RenderManager.field_78723_d;
        Minecraft.func_71410_x().field_71439_g.field_70177_z += randYaw;
        Minecraft.func_71410_x().field_71439_g.field_70125_A += randPitch;
        EntityArrowSilent ea = new EntityArrowSilent((World)Minecraft.func_71410_x().field_71441_e, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g, strength * 2.0f);
        Minecraft.func_71410_x().field_71439_g.field_70165_t = px;
        Minecraft.func_71410_x().field_71439_g.field_70163_u = py;
        Minecraft.func_71410_x().field_71439_g.field_70161_v = pz;
        Minecraft.func_71410_x().field_71439_g.field_70177_z = pYaw;
        Minecraft.func_71410_x().field_71439_g.field_70125_A = pPitch;
        double rx = RenderManager.field_78725_b;
        double ry = RenderManager.field_78726_c;
        double rz = RenderManager.field_78723_d;
        double startX = rx - (double)(MathHelper.func_76134_b((float)(Minecraft.func_71410_x().field_71439_g.field_70177_z / 180.0f * (float)Math.PI)) * 0.46f);
        double startY = ry - (double)0.1f;
        double startZ = rz - (double)(MathHelper.func_76126_a((float)(Minecraft.func_71410_x().field_71439_g.field_70177_z / 180.0f * (float)Math.PI)) * 0.46f);
        double lastX = startX;
        double lastY = startY;
        double lastZ = startZ;
        float alpha = quality / 1.3f;
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)(alpha * 3.5f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        boolean drawing = true;
        GL11.glBegin((int)1);
        for (int i = 0; i < 1000; ++i) {
            Entity hitEntity;
            ea.func_70071_h_();
            GL11.glVertex3d((double)(lastX - rx), (double)(lastY - ry), (double)(lastZ - rz));
            GL11.glVertex3d((double)(ea.field_70165_t - rx), (double)(ea.field_70163_u - ry), (double)(ea.field_70161_v - rz));
            lastX = ea.field_70165_t;
            lastY = ea.field_70163_u;
            lastZ = ea.field_70161_v;
            MovingObjectPosition collisionPoint = ArrowPredictionRenderer.getCollision(ea);
            if (collisionPoint == null) continue;
            if (collisionPoint.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                drawing = false;
                GL11.glVertex3d((double)(ea.field_70165_t - rx), (double)(ea.field_70163_u - ry), (double)(ea.field_70161_v - rz));
                GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - rx), (double)(collisionPoint.field_72307_f.field_72448_b - ry), (double)(collisionPoint.field_72307_f.field_72449_c - rz));
                GL11.glEnd();
                GL11.glLineWidth((float)2.0f);
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)quality);
                GL11.glEnable((int)2848);
                GL11.glBegin((int)1);
                if (collisionPoint.field_72310_e == 0) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                } else if (collisionPoint.field_72310_e == 1) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.001 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                } else if (collisionPoint.field_72310_e == 2) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.001 - rz));
                } else if (collisionPoint.field_72310_e == 3) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.1 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.001 - rz));
                } else if (collisionPoint.field_72310_e == 4) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a - 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                } else if (collisionPoint.field_72310_e == 5) {
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b - 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c + 0.1 - rz));
                    GL11.glVertex3d((double)(collisionPoint.field_72307_f.field_72450_a + 0.001 - rx), (double)(collisionPoint.field_72307_f.field_72448_b + 0.1 - ry), (double)(collisionPoint.field_72307_f.field_72449_c - 0.1 - rz));
                }
                GL11.glEnd();
                break;
            }
            if (collisionPoint.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY || (hitEntity = collisionPoint.field_72308_g) != null) {
                // empty if block
            } else {
                break;
            }
        }
        if (drawing) {
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private static MovingObjectPosition getCollision(EntityArrowSilent ea) {
        Vec3 start = Vec3.func_72443_a((double)ea.field_70165_t, (double)ea.field_70163_u, (double)ea.field_70161_v);
        Vec3 dest = Vec3.func_72443_a((double)(ea.field_70165_t + ea.field_70159_w), (double)(ea.field_70163_u + ea.field_70181_x), (double)(ea.field_70161_v + ea.field_70179_y));
        MovingObjectPosition hit = Minecraft.func_71410_x().field_71441_e.func_147447_a(start, dest, false, true, false);
        start = Vec3.func_72443_a((double)ea.field_70165_t, (double)ea.field_70163_u, (double)ea.field_70161_v);
        dest = Vec3.func_72443_a((double)(ea.field_70165_t + ea.field_70159_w), (double)(ea.field_70163_u + ea.field_70181_x), (double)(ea.field_70161_v + ea.field_70179_y));
        if (hit != null) {
            dest = Vec3.func_72443_a((double)hit.field_72307_f.field_72450_a, (double)hit.field_72307_f.field_72448_b, (double)hit.field_72307_f.field_72449_c);
        }
        Entity collidedEntity = null;
        List entityList = Minecraft.func_71410_x().field_71441_e.func_72839_b((Entity)ea, ea.field_70121_D.func_72321_a(ea.field_70159_w, ea.field_70181_x, ea.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double lastDistance = 0.0;
        for (int c = 0; c < entityList.size(); ++c) {
            double currentDistance;
            AxisAlignedBB entityBoundingBox;
            MovingObjectPosition collision;
            Entity currentEntity = (Entity)entityList.get(c);
            if (!currentEntity.func_70067_L() || currentEntity == Minecraft.func_71410_x().field_71439_g || (collision = (entityBoundingBox = currentEntity.field_70121_D.func_72314_b((double)0.3f, (double)0.3f, (double)0.3f)).func_72327_a(start, dest)) == null || !((currentDistance = start.func_72438_d(collision.field_72307_f)) < lastDistance) && lastDistance != 0.0) continue;
            collidedEntity = currentEntity;
            lastDistance = currentDistance;
        }
        if (collidedEntity != null) {
            hit = new MovingObjectPosition(collidedEntity);
        }
        return hit;
    }

    private static class EntityArrowSilent
    extends EntityArrow {
        public EntityArrowSilent(World world, EntityLivingBase entity, float strength) {
            super(world, entity, strength);
        }

        public void func_70186_c(double par1, double par3, double par5, float par7, float par8) {
            float var9 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
            par1 /= (double)var9;
            par3 /= (double)var9;
            par5 /= (double)var9;
            this.field_70159_w = par1 *= (double)par7;
            this.field_70181_x = par3 *= (double)par7;
            this.field_70179_y = par5 *= (double)par7;
            float var10 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var10) * 180.0 / Math.PI);
        }

        public boolean func_70090_H() {
            return false;
        }

        public boolean func_70072_I() {
            if (this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this)) {
                if (!this.field_70171_ac) {
                    float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * (double)0.2f + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * (double)0.2f)) * 0.2f;
                    if (var1 > 1.0f) {
                        var1 = 1.0f;
                    }
                    float f = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
                }
                this.field_70143_R = 0.0f;
                this.field_70171_ac = true;
            } else {
                this.field_70171_ac = false;
            }
            return this.field_70171_ac;
        }
    }
}

