/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.debugging;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.item.ItemFood;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.gui.GuiDebugMenu;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.decay.DecayManager;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesFood;
import thebetweenlands.event.debugging.DebugHandlerCommon;
import thebetweenlands.event.render.FogHandler;
import thebetweenlands.network.packet.server.PacketTickspeed;
import thebetweenlands.proxy.ClientProxy;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.events.EnvironmentEvent;
import thebetweenlands.world.events.EnvironmentEventRegistry;

public class DebugHandlerClient
extends DebugHandlerCommon {
    public static final DebugHandlerClient INSTANCE = new DebugHandlerClient();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    private static final Field SLEEP_PER_TICK_FIELD;
    public String worldFolderName = ".debug_world";
    public String worldName = "Debug World";
    public boolean fullBright = false;
    private boolean fastFlight = false;
    public boolean denseFog = false;
    public boolean ignoreStart = true;
    public boolean worldLocations = false;
    public boolean debugPostProcessingEffect = false;
    private float[] lightTable;
    public GuiScreen previousGuiScreen;
    public boolean isInDebugWorld = false;
    private boolean shouldRecreateBetweenlands = false;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (!ConfigHandler.DEBUG || !Keyboard.isKeyDown((int)29)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            if (Keyboard.isKeyDown((int)33)) {
                boolean bl = this.fullBright = !this.fullBright;
                if (this.fullBright) {
                    int i;
                    if (this.lightTable == null) {
                        this.lightTable = new float[mc.field_71441_e.field_73011_w.field_76573_f.length];
                    }
                    for (i = 0; i < mc.field_71441_e.field_73011_w.field_76573_f.length; ++i) {
                        this.lightTable[i] = mc.field_71441_e.field_73011_w.field_76573_f[i];
                    }
                    for (i = 0; i < mc.field_71441_e.field_73011_w.field_76573_f.length; ++i) {
                        mc.field_71441_e.field_73011_w.field_76573_f[i] = 1.0f;
                    }
                } else {
                    for (int i = 0; i < mc.field_71441_e.field_73011_w.field_76573_f.length; ++i) {
                        mc.field_71441_e.field_73011_w.field_76573_f[i] = this.lightTable[i];
                    }
                }
            }
            if (Keyboard.isKeyDown((int)46)) {
                boolean bl = this.fastFlight = !this.fastFlight;
            }
            if (Keyboard.isKeyDown((int)19)) {
                boolean bl = this.denseFog = !this.denseFog;
            }
            if (Keyboard.isKeyDown((int)34)) {
                DecayManager.resetDecay((EntityPlayer)mc.field_71439_g);
            }
            if (Keyboard.isKeyDown((int)20)) {
                boolean bl = this.ignoreStart = !this.ignoreStart;
            }
            if (Keyboard.isKeyDown((int)34)) {
                boolean bl = this.debugPostProcessingEffect = !this.debugPostProcessingEffect;
            }
            if (Keyboard.isKeyDown((int)22) && mc.func_71387_A() && this.isInDebugWorld && !this.shouldRecreateBetweenlands) {
                this.shouldRecreateBetweenlands = true;
            }
            if (Keyboard.isKeyDown((int)35)) {
                ShaderHelper.INSTANCE.scheduleShaderReload();
            }
        }
        if (Keyboard.isKeyDown((int)50) && !(mc.field_71462_r instanceof GuiDebugMenu)) {
            this.previousGuiScreen = mc.field_71462_r;
            mc.func_147108_a((GuiScreen)new GuiDebugMenu());
        }
        if (Keyboard.isKeyDown((int)48)) {
            this.saveAndLogImage(mc.func_147117_R().func_110552_b(), "atlas-block.png", "block atlas");
            this.saveAndLogImage(mc.field_71446_o.func_110581_b(TextureMap.field_110576_c).func_110552_b(), "atlas-item.png", "item atlas");
        }
        if (Keyboard.isKeyDown((int)35)) {
            this.worldLocations = !this.worldLocations;
        }
    }

    private void saveAndLogImage(int glTextureId, String fileName, String name) {
        File outFile = this.saveImage(glTextureId, fileName);
        ChatComponentText chatComponent = new ChatComponentText("Saved " + name);
        chatComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, outFile.getAbsolutePath()));
        chatComponent.func_150256_b().func_150228_d(Boolean.valueOf(true));
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)chatComponent);
    }

    private File saveImage(int glTextureId, String file) {
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glBindTexture((int)3553, (int)glTextureId);
        IntBuffer dataBuffer = GLAllocation.func_74527_f((int)0x400000);
        GL11.glGetTexLevelParameter((int)3553, (int)0, (int)4096, (IntBuffer)dataBuffer);
        int width = dataBuffer.get();
        GL11.glGetTexLevelParameter((int)3553, (int)0, (int)4097, (IntBuffer)dataBuffer);
        int height = dataBuffer.get();
        dataBuffer.clear();
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)dataBuffer);
        int[] pixels = new int[width * height];
        dataBuffer.get(pixels);
        BufferedImage img = new BufferedImage(width, height, 6);
        img.setRGB(0, 0, width, height, pixels, 0, width);
        try {
            File out = new File(Minecraft.func_71410_x().field_71412_D.getCanonicalPath(), file);
            ImageIO.write((RenderedImage)img, "png", out);
            return out;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!ConfigHandler.DEBUG || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (this.fastFlight) {
                mc.field_71439_g.field_71075_bZ.func_75092_a(1.0f);
            } else {
                mc.field_71439_g.field_71075_bZ.func_75092_a(0.1f);
            }
        }
        if (this.shouldRecreateBetweenlands && mc.func_71387_A()) {
            this.shouldRecreateBetweenlands = false;
            WorldInfo worldInfo = mc.func_71401_C().field_71305_c[0].func_72912_H();
            mc.func_71403_a(null);
            ISaveFormat saveLoader = mc.func_71359_d();
            saveLoader.func_75800_d();
            saveLoader.func_75802_e(DebugHandlerClient.INSTANCE.worldFolderName + File.separatorChar + "DIM" + ConfigHandler.DIMENSION_ID);
            WorldSettings worldSettings = new WorldSettings(worldInfo);
            worldSettings.func_77166_b();
            mc.func_71371_a(DebugHandlerClient.INSTANCE.worldFolderName, DebugHandlerClient.INSTANCE.worldName, worldSettings);
            this.isInDebugWorld = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (ConfigHandler.DEBUG && !mc.field_71474_y.field_74330_P) {
            int yOffset = 2;
            mc.field_71466_p.func_78276_b("Debug", 2, yOffset, -1);
            mc.field_71466_p.func_78276_b("Decay level: " + DecayManager.getDecayLevel((EntityPlayer)mc.field_71439_g), 2, yOffset += 8, -1);
            mc.field_71466_p.func_78276_b("Corruption: " + DecayManager.getCorruptionLevel((EntityPlayer)mc.field_71439_g), 2, yOffset += 8, -1);
            float fog = FogHandler.INSTANCE.getCurrentFogStart() + (FogHandler.INSTANCE.getCurrentFogEnd() - FogHandler.INSTANCE.getCurrentFogStart()) / 2.0f;
            mc.field_71466_p.func_78276_b("Fog: " + DECIMAL_FORMAT.format(fog) + (FogHandler.INSTANCE.hasDenseFog() ? " (D)" : "") + (mc.field_71439_g.field_70163_u < 70.0 ? " (C)" : ""), 2, yOffset += 8, -1);
            float lightLevel = 0.0f;
            WorldClient world = mc.field_71441_e;
            if (world != null) {
                WorldProvider provider = world.field_73011_w;
                lightLevel += provider.field_76573_f[0];
            }
            mc.field_71466_p.func_78276_b("Base Light: " + lightLevel + (mc.field_71439_g.field_70163_u < 70.0 ? " (C)" : ""), 2, yOffset += 8, -1);
            String activeEvents = "";
            if (world.field_73011_w instanceof WorldProviderBetweenlands) {
                WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
                EnvironmentEventRegistry eeRegistry = provider.getWorldData().getEnvironmentEventRegistry();
                for (EnvironmentEvent eevent : eeRegistry.getEvents().values()) {
                    if (!eevent.isActive()) continue;
                    activeEvents = activeEvents + StatCollector.func_74838_a((String)eevent.getLocalizationEventName()) + ", ";
                }
            }
            activeEvents = activeEvents.length() > 2 ? activeEvents.substring(0, activeEvents.length() - 2) : "None";
            mc.field_71466_p.func_78276_b("Active events: " + activeEvents, 2, yOffset += 8, -1);
            mc.field_71466_p.func_78276_b("Tick speed: " + DECIMAL_FORMAT.format(ClientProxy.debugTimer.getTicksPerSecond()), 2, yOffset += 8, -1);
            TheBetweenlands.proxy.getCustomFontRenderer().func_78276_b("Custom Font Test", 2, yOffset += 8, -1);
            if (mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().func_77973_b() instanceof ItemFood) {
                EntityPropertiesFood property = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)mc.field_71439_g, EntityPropertiesFood.class);
                mc.field_71466_p.func_78276_b("Hatred: " + property.getFoodHatred((ItemFood)mc.field_71439_g.func_71045_bC().func_77973_b()), 2, yOffset += 8, -1);
                mc.field_71466_p.func_78276_b("Sickness: " + (Object)((Object)property.getSickness((ItemFood)mc.field_71439_g.func_71045_bC().func_77973_b())), 2, yOffset += 8, -1);
                mc.field_71466_p.func_78276_b("Last Sickness: " + (Object)((Object)property.getLastSickness()), 2, yOffset += 8, -1);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityPlayerMP) {
            TheBetweenlands.networkWrapper.sendTo((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketTickspeed(1000.0f / (float)DebugHandlerClient.getSleepPerTick())), (EntityPlayerMP)event.entity);
        }
    }

    public static long getSleepPerTick() {
        if (SLEEP_PER_TICK_FIELD == null) {
            return 50L;
        }
        try {
            return (Long)SLEEP_PER_TICK_FIELD.get(MinecraftServer.func_71276_C());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50L;
        }
    }

    public static void setSleepPerTick(long sleepPerTick) {
        if (SLEEP_PER_TICK_FIELD == null) {
            return;
        }
        try {
            SLEEP_PER_TICK_FIELD.set(MinecraftServer.func_71276_C(), sleepPerTick);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onMinecraftFinishedStarting() {
        if (ConfigHandler.DEBUG && ConfigHandler.DEBUG_MENU_ON_START) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDebugMenu());
        }
    }

    @SubscribeEvent
    public void onWorldEventUnload(WorldEvent.Unload event) {
        if (this.isInDebugWorld) {
            this.isInDebugWorld = false;
        }
    }

    @Override
    public boolean isInDebugWorld() {
        return this.isInDebugWorld;
    }

    static {
        Field sleepPerTickField = null;
        try {
            sleepPerTickField = ReflectionHelper.findField(MinecraftServer.class, (String[])new String[]{"sleepPerTick"});
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            System.out.println("MinecraftServer was not transformed!");
        }
        SLEEP_PER_TICK_FIELD = sleepPerTickField;
    }
}

