/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.debugging;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.event.debugging.DebugHandlerClient;
import thebetweenlands.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.world.storage.chunk.storage.ChunkStorage;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class DebugHandlerChunkData {
    public static final DebugHandlerChunkData INSTANCE = new DebugHandlerChunkData();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent event) {
        if (DebugHandlerClient.INSTANCE.worldLocations) {
            for (int cx = -6; cx < 6; ++cx) {
                for (int cz = -6; cz < 6; ++cz) {
                    int cpx = (int)(Minecraft.func_71410_x().field_71439_g.field_70165_t / 16.0 + (double)cx);
                    int cpz = (int)(Minecraft.func_71410_x().field_71439_g.field_70161_v / 16.0 + (double)cz);
                    Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(cpx, cpz);
                    if (chunk == null) continue;
                    BetweenlandsChunkData data = BetweenlandsChunkData.forChunk((World)Minecraft.func_71410_x().field_71441_e, chunk);
                    try {
                        for (ChunkStorage storage : data.getStorage()) {
                            if (!(storage instanceof LocationStorage)) continue;
                            LocationStorage area = (LocationStorage)storage;
                            GL11.glPushMatrix();
                            GL11.glDepthMask((boolean)false);
                            GL11.glDisable((int)3553);
                            GL11.glEnable((int)3042);
                            GL11.glBlendFunc((int)770, (int)771);
                            GL11.glAlphaFunc((int)516, (float)0.0f);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GL11.glLineWidth((float)1.2f);
                            float red = 0.1f + (float)area.getLayer() / 5.0f;
                            float green = 0.4f;
                            float blue = 1.0f - (float)area.getLayer() / 5.0f;
                            float alpha = 0.1f;
                            GL11.glColor4f((float)(red / 1.5f), (float)(green / 1.5f), (float)(blue / 1.5f), (float)(alpha / 1.5f));
                            this.drawBoundingBox(area.getArea().func_72325_c(-RenderManager.field_78725_b, -RenderManager.field_78726_c, -RenderManager.field_78723_d));
                            GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
                            this.drawBoundingBoxOutline(area.getArea().func_72325_c(-RenderManager.field_78725_b, -RenderManager.field_78726_c, -RenderManager.field_78723_d));
                            GL11.glEnable((int)3553);
                            GL11.glDepthMask((boolean)true);
                            GL11.glPopMatrix();
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBoundingBox(AxisAlignedBB axisalignedbb) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f);
        tessellator.func_78377_a(axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBoundingBoxOutline(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78370_a(1, 1, 1, 1);
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78381_a();
    }
}

