/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.rowboat;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.rowboat.ShipSide;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.utils.CubicBezier;
import thebetweenlands.utils.MathUtils;

public class EntityWeedwoodRowboat
extends Entity {
    private static final CubicBezier DEVIATION_DRAG = new CubicBezier(0.9f, 0.0f, 1.0f, 0.6f);
    private static final int TIME_SINCE_HIT_ID = 17;
    private static final int HIT_ROLL_DIRECTION_ID = 18;
    private static final int DAMAGE_TAKEN_ID = 19;
    private static final EnumMap<ShipSide, Integer> ROW_PROGRESS_IDS = ShipSide.newEnumMap(Integer.TYPE, 20, 21);
    private static final float OAR_ROTATION_SCALE = -28.0f;
    private static final float ROW_PROGRESS_PERIOD = (float)Math.PI * 2 / Math.abs(-28.0f);
    private static final float OAR_LENGTH = 2.5f;
    private static final float BLADE_LENGTH = 0.75f;
    private static final float LOOM_LENGTH = 1.75f;
    private boolean hadPlayer;
    private EnumMap<ShipSide, Float> rowForce = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private EnumMap<ShipSide, Integer> rowTime = ShipSide.newEnumMap(Integer.TYPE, new Integer[0]);
    private EnumMap<ShipSide, Float> rowProgressBuffer = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private EnumMap<ShipSide, Float> prevRowProgress = ShipSide.newEnumMap(Float.TYPE, new Float[0]);
    private EnumMap<ShipSide, Boolean> oarInAir = ShipSide.newEnumMap(Boolean.TYPE, new Boolean[0]);
    private float drag;
    private float submergeTicks;
    private float rotationalVelocity;
    private double serverX;
    private double serverY;
    private double serverZ;
    private float boatYaw;
    private float boatPitch;
    private int serverT = -1;
    private boolean prevOarStrokeLeft;
    private boolean oarStrokeLeft;
    private boolean prevOarStrokeRight;
    private boolean oarStrokeRight;
    private ShipSide synchronizer = ShipSide.STARBOARD;

    public EntityWeedwoodRowboat(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 0.9f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityWeedwoodRowboat(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)1);
        this.field_70180_af.func_75682_a(19, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(ROW_PROGRESS_IDS.get((Object)ShipSide.STARBOARD).intValue(), (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(ROW_PROGRESS_IDS.get((Object)ShipSide.PORT).intValue(), (Object)Float.valueOf(0.0f));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(BLItemRegistry.weedwoodRowboat);
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int rotationIncrements) {
        this.serverX = x;
        this.serverY = y;
        this.serverZ = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.serverT = rotationIncrements;
    }

    public void func_70016_h(double x, double y, double z) {
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != player) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean attackerIsCreativeMode;
            this.setHitRollDirection(-this.getHitRollDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = attackerIsCreativeMode = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (attackerIsCreativeMode || this.getDamageTaken() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                if (!attackerIsCreativeMode) {
                    this.func_145778_a(BLItemRegistry.weedwoodRowboat, 1, 0.0f);
                }
                this.func_70106_y();
            }
        }
        return true;
    }

    public void func_70057_ab() {
        this.setHitRollDirection(-this.getHitRollDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public void updateControls(boolean oarStrokeLeft, boolean oarStrokeRight) {
        this.oarStrokeLeft = oarStrokeLeft;
        this.oarStrokeRight = oarStrokeRight;
    }

    public void func_70071_h_() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            boolean hasPlayer;
            this.updateClientOarRotation(ShipSide.STARBOARD);
            this.updateClientOarRotation(ShipSide.PORT);
            boolean bl = hasPlayer = this.field_70153_n != null;
            if (!this.hadPlayer && hasPlayer) {
                TheBetweenlands.proxy.onPlayerEnterWeedwoodRowboat();
            }
            this.hadPlayer = hasPlayer;
            this.animateHullWaterInteraction();
            this.animateOars();
        } else {
            this.updateRowForce(ShipSide.STARBOARD, this.oarStrokeLeft, this.prevOarStrokeLeft);
            this.updateRowForce(ShipSide.PORT, this.oarStrokeRight, this.prevOarStrokeRight);
            this.prevOarStrokeLeft = this.oarStrokeLeft;
            this.prevOarStrokeRight = this.oarStrokeRight;
            this.hitTheQuan();
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updatePosition();
        } else {
            float rotationLeft = this.getRowProgress(ShipSide.STARBOARD);
            float rotationRight = this.getRowProgress(ShipSide.PORT);
            this.applyForces();
            this.applyRowForce();
            this.returnOarToResting(ShipSide.STARBOARD, rotationLeft);
            this.returnOarToResting(ShipSide.PORT, rotationRight);
            this.synchronizeOars();
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.func_145775_I();
        if (!this.field_70170_p.field_72995_K) {
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_70046_E().func_72314_b(0.2, 0.05, 0.2));
            if (entities != null && !entities.isEmpty()) {
                for (Entity entity : entities) {
                    this.func_70108_f(entity);
                }
            }
            if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                this.field_70153_n = null;
            }
        }
        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        this.field_70126_B = MathUtils.adjustAngleForInterpolation(this.field_70177_z, this.field_70126_B);
        this.adjustStrokeProgressForInterpolation(ShipSide.STARBOARD);
        this.adjustStrokeProgressForInterpolation(ShipSide.PORT);
    }

    private void returnOarToResting(ShipSide side, float preApplyValue) {
        if (this.getRowForce(side) == 0.0f) {
            float target = ROW_PROGRESS_PERIOD * 0.05f;
            float value = this.getRowProgress(side);
            if (value != target) {
                float dist = target - value;
                if (dist < 0.0f) {
                    dist += ROW_PROGRESS_PERIOD;
                }
                if ((double)dist < 1.0E-4 && preApplyValue < target) {
                    value = target;
                } else {
                    float increment = dist * 0.085f;
                    if (increment > 0.005f) {
                        increment = 0.005f;
                    }
                    value += increment;
                }
            }
            this.setRowProgress(side, value);
        }
    }

    private void synchronizeOars() {
        float value;
        if (this.getRowForce(this.synchronizer) == 0.0f) {
            return;
        }
        ShipSide desynced = this.synchronizer.getOpposite();
        if (this.getRowForce(desynced) == 0.0f) {
            return;
        }
        float target = this.getRowProgress(this.synchronizer);
        if (Math.abs(target - (value = this.getRowProgress(desynced))) < 1.0E-6f) {
            return;
        }
        if (target < value) {
            this.synchronizer = desynced;
            return;
        }
        if ((value += 0.0045f) > target) {
            value = target;
        }
        this.setRowProgress(desynced, value);
    }

    private void adjustStrokeProgressForInterpolation(ShipSide side) {
        float value = MathUtils.adjustValueForInterpolation(this.getRowProgress(side), this.prevRowProgress.get((Object)side).floatValue(), 0.0f, ROW_PROGRESS_PERIOD);
        this.prevRowProgress.put(side, Float.valueOf(value));
    }

    private void updateClientOarRotation(ShipSide side) {
        if (this.rowProgressBuffer.get((Object)side).floatValue() == this.getRowProgress(side)) {
            this.prevRowProgress.put(side, this.rowProgressBuffer.get((Object)side));
        } else {
            this.rowProgressBuffer.put(side, Float.valueOf(this.getRowProgress(side)));
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double dx = Math.cos(this.field_70177_z * ((float)Math.PI / 180)) * -0.2625;
            double dz = Math.sin(this.field_70177_z * ((float)Math.PI / 180)) * -0.2625;
            this.field_70153_n.func_70107_b(this.field_70165_t + dx, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + dz);
            if (this.field_70153_n instanceof EntityLivingBase) {
                EntityLivingBase rider = (EntityLivingBase)this.field_70153_n;
                rider.field_70761_aq = this.field_70177_z - 90.0f;
                rider.field_70177_z -= this.field_70126_B - this.field_70177_z;
                rider.field_70759_as = this.field_70177_z - 90.0f;
                TheBetweenlands.proxy.updateRiderYawInWeedwoodRowboat(this, rider);
            }
        }
    }

    private void updatePosition() {
        if (this.serverT > 0) {
            double x = this.field_70165_t + (this.serverX - this.field_70165_t) / (double)this.serverT;
            double y = this.field_70163_u + (this.serverY - this.field_70163_u) / (double)this.serverT;
            double z = this.field_70161_v + (this.serverZ - this.field_70161_v) / (double)this.serverT;
            this.field_70177_z += MathHelper.func_76142_g((float)(this.boatYaw - this.field_70177_z)) / (float)this.serverT;
            this.field_70125_A += (this.boatPitch - this.field_70125_A) / (float)this.serverT;
            --this.serverT;
            this.func_70107_b(x, y, z);
        }
    }

    private void applyForces() {
        float bobBase = 0.1f;
        float buoyancy = 0.0f;
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)this.field_70163_u);
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
        Block blockAt = this.field_70170_p.func_147439_a(blockX, blockY, blockZ);
        Block blockAbove = this.field_70170_p.func_147439_a(blockX, blockY + 1, blockZ);
        if (blockAt.func_149688_o() == Material.field_151586_h && blockAbove.func_149688_o() != Material.field_151586_h) {
            buoyancy = (1.0f - ((float)this.field_70163_u - (float)blockY - 1.1f)) * 0.9f + bobBase;
            this.drag = 0.9875f;
            this.submergeTicks = 0.0f;
        } else if (blockAt.func_149688_o() == Material.field_151586_h && blockAbove.func_149688_o() == Material.field_151586_h) {
            buoyancy = 1.01f;
            this.drag = 0.975f;
            this.submergeTicks += 1.0f;
        } else if (blockAt.func_149688_o() == Material.field_151579_a) {
            Block blockBellow = this.field_70170_p.func_147439_a(blockX, blockY - 1, blockZ);
            this.drag = blockBellow.func_149688_o() == Material.field_151586_h ? 0.95f : (blockBellow.func_149688_o().func_76230_c() ? 0.35f : 1.0f);
        }
        float motionRawAngle = (float)Math.atan2(this.field_70179_y, this.field_70159_w);
        float motionAngle = MathHelper.func_76142_g((float)(motionRawAngle * 57.29578f + 180.0f));
        float deviation = Math.abs(MathHelper.func_76142_g((float)(this.field_70177_z - motionAngle))) / 180.0f;
        this.drag *= MathUtils.linearTransformf(DEVIATION_DRAG.eval(deviation), 0.0f, 1.0f, 1.0f, 0.25f);
        this.field_70181_x -= 0.04;
        this.field_70159_w *= (double)this.drag;
        this.field_70179_y *= (double)this.drag;
        this.rotationalVelocity *= this.drag * 0.95f;
        if (buoyancy != 0.0f) {
            this.field_70181_x *= 0.7;
            float moveY = (buoyancy - bobBase) * 0.15f;
            this.field_70181_x = Math.min(this.field_70181_x + (double)0.05f, (double)moveY);
        }
    }

    private void applyRowForce() {
        if (this.field_70153_n != null && this.submergeTicks < 25.0f) {
            Vec3 currentMotion;
            Vec3 cross;
            Vec3 rowForce = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
            Vec3 motion = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            Vec3 rotation = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            float leftOarForce = this.getRowForce(ShipSide.STARBOARD);
            float rightOarForce = this.getRowForce(ShipSide.PORT);
            float forceFactor = 0.5f;
            if (leftOarForce > 0.0f) {
                this.updateRowProgress(ShipSide.STARBOARD, leftOarForce * this.getOarWaterResistance(ShipSide.STARBOARD));
                if (this.canOarsApplyForce()) {
                    Vec3 leftLever = Vec3.func_72443_a((double)0.0, (double)0.0, (double)(leftOarForce *= this.getOarPeriodicForceApplyment(ShipSide.STARBOARD)));
                    motion = motion.func_72441_c(0.0, 0.0, (double)(leftOarForce * forceFactor));
                    cross = rowForce.func_72431_c(leftLever);
                    rotation = rotation.func_72441_c(cross.field_72450_a, cross.field_72448_b, cross.field_72449_c);
                }
            }
            if (rightOarForce > 0.0f) {
                this.updateRowProgress(ShipSide.PORT, rightOarForce * this.getOarWaterResistance(ShipSide.PORT));
                if (this.canOarsApplyForce()) {
                    Vec3 righerLever = Vec3.func_72443_a((double)0.0, (double)0.0, (double)(rightOarForce *= this.getOarPeriodicForceApplyment(ShipSide.PORT)));
                    motion = motion.func_72441_c(0.0, 0.0, (double)(rightOarForce * forceFactor));
                    cross = Vec3.func_72443_a((double)(-rowForce.field_72450_a), (double)(-rowForce.field_72448_b), (double)(-rowForce.field_72449_c)).func_72431_c(righerLever);
                    rotation = rotation.func_72441_c(cross.field_72450_a, cross.field_72448_b, cross.field_72449_c);
                }
            }
            if ((currentMotion = Vec3.func_72443_a((double)this.field_70159_w, (double)0.0, (double)this.field_70179_y)).func_72433_c() < 0.1 && rotation.field_72450_a * rotation.field_72450_a + rotation.field_72448_b * rotation.field_72448_b + rotation.field_72449_c + rotation.field_72449_c > 0.0) {
                motion.field_72450_a *= 0.35;
                motion.field_72448_b *= 0.35;
                motion.field_72449_c *= 0.35;
                rotation.field_72450_a *= 1.6;
                rotation.field_72448_b *= 1.6;
                rotation.field_72449_c *= 1.6;
            }
            this.rotationalVelocity = (float)((double)this.rotationalVelocity + rotation.field_72448_b * 10.0);
            this.field_70177_z += this.rotationalVelocity;
            motion.func_72442_b((270.0f - this.field_70177_z) * ((float)Math.PI / 180));
            this.field_70159_w += motion.field_72450_a;
            this.field_70181_x += motion.field_72448_b;
            this.field_70179_y += motion.field_72449_c;
        }
    }

    private float getOarPeriodicForceApplyment(ShipSide side) {
        return MathUtils.linearTransformf(this.getOarElevation(side), -1.0f, 1.0f, 0.0f, 2.0f);
    }

    private float getOarWaterResistance(ShipSide side) {
        float weight = MathUtils.linearTransformf(this.getOarElevation(side), -1.0f, 1.0f, 1.0f, 0.25f);
        float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        float max = 0.5f;
        if (velocity > 0.5f) {
            velocity = 0.5f;
        }
        float t = velocity / 0.5f;
        return weight + (1.0f - weight) * t;
    }

    private float getOarElevation(ShipSide side) {
        return MathHelper.func_76134_b((float)(this.getRowProgress(side) * -28.0f));
    }

    private void animateHullWaterInteraction() {
        if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() != Material.field_151586_h) {
            return;
        }
        if (this.serverT == -1) {
            return;
        }
        double motionX = this.serverX - this.field_70165_t;
        double motionY = this.serverY - this.field_70163_u;
        double motionZ = this.serverZ - this.field_70161_v;
        double velocity = Math.sqrt(motionX * motionX + motionZ * motionZ);
        if (velocity > 0.2625) {
            double vecX = Math.cos(this.field_70177_z * ((float)Math.PI / 180));
            double vecZ = Math.sin(this.field_70177_z * ((float)Math.PI / 180));
            int p = 0;
            while ((double)p < 1.0 + velocity * 60.0) {
                double splashZ;
                double splashX;
                double near = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double far = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    splashX = this.field_70165_t - vecX * near * 0.8 + vecZ * far;
                    splashZ = this.field_70161_v - vecZ * near * 0.8 - vecX * far;
                    this.field_70170_p.func_72869_a("splash", splashX, this.field_70163_u - 0.125, splashZ, motionX, motionY == 0.0 ? 1.0E-8 : motionY, motionZ);
                } else {
                    splashX = this.field_70165_t + vecX + vecZ * near * 0.7;
                    splashZ = this.field_70161_v + vecZ - vecX * near * 0.7;
                    this.field_70170_p.func_72869_a("splash", splashX, this.field_70163_u - 0.125, splashZ, motionX, motionY == 0.0 ? 1.0E-8 : motionY, motionZ);
                }
                ++p;
            }
        }
    }

    private void animateOars() {
        if (this.serverT == -1) {
            return;
        }
        double motionX = this.serverX - this.field_70165_t;
        double motionY = this.serverY - this.field_70163_u;
        double motionZ = this.serverZ - this.field_70161_v;
        if (motionY == 0.0) {
            motionY = 1.0E-8;
        }
        this.animateOar(ShipSide.STARBOARD, motionX, motionY, motionZ);
        this.animateOar(ShipSide.PORT, motionX, motionY, motionZ);
    }

    private void animateOar(ShipSide side, double motionX, double motionY, double motionZ) {
        double velocity = Math.sqrt(motionX * motionX + motionZ * motionZ);
        Vec3 oarlock = this.getOarlockPosition(side);
        Vec3 oarVector = this.getOarVector(side);
        Vec3 blade = oarlock.func_72441_c(oarVector.field_72450_a * 2.5, oarVector.field_72448_b * 2.5, oarVector.field_72449_c * 2.5);
        MovingObjectPosition raytrace = this.field_70170_p.func_72901_a(Vec3.func_72443_a((double)oarlock.field_72450_a, (double)oarlock.field_72448_b, (double)oarlock.field_72449_c), blade, true);
        boolean bladeInAir = true;
        float amountOfBladeInAir = 0.75f;
        if (raytrace != null && raytrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            float amountInAir;
            if (velocity > 0.175) {
                int p = 0;
                while ((double)p < velocity * 4.0) {
                    float x = MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.2f, 0.2f);
                    float y = MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.2f, 0.2f);
                    float z = MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.2f, 0.2f);
                    this.field_70170_p.func_72869_a("splash", raytrace.field_72307_f.field_72450_a + (double)x, raytrace.field_72307_f.field_72448_b + (double)y, raytrace.field_72307_f.field_72449_c + (double)z, motionX, motionY, motionZ);
                    ++p;
                }
            }
            if ((amountInAir = (float)oarlock.func_72438_d(raytrace.field_72307_f)) < 1.75f) {
                bladeInAir = false;
            } else {
                amountOfBladeInAir = 2.5f - amountInAir;
            }
        }
        if (bladeInAir && this.field_70146_Z.nextFloat() < 0.4f) {
            int count = (int)(1.0 + velocity * 3.0);
            for (int p = 0; p < count; ++p) {
                float point = 1.75f + this.field_70146_Z.nextFloat() * amountOfBladeInAir;
                float x = (float)(oarVector.field_72450_a * (double)point + (double)MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.1f, 0.1f));
                float y = (float)(oarVector.field_72448_b * (double)point + (double)MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.4f, -0.2f));
                float z = (float)(oarVector.field_72449_c * (double)point + (double)MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, -0.1f, 0.1f));
                this.field_70170_p.func_72869_a("splash", oarlock.field_72450_a + (double)x, oarlock.field_72448_b + (double)y, oarlock.field_72449_c + (double)z, 0.0, 1.0E-8, 0.0);
            }
        }
        this.oarInAir.put(side, bladeInAir);
    }

    private Vec3 getOarlockPosition(ShipSide side) {
        float dir = side == ShipSide.PORT ? -1.0f : 1.0f;
        float sideX = MathHelper.func_76134_b((float)((this.field_70177_z - 90.0f * dir) * ((float)Math.PI / 180))) * 0.6f;
        float sideZ = MathHelper.func_76126_a((float)((this.field_70177_z - 90.0f * dir) * ((float)Math.PI / 180))) * 0.6f;
        float forwardX = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.2f;
        float forwardZ = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.2f;
        return Vec3.func_72443_a((double)(this.field_70165_t + (double)sideX + (double)forwardX), (double)(this.field_70163_u + 1.0 - (double)this.field_70129_M + (double)0.15f), (double)(this.field_70161_v + (double)sideZ + (double)forwardZ));
    }

    private Vec3 getOarVector(ShipSide side) {
        float dir = side == ShipSide.PORT ? -1.0f : 1.0f;
        float progress = this.getRowProgress(side);
        float yaw = EntityWeedwoodRowboat.getOarRotationX(progress) * dir - this.field_70177_z * ((float)Math.PI / 180);
        float pitch = EntityWeedwoodRowboat.getOarRotationZ(side, progress) - 1.5707964f;
        float cosYaw = MathHelper.func_76134_b((float)(-yaw));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw));
        float cosPitch = MathHelper.func_76134_b((float)(-pitch));
        return Vec3.func_72443_a((double)(-sinYaw * cosPitch), (double)MathHelper.func_76126_a((float)pitch), (double)(cosYaw * cosPitch));
    }

    private void hitTheQuan() {
        this.createOarSoundFX(ShipSide.STARBOARD);
        this.createOarSoundFX(ShipSide.PORT);
    }

    private void createOarSoundFX(ShipSide side) {
        float amountInAir;
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        Vec3 oarlock = this.getOarlockPosition(side);
        Vec3 oarVector = this.getOarVector(side);
        Vec3 blade = oarlock.func_72441_c(oarVector.field_72450_a * 2.5, oarVector.field_72448_b * 2.5, oarVector.field_72449_c * 2.5);
        MovingObjectPosition raytrace = this.field_70170_p.func_72901_a(Vec3.func_72443_a((double)oarlock.field_72450_a, (double)oarlock.field_72448_b, (double)oarlock.field_72449_c), blade, true);
        boolean bladeInAir = true;
        if (raytrace != null && raytrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (amountInAir = (float)oarlock.func_72438_d(raytrace.field_72307_f)) < 1.75f) {
            boolean start;
            bladeInAir = false;
            float force = this.rowForce.get((Object)side).floatValue();
            boolean bl = start = force == 1.0f;
            if (this.oarInAir.get((Object)side).booleanValue() || start) {
                float volume = force * 0.8f + 0.2f;
                String sound = start ? "thebetweenlands:rowboat.row.start" : "thebetweenlands:rowboat.row";
                this.field_70170_p.func_72908_a(raytrace.field_72307_f.field_72450_a, raytrace.field_72307_f.field_72448_b, raytrace.field_72307_f.field_72449_c, sound, volume, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
            }
        }
        this.oarInAir.put(side, bladeInAir);
    }

    public boolean canOarsApplyForce() {
        return this.drag <= 1.0f;
    }

    public float getRowForce(ShipSide side) {
        return 0.017f * this.rowForce.get((Object)side).floatValue();
    }

    public void updateRowProgress(ShipSide side, float value) {
        this.setRowProgress(side, this.getRowProgress(side) + value);
    }

    public boolean updateRowForce(ShipSide side, boolean oarStroke, boolean prevOarStroke) {
        float force = this.rowForce.get((Object)side).floatValue();
        int time = this.rowTime.get((Object)side);
        boolean appliedForce = false;
        if (oarStroke || ++time < 10) {
            if (!prevOarStroke && oarStroke && time >= 10) {
                force = 1.0f;
                time = 0;
            } else {
                force = Math.max(force - 0.05f, 0.55f);
            }
        } else {
            appliedForce = (force = Math.max(force - 0.1f, 0.0f)) > 0.0f;
        }
        this.rowTime.put(side, time);
        this.rowForce.put(side, Float.valueOf(force));
        return appliedForce;
    }

    public boolean func_70072_I() {
        if (this.field_70170_p.func_72918_a(this.field_70121_D.func_72331_e(0.001, 0.399, 0.001), Material.field_151586_h, (Entity)this)) {
            float volume;
            if (!this.field_70171_ac && (double)(volume = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * 0.2 + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * 0.2)) * 0.2f) > 0.15) {
                float z;
                float x;
                if (volume > 1.0f) {
                    volume = 1.0f;
                }
                this.func_85030_a(this.func_145777_O(), volume, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                float min = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
                int i = 0;
                while ((float)i < 1.0f + this.field_70130_N * 20.0f) {
                    x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    z = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t + (double)x, (double)(min + 1.0f), this.field_70161_v + (double)z, this.field_70159_w, this.field_70181_x - (double)(this.field_70146_Z.nextFloat() * 0.2f), this.field_70179_y);
                    ++i;
                }
                i = 0;
                while ((float)i < 1.0f + this.field_70130_N * 20.0f) {
                    x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    z = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)x, (double)(min + 1.0f), this.field_70161_v + (double)z, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    ++i;
                }
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    public void setRowProgress(ShipSide side, float progress) {
        while (progress > ROW_PROGRESS_PERIOD) {
            progress -= ROW_PROGRESS_PERIOD;
        }
        while (progress < 0.0f) {
            progress += ROW_PROGRESS_PERIOD;
        }
        this.field_70180_af.func_75692_b(ROW_PROGRESS_IDS.get((Object)side).intValue(), (Object)Float.valueOf(progress));
    }

    public float getRowProgress(ShipSide side, float delta) {
        float prevProgress = this.prevRowProgress.get((Object)side).floatValue();
        float progress = this.getRowProgress(side);
        return (float)MathHelper.func_151238_b((double)prevProgress, (double)progress, (double)delta);
    }

    public float getRowProgress(ShipSide side) {
        return this.field_70180_af.func_111145_d(ROW_PROGRESS_IDS.get((Object)side).intValue());
    }

    public void setDamageTaken(float damage) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(damage));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_75692_b(17, (Object)time);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setHitRollDirection(int direction) {
        this.field_70180_af.func_75692_b(18, (Object)direction);
    }

    public int getHitRollDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    public void func_145781_i(int id) {
        if (id == ROW_PROGRESS_IDS.get((Object)ShipSide.STARBOARD)) {
            this.prevRowProgress.put(ShipSide.STARBOARD, this.rowProgressBuffer.get((Object)ShipSide.STARBOARD));
        } else if (id == ROW_PROGRESS_IDS.get((Object)ShipSide.PORT)) {
            this.prevRowProgress.put(ShipSide.PORT, this.rowProgressBuffer.get((Object)ShipSide.PORT));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("rowProgressLeft", this.getRowProgress(ShipSide.STARBOARD));
        compound.func_74776_a("rowForceLeft", this.rowForce.get((Object)ShipSide.STARBOARD).floatValue());
        compound.func_74768_a("rowTimeLeft", this.rowTime.get((Object)ShipSide.STARBOARD).intValue());
        compound.func_74776_a("rowProgressRight", this.getRowProgress(ShipSide.PORT));
        compound.func_74776_a("rowForceRight", this.rowForce.get((Object)ShipSide.PORT).floatValue());
        compound.func_74768_a("rowTimeRight", this.rowTime.get((Object)ShipSide.PORT).intValue());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setRowProgress(ShipSide.STARBOARD, compound.func_74760_g("rowProgressLeft"));
        this.rowForce.put(ShipSide.STARBOARD, Float.valueOf(compound.func_74760_g("rowForceLeft")));
        this.rowTime.put(ShipSide.STARBOARD, compound.func_74762_e("rowTimeLeft"));
        this.setRowProgress(ShipSide.PORT, compound.func_74760_g("rowProgressRight"));
        this.rowForce.put(ShipSide.PORT, Float.valueOf(compound.func_74760_g("rowForceRight")));
        this.rowTime.put(ShipSide.PORT, compound.func_74762_e("rowTimeRight"));
    }

    public static float getOarRotationX(float theta) {
        return MathHelper.func_76126_a((float)(theta * -28.0f)) * 0.6f;
    }

    public static float getOarRotationY(ShipSide side, float theta) {
        float angle = MathUtils.linearTransformf(MathHelper.func_76126_a((float)(theta * -28.0f + 1.5707964f)), -1.0f, 1.0f, 1.5707964f, 0.0f);
        if (side == ShipSide.PORT) {
            angle = (float)Math.PI - angle;
        }
        return angle;
    }

    public static float getOarRotationZ(ShipSide side, float theta) {
        float angle = MathHelper.func_76134_b((float)(theta * -28.0f)) * 0.45f - 1.2566371f;
        if (side == ShipSide.PORT) {
            angle = -angle;
        }
        return angle;
    }
}

