/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties.list.recruitment;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.EntityProperties;
import thebetweenlands.entities.properties.list.recruitment.EntityPropertiesRecruit;

public class EntityPropertiesRecruiter
extends EntityProperties<EntityPlayer> {
    private int recruitmentTicks = 0;
    private boolean recruiting = false;
    private EntityLiving recruit = null;
    public static final int RECRUITMENT_TIME = 2400;

    public void saveNBTData(NBTTagCompound nbt) {
    }

    public void loadNBTData(NBTTagCompound nbt) {
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }

    @Override
    public int getTrackingUpdateTime() {
        return 0;
    }

    @Override
    protected boolean saveTrackingSensitiveData(NBTTagCompound nbt) {
        nbt.func_74757_a("recruiting", this.recruiting);
        if (this.recruit != null) {
            nbt.func_74768_a("recruitID", this.recruit.func_145782_y());
        }
        return false;
    }

    @Override
    protected void loadTrackingSensitiveData(NBTTagCompound nbt) {
        Entity recruit;
        this.recruiting = nbt.func_74767_n("recruiting");
        this.recruit = null;
        if (nbt.func_74764_b("recruitID") && (recruit = ((EntityPlayer)this.getEntity()).field_70170_p.func_73045_a(nbt.func_74762_e("recruitID"))) instanceof EntityLiving) {
            this.recruit = (EntityLiving)recruit;
        }
    }

    @Override
    public String getID() {
        return "blPropertyRecruiter";
    }

    @Override
    public Class<EntityPlayer> getEntityClass() {
        return EntityPlayer.class;
    }

    public void startRecruiting(EntityLiving entity) {
        this.recruiting = true;
        this.recruit = entity;
        this.recruitmentTicks = 0;
    }

    public void stopRecruiting() {
        this.recruiting = false;
        this.recruit = null;
        this.recruitmentTicks = 0;
    }

    public boolean isRecruiting() {
        return this.recruiting && this.recruit != null && this.recruit.func_70089_S();
    }

    public EntityLiving getRecruit() {
        return this.recruit;
    }

    public int getRequiredRecruitmentTime() {
        return (int)(this.recruit == null ? 0.0f : this.recruit.func_110138_aP() / 1.5f);
    }

    public boolean canRecruit() {
        List loadedEntities = ((EntityPlayer)this.getEntity()).field_70170_p.field_72996_f;
        for (Entity entity : loadedEntities) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving living = (EntityLiving)entity;
            EntityPropertiesRecruit props = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesRecruit.class);
            if (props == null || props.getRecruiter() != this.getEntity() || !props.isRecruited() || !entity.func_70089_S()) continue;
            return false;
        }
        return !this.isRecruiting();
    }

    public void update() {
        if (this.isRecruiting()) {
            if (this.recruit.func_70032_d(this.getEntity()) > 6.0f) {
                this.stopRecruiting();
            } else {
                ++this.recruitmentTicks;
                if (this.recruitmentTicks >= this.getRequiredRecruitmentTime()) {
                    EntityPropertiesRecruit props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)this.recruit, EntityPropertiesRecruit.class);
                    if (props != null) {
                        props.setRecruited(2400, (EntityPlayer)this.getEntity());
                    }
                    this.stopRecruiting();
                }
            }
        }
    }
}

