/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties.list.recruitment;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import thebetweenlands.entities.EntityTargetDistraction;
import thebetweenlands.entities.entityAI.recruit.EntityAIRecruitAttackOnCollide;
import thebetweenlands.entities.entityAI.recruit.EntityAIRecruitIgnoreRecruiter;
import thebetweenlands.entities.entityAI.recruit.EntityAIRecruitTargetMobs;
import thebetweenlands.entities.entityAI.recruit.IRecruitAI;
import thebetweenlands.entities.properties.EntityProperties;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.items.equipment.ItemRingOfRecruitment;

public class EntityPropertiesRecruit
extends EntityProperties<EntityLiving> {
    private String recruiterUUID = null;
    private int time = 0;
    private boolean recruited = false;
    private EntityLivingBase distractionEntity;

    @Override
    protected void initProperties() {
        this.distractionEntity = new EntityTargetDistraction(this.getWorld());
    }

    public void saveNBTData(NBTTagCompound nbt) {
        if (this.recruiterUUID != null) {
            nbt.func_74778_a("recruiterUUID", this.recruiterUUID);
        }
        nbt.func_74768_a("time", this.time);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        this.recruiterUUID = nbt.func_74764_b("recruiterUUID") ? nbt.func_74779_i("recruiterUUID") : null;
        this.time = nbt.func_74762_e("time");
    }

    @Override
    protected boolean saveTrackingSensitiveData(NBTTagCompound nbt) {
        nbt.func_74757_a("recruited", this.isRecruited());
        return false;
    }

    @Override
    protected void loadTrackingSensitiveData(NBTTagCompound nbt) {
        this.recruited = nbt.func_74767_n("recruited");
    }

    @Override
    public String getID() {
        return "blPropertyRecruit";
    }

    @Override
    public Class<EntityLiving> getEntityClass() {
        return EntityLiving.class;
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }

    public void setRecruited(int time, EntityPlayer recruiter) {
        this.time = time;
        this.recruiterUUID = recruiter.func_110124_au().toString();
        ((EntityLiving)this.getEntity()).func_70606_j(((EntityLiving)this.getEntity()).func_110138_aP() / 4.0f * 3.0f);
    }

    public int getLastingTime() {
        return this.time;
    }

    public boolean isRecruited() {
        return this.time > 0 || this.recruited;
    }

    public EntityPlayer getRecruiter() {
        try {
            return ((EntityLiving)this.getEntity()).field_70170_p.func_152378_a(UUID.fromString(this.recruiterUUID));
        }
        catch (Exception ex) {
            this.recruiterUUID = null;
            return null;
        }
    }

    public void update() {
        if (this.time > 0) {
            --this.time;
        }
        if (this.time <= 0 || !this.shouldContinue()) {
            if (this.hasTasks()) {
                this.removeTasks();
            }
            this.setTarget((EntityLivingBase)this.getRecruiter());
            this.time = 0;
        } else if (this.isRecruited()) {
            EntityLivingBase newTarget;
            EntityCreature creature;
            if (!this.hasTasks()) {
                this.addTasks();
            }
            EntityPlayer recruiter = this.getRecruiter();
            EntityLiving entity = (EntityLiving)this.getEntity();
            if (entity.func_70638_az() == recruiter) {
                entity.func_70624_b(null);
            }
            if (entity.func_70643_av() == recruiter) {
                entity.func_70604_c(null);
            }
            if (entity instanceof EntityCreature && ((creature = (EntityCreature)entity).func_70777_m() == recruiter || !this.isValidTarget(creature.func_70777_m()))) {
                creature.func_70784_b((Entity)this.distractionEntity);
            }
            if (!(this.isValidTarget((Entity)entity.func_70643_av()) && this.isValidTarget((Entity)entity.func_70638_az()) && entity instanceof EntityCreature && this.isValidTarget(((EntityCreature)entity).func_70777_m()) || (newTarget = this.getMobToAttack()) == null)) {
                this.setTarget(newTarget);
            }
        }
    }

    public void setTarget(EntityLivingBase target) {
        EntityLiving entity = (EntityLiving)this.getEntity();
        entity.func_70624_b(target);
        entity.func_70604_c(target);
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70784_b((Entity)target);
        }
    }

    private void addTasks() {
        if (this.getEntity() instanceof EntityCreature) {
            ((EntityLiving)this.getEntity()).field_70714_bg.func_75776_a(Integer.MIN_VALUE, (EntityAIBase)new EntityAIRecruitAttackOnCollide((EntityCreature)this.getEntity(), 1.0, true));
            ((EntityLiving)this.getEntity()).field_70715_bh.func_75776_a(-2147483647, (EntityAIBase)new EntityAIRecruitIgnoreRecruiter((EntityCreature)this.getEntity()));
            ((EntityLiving)this.getEntity()).field_70715_bh.func_75776_a(Integer.MIN_VALUE, (EntityAIBase)new EntityAIRecruitTargetMobs((EntityCreature)this.getEntity(), true));
        }
    }

    private void removeTasks() {
        if (this.getEntity() instanceof EntityCreature) {
            ArrayList<EntityAIBase> tasksToRemove = new ArrayList<EntityAIBase>();
            for (EntityAITasks.EntityAITaskEntry aiEntry : ((EntityLiving)this.getEntity()).field_70714_bg.field_75782_a) {
                if (!(aiEntry.field_75733_a instanceof IRecruitAI)) continue;
                tasksToRemove.add(aiEntry.field_75733_a);
            }
            ArrayList<EntityAIBase> targetTasksToRemove = new ArrayList<EntityAIBase>();
            for (EntityAITasks.EntityAITaskEntry aiEntry : ((EntityLiving)this.getEntity()).field_70715_bh.field_75782_a) {
                if (!(aiEntry.field_75733_a instanceof IRecruitAI)) continue;
                targetTasksToRemove.add(aiEntry.field_75733_a);
            }
            for (EntityAIBase ai : tasksToRemove) {
                ((EntityLiving)this.getEntity()).field_70714_bg.func_85156_a(ai);
            }
            for (EntityAIBase ai : targetTasksToRemove) {
                ((EntityLiving)this.getEntity()).field_70715_bh.func_85156_a(ai);
            }
        }
    }

    private boolean hasTasks() {
        for (EntityAITasks.EntityAITaskEntry aiEntry : ((EntityLiving)this.getEntity()).field_70714_bg.field_75782_a) {
            if (!(aiEntry.field_75733_a instanceof IRecruitAI)) continue;
            return true;
        }
        for (EntityAITasks.EntityAITaskEntry aiEntry : ((EntityLiving)this.getEntity()).field_70715_bh.field_75782_a) {
            if (!(aiEntry.field_75733_a instanceof IRecruitAI)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldContinue() {
        if (this.getRecruiter() == null) {
            return true;
        }
        EquipmentInventory equipmentInventory = EquipmentInventory.getEquipmentInventory((Entity)this.getRecruiter());
        List<Equipment> equipmentList = equipmentInventory.getEquipment(EnumEquipmentCategory.RING);
        boolean hasActiveRing = false;
        for (Equipment equipment : equipmentList) {
            if (!(equipment.item.func_77973_b() instanceof ItemRingOfRecruitment) || !((ItemRingOfRecruitment)equipment.item.func_77973_b()).isActive(equipment.item)) continue;
            hasActiveRing = true;
        }
        return hasActiveRing;
    }

    private boolean isValidTarget(Entity target) {
        return target != null && target.func_70089_S() && target != this.getRecruiter();
    }

    public EntityLivingBase getMobToAttack() {
        AxisAlignedBB selection = AxisAlignedBB.func_72330_a((double)((EntityLiving)this.getEntity()).field_70165_t, (double)((EntityLiving)this.getEntity()).field_70163_u, (double)((EntityLiving)this.getEntity()).field_70161_v, (double)(((EntityLiving)this.getEntity()).field_70165_t + 1.0), (double)(((EntityLiving)this.getEntity()).field_70163_u + 1.0), (double)(((EntityLiving)this.getEntity()).field_70161_v + 1.0)).func_72314_b(16.0, 16.0, 16.0);
        List eligibleTargets = ((EntityLiving)this.getEntity()).field_70170_p.func_72872_a(EntityLivingBase.class, selection);
        EntityLivingBase closest = null;
        for (EntityLivingBase target : eligibleTargets) {
            if (target == this.getEntity() || !(target instanceof EntityMob) && !(target instanceof IMob) || closest != null && !(target.func_70032_d(this.getEntity()) < closest.func_70032_d(this.getEntity())) || !this.isValidTarget((Entity)target)) continue;
            closest = target;
        }
        return closest;
    }
}

