/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties.list.equipment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.equipment.EntityPropertiesEquipment;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.items.IEquippable;

public class EquipmentInventory {
    private final Entity entity;
    private final List<Equipment> equippedItems = new ArrayList<Equipment>();

    public EquipmentInventory(Entity entity) {
        this.entity = entity;
    }

    public List<Equipment> getEquipment() {
        return Collections.unmodifiableList(this.equippedItems);
    }

    public List<Equipment> getEquipment(EnumEquipmentCategory category) {
        ArrayList<Equipment> equippedItems = new ArrayList<Equipment>();
        for (Equipment equipment : this.equippedItems) {
            if (equipment.category != category) continue;
            equippedItems.add(equipment);
        }
        return Collections.unmodifiableList(equippedItems);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagList itemNBTList = new NBTTagList();
        for (Equipment item : this.equippedItems) {
            NBTTagCompound itemCompound = new NBTTagCompound();
            item.writeToNBT(itemCompound);
            itemNBTList.func_74742_a((NBTBase)itemCompound);
        }
        nbt.func_74782_a("equipment", (NBTBase)itemNBTList);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        this.equippedItems.clear();
        NBTTagList itemNBTList = nbt.func_150295_c("equipment", 10);
        for (int i = 0; i < itemNBTList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = itemNBTList.func_150305_b(i);
            Equipment equipment = Equipment.readFromNBT(itemCompound);
            if (equipment == null) continue;
            this.equippedItems.add(equipment);
        }
    }

    public void addEquipment(Equipment equipment) {
        ((IEquippable)equipment.item.func_77973_b()).onEquip(equipment.item, this.entity, this);
        this.equippedItems.add(equipment);
    }

    public void removeEquipment(Equipment equipment) {
        ((IEquippable)equipment.item.func_77973_b()).onUnequip(equipment.item, this.entity, this);
        this.equippedItems.remove(equipment);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public static EquipmentInventory getEquipmentInventory(Entity entity) {
        EntityPropertiesEquipment property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesEquipment.class);
        if (property != null) {
            return property.getEquipmentInventory();
        }
        return new EquipmentInventory(entity);
    }

    public static Equipment equipItem(EntityPlayer player, Entity target, ItemStack stack) {
        IEquippable equippable;
        EntityPropertiesEquipment property;
        if (stack.func_77973_b() instanceof IEquippable && (property = BLEntityPropertiesRegistry.HANDLER.getProperties(target, EntityPropertiesEquipment.class)) != null && (equippable = (IEquippable)stack.func_77973_b()).canEquip(stack, player, target, property.getEquipmentInventory())) {
            ItemStack copy = stack.func_77946_l();
            copy.field_77994_a = 1;
            Equipment equipment = new Equipment(copy, equippable.getEquipmentCategory(stack));
            property.getEquipmentInventory().addEquipment(equipment);
            return equipment;
        }
        return null;
    }

    public static ItemStack unequipItem(EntityPlayer player, Entity target) {
        EntityPropertiesEquipment property = BLEntityPropertiesRegistry.HANDLER.getProperties(target, EntityPropertiesEquipment.class);
        if (property != null) {
            EquipmentInventory inventory = property.getEquipmentInventory();
            for (int i = inventory.getEquipment().size() - 1; i >= 0; --i) {
                Equipment equipment = inventory.getEquipment().get(i);
                IEquippable equippable = (IEquippable)equipment.item.func_77973_b();
                if (!equippable.canUnequip(equipment.item, player, target, inventory)) continue;
                if (!target.field_70170_p.field_72995_K) {
                    inventory.removeEquipment(equipment);
                }
                return equipment.item;
            }
        }
        return null;
    }

    public static void unequipItem(Entity target, Equipment equipment) {
        EntityPropertiesEquipment property = BLEntityPropertiesRegistry.HANDLER.getProperties(target, EntityPropertiesEquipment.class);
        if (property != null) {
            EquipmentInventory inventory = property.getEquipmentInventory();
            IEquippable equippable = (IEquippable)equipment.item.func_77973_b();
            if (!target.field_70170_p.field_72995_K) {
                inventory.removeEquipment(equipment);
            }
        }
    }
}

