/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties.list.equipment;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.items.IEquippable;

public class Equipment {
    public final ItemStack item;
    public final IEquippable equippable;
    public final EnumEquipmentCategory category;

    public Equipment(ItemStack item, EnumEquipmentCategory category) {
        if (!(item.func_77973_b() instanceof IEquippable)) {
            throw new RuntimeException("Item is not equippable!");
        }
        this.item = item;
        this.equippable = (IEquippable)item.func_77973_b();
        this.category = category != null ? category : EnumEquipmentCategory.NONE;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound itemNBT = new NBTTagCompound();
        this.item.func_77955_b(itemNBT);
        nbt.func_74782_a("item", (NBTBase)itemNBT);
        nbt.func_74778_a("category", this.category.name);
    }

    public static Equipment readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound itemNBT = nbt.func_74775_l("item");
        ItemStack item = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
        EnumEquipmentCategory category = EnumEquipmentCategory.fromName(nbt.func_74779_i("category"));
        return new Equipment(item, category);
    }
}

