/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties.list;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.entities.properties.EntityProperties;
import thebetweenlands.event.player.FoodSicknessEventHandler;

public class EntityPropertiesFood
extends EntityProperties<EntityPlayer> {
    private Map<String, Integer> hatredMap = Maps.newHashMap();
    private int lastHatred = 0;

    @Override
    public String getID() {
        return "blPropertyFood";
    }

    @Override
    public Class<EntityPlayer> getEntityClass() {
        return EntityPlayer.class;
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("Size", this.hatredMap.size());
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Integer> entry : this.hatredMap.entrySet()) {
            NBTTagCompound listCompound = new NBTTagCompound();
            listCompound.func_74778_a("Food", entry.getKey());
            listCompound.func_74768_a("Level", entry.getValue().intValue());
            list.func_74742_a((NBTBase)listCompound);
        }
        compound.func_74782_a("HatredMap", (NBTBase)list);
        compound.func_74768_a("LastHatred", this.lastHatred);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.hatredMap = Maps.newHashMap();
        int size = compound.func_74762_e("Size");
        NBTTagList list = compound.func_150295_c("HatredMap", 10);
        for (int i = 0; i < size; ++i) {
            NBTTagCompound listCompound = list.func_150305_b(i);
            String food = listCompound.func_74779_i("Food");
            int level = listCompound.func_74762_e("Level");
            this.hatredMap.put(food, level);
        }
        this.lastHatred = compound.func_74762_e("LastHatred");
    }

    @Override
    public boolean saveTrackingSensitiveData(NBTTagCompound compound) {
        this.saveNBTData(compound);
        return false;
    }

    @Override
    public void loadTrackingSensitiveData(NBTTagCompound compound) {
        this.loadNBTData(compound);
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }

    public int getFoodHatred(ItemFood food) {
        if (this.hatredMap.containsKey(food.func_77658_a())) {
            return this.hatredMap.get(food.func_77658_a());
        }
        return 0;
    }

    public void increaseFoodHatred(ItemFood food, int amount, int decreaseForOthers) {
        int finalMaxHatred = FoodSicknessEventHandler.Sickness.VALUES[Math.max((int)(FoodSicknessEventHandler.Sickness.VALUES.length - 1), (int)0)].maxHatred;
        if (this.hatredMap.containsKey(food.func_77658_a())) {
            int currentAmount = this.hatredMap.get(food.func_77658_a());
            this.hatredMap.put(food.func_77658_a(), Math.max(Math.min(currentAmount + amount, finalMaxHatred), 0));
        } else {
            this.hatredMap.put(food.func_77658_a(), Math.max(Math.min(amount, finalMaxHatred), 0));
        }
        this.lastHatred = this.hatredMap.get(food.func_77658_a());
        this.decreaseHatredForAllExcept(food, decreaseForOthers);
    }

    public void decreaseHatredForAllExcept(ItemFood food, int decrease) {
        if (decrease > 0) {
            HashMap newHatredMap = Maps.newHashMap();
            for (String key : this.hatredMap.keySet()) {
                if (key.equals(food.func_77658_a())) continue;
                newHatredMap.put(key, Math.max(this.hatredMap.get(key) - decrease, 0));
            }
            this.hatredMap.putAll(newHatredMap);
        }
    }

    public FoodSicknessEventHandler.Sickness getSickness(ItemFood food) {
        return FoodSicknessEventHandler.Sickness.getSicknessForHatred(this.getFoodHatred(food));
    }

    public FoodSicknessEventHandler.Sickness getLastSickness() {
        return FoodSicknessEventHandler.Sickness.getSicknessForHatred(this.lastHatred);
    }
}

