/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties.list;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.entities.properties.EntityProperties;
import thebetweenlands.gemcircle.CircleGem;
import thebetweenlands.gemcircle.EntityGem;

public class EntityPropertiesCircleGem
extends EntityProperties<Entity> {
    private List<EntityGem> circleGems = new ArrayList<EntityGem>();
    private int amuletSlots = 1;
    public static final int MAX_AMULET_SLOTS = 3;

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagList gemList = new NBTTagList();
        for (EntityGem gem : this.circleGems) {
            NBTTagCompound gemCompound = new NBTTagCompound();
            gem.writeToNBT(gemCompound);
            gemList.func_74742_a((NBTBase)gemCompound);
        }
        nbt.func_74782_a("gems", (NBTBase)gemList);
        nbt.func_74768_a("amuletSlots", this.amuletSlots);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        this.circleGems.clear();
        NBTTagList gemList = nbt.func_150295_c("gems", 10);
        for (int i = 0; i < gemList.func_74745_c(); ++i) {
            NBTTagCompound gemCompound = gemList.func_150305_b(i);
            EntityGem gem = EntityGem.readFromNBT(gemCompound);
            if (gem == null) continue;
            this.circleGems.add(gem);
        }
        if (nbt.func_74764_b("amuletSlots")) {
            this.amuletSlots = nbt.func_74762_e("amuletSlots");
        }
    }

    @Override
    public String getID() {
        return "blPropertyCircleGem";
    }

    @Override
    public Class<Entity> getEntityClass() {
        return Entity.class;
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }

    @Override
    public boolean saveTrackingSensitiveData(NBTTagCompound nbt) {
        this.saveNBTData(nbt);
        return false;
    }

    @Override
    public void loadTrackingSensitiveData(NBTTagCompound nbt) {
        this.loadNBTData(nbt);
    }

    public void addGem(CircleGem gem, EntityGem.Type type) {
        this.circleGems.add(new EntityGem(gem, type));
    }

    public void removeGem(EntityGem gem) {
        this.circleGems.remove(gem);
    }

    public List<EntityGem> getGems() {
        return this.circleGems;
    }

    public int getAmuletSlots() {
        return this.amuletSlots;
    }

    public void addAmuletSlot() {
        ++this.amuletSlots;
    }

    public void removeAmuletSlot() {
        if (this.amuletSlots > 0) {
            --this.amuletSlots;
        }
    }

    public void setAmuletSlots(int slots) {
        this.amuletSlots = slots;
    }

    @Override
    protected boolean isPersistent() {
        return this.getWorld().func_82736_K().func_82766_b("keepInventory");
    }
}

