/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import thebetweenlands.entities.properties.EntityProperties;
import thebetweenlands.network.message.base.AbstractMessage;

public class MessageSyncEntityProperties
extends AbstractMessage<MessageSyncEntityProperties> {
    private String propertyID;
    private NBTTagCompound nbt;
    private int entityID;

    public MessageSyncEntityProperties() {
    }

    public MessageSyncEntityProperties(EntityProperties prop, Entity entity) {
        this.propertyID = prop.getID();
        NBTTagCompound trackingData = new NBTTagCompound();
        prop.saveTrackingSensitiveData(trackingData);
        this.nbt = trackingData;
        this.entityID = entity.func_145782_y();
    }

    @Override
    public void onMessageClientSide(MessageSyncEntityProperties message, EntityPlayer player) {
        IExtendedEntityProperties prop;
        Entity target = message.getEntity(player.field_70170_p);
        if (target != null && (prop = target.getExtendedProperties(message.propertyID)) instanceof EntityProperties) {
            EntityProperties blProp = (EntityProperties)prop;
            blProp.loadTrackingSensitiveData(message.nbt);
            blProp.onSync();
        }
    }

    @Override
    public void onMessageServerSide(MessageSyncEntityProperties message, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        try {
            PacketBuffer packetBuffer = new PacketBuffer(buf);
            this.propertyID = packetBuffer.func_150789_c(40);
            this.nbt = packetBuffer.func_150793_b();
            this.entityID = packetBuffer.readInt();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            PacketBuffer packetBuffer = new PacketBuffer(buf);
            packetBuffer.func_150785_a(this.propertyID);
            packetBuffer.func_150786_a(this.nbt);
            packetBuffer.writeInt(this.entityID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Entity getEntity(World world) {
        return world.func_73045_a(this.entityID);
    }
}

