/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.EntityProperties;
import thebetweenlands.entities.properties.MessageSyncEntityProperties;

public class EntityPropertiesHandler {
    private Map<Class<? extends EntityProperties>, String> propertiesIDMap = new HashMap<Class<? extends EntityProperties>, String>();
    private Map<Class<? extends Entity>, List<Class<? extends EntityProperties>>> registeredProperties = new HashMap<Class<? extends Entity>, List<Class<? extends EntityProperties>>>();
    private Map<Class<? extends Entity>, List<String>> entityPropertiesCache = new HashMap<Class<? extends Entity>, List<String>>();
    private Map<EntityPlayerMP, List<EntityProperties.PropertiesTracker>> trackerMap = new HashMap<EntityPlayerMP, List<EntityProperties.PropertiesTracker>>();
    private int updateTimer = 0;

    public void registerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)BLEntityPropertiesRegistry.HANDLER);
        FMLCommonHandler.instance().bus().register((Object)BLEntityPropertiesRegistry.HANDLER);
    }

    public void registerPacket(SimpleNetworkWrapper networkWrapper, int packetID) {
        networkWrapper.registerMessage(MessageSyncEntityProperties.class, MessageSyncEntityProperties.class, packetID, Side.CLIENT);
    }

    public void registerProperties(Class<? extends EntityProperties> propertiesClass) {
        EntityProperties properties = null;
        try {
            Constructor<? extends EntityProperties> propCtor = propertiesClass.getConstructor(new Class[0]);
            properties = propCtor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to register entity properties!", ex);
        }
        if (this.propertiesIDMap.containsValue(properties.getID())) {
            throw new RuntimeException("Duplicate entity properties ID!");
        }
        this.propertiesIDMap.put(propertiesClass, properties.getID());
        Class entityClass = properties.getEntityClass();
        List<Class<? extends EntityProperties>> lst = this.registeredProperties.get(entityClass);
        if (lst == null) {
            lst = new ArrayList<Class<? extends EntityProperties>>();
            this.registeredProperties.put(entityClass, lst);
        }
        lst.add(propertiesClass);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        boolean cached = this.entityPropertiesCache.containsKey(event.entity.getClass());
        ArrayList<String> entityPropertiesIDCache = !cached ? new ArrayList<String>() : null;
        for (Map.Entry<Class<? extends Entity>, List<Class<? extends EntityProperties>>> propEntry : this.registeredProperties.entrySet()) {
            if (!propEntry.getKey().isAssignableFrom(event.entity.getClass())) continue;
            for (Class<? extends EntityProperties> propClass : propEntry.getValue()) {
                try {
                    Constructor<? extends EntityProperties> propCtor = propClass.getConstructor(new Class[0]);
                    EntityProperties prop = propCtor.newInstance(new Object[0]);
                    String propID = prop.getID();
                    event.entity.registerExtendedProperties(propID, (IExtendedEntityProperties)prop);
                    if (cached) continue;
                    entityPropertiesIDCache.add(propID);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!cached) {
            this.entityPropertiesCache.put(event.entity.getClass(), entityPropertiesIDCache);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity.field_70170_p.field_72995_K || !(event.entity instanceof EntityPlayerMP)) {
            return;
        }
        if (!(event.entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.entity;
        List<EntityProperties.PropertiesTracker> trackers = this.trackerMap.get(player);
        if (trackers != null && trackers.size() > 0) {
            EntityProperties.PropertiesTracker tracker2;
            boolean hasPlayer = false;
            Iterator<EntityProperties.PropertiesTracker> iterator = trackers.iterator();
            while (iterator.hasNext() && !(hasPlayer = (tracker2 = iterator.next()).getEntity() == player)) {
            }
            if (!hasPlayer) {
                this.addTracker(player, (Entity)player);
            }
            for (EntityProperties.PropertiesTracker tracker2 : trackers) {
                Entity entity = tracker2.getEntity();
                tracker2.updateTracker();
                if (!tracker2.isTrackerReady()) continue;
                tracker2.onSync();
                MessageSyncEntityProperties message = new MessageSyncEntityProperties(tracker2.getProperties(), tracker2.getEntity());
                TheBetweenlands.networkWrapper.sendTo((IMessage)message, player);
            }
        }
    }

    private void addTracker(EntityPlayerMP player, Entity entity) {
        List<String> entityProperties = this.entityPropertiesCache.get(entity.getClass());
        if (entityProperties != null) {
            List<EntityProperties.PropertiesTracker> trackerList = this.trackerMap.get(player);
            if (trackerList == null) {
                trackerList = new ArrayList<EntityProperties.PropertiesTracker>();
                this.trackerMap.put(player, trackerList);
            }
            for (String propID : entityProperties) {
                EntityProperties blProp;
                IExtendedEntityProperties prop = entity.getExtendedProperties(propID);
                if (!(prop instanceof EntityProperties) || (blProp = (EntityProperties)prop).getTrackingTime() < 0) continue;
                EntityProperties.PropertiesTracker tracker = blProp.createTracker(entity);
                tracker.setReady();
                trackerList.add(tracker);
            }
        }
    }

    private void removeTracker(EntityPlayerMP player, Entity entity) {
        List<EntityProperties.PropertiesTracker> trackerList = this.trackerMap.get(player);
        if (trackerList != null && trackerList.size() > 0) {
            Iterator<EntityProperties.PropertiesTracker> it = trackerList.iterator();
            while (it.hasNext()) {
                EntityProperties.PropertiesTracker tracker = it.next();
                if (!tracker.getEntity().equals((Object)entity)) continue;
                it.remove();
                tracker.removeTracker();
            }
        }
    }

    private void removePlayer(EntityPlayerMP player) {
        List<EntityProperties.PropertiesTracker> trackers = this.trackerMap.get(player);
        if (trackers != null && trackers.size() > 0) {
            for (EntityProperties.PropertiesTracker tracker : trackers) {
                tracker.removeTracker();
            }
        }
        this.trackerMap.remove(player);
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            this.addTracker(player, (Entity)player);
        }
    }

    @SubscribeEvent
    public void onEntityStartTracking(PlayerEvent.StartTracking event) {
        if (event.entityPlayer instanceof EntityPlayerMP) {
            this.addTracker((EntityPlayerMP)event.entityPlayer, event.target);
        }
    }

    @SubscribeEvent
    public void onEntityStopTracking(PlayerEvent.StopTracking event) {
        if (event.entityPlayer instanceof EntityPlayerMP) {
            this.removeTracker((EntityPlayerMP)event.entityPlayer, event.target);
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.updateTimer;
            if (this.updateTimer > 20) {
                this.updateTimer = 0;
                Iterator<Map.Entry<EntityPlayerMP, List<EntityProperties.PropertiesTracker>>> trackerMapIT = this.trackerMap.entrySet().iterator();
                while (trackerMapIT.hasNext()) {
                    Map.Entry<EntityPlayerMP, List<EntityProperties.PropertiesTracker>> trackerEntry = trackerMapIT.next();
                    EntityPlayerMP player = trackerEntry.getKey();
                    WorldServer playerWorld = DimensionManager.getWorld((int)player.field_71093_bK);
                    if (player == null || player.field_70128_L || playerWorld == null || !playerWorld.field_72996_f.contains(player)) {
                        trackerMapIT.remove();
                        for (EntityProperties.PropertiesTracker tracker : trackerEntry.getValue()) {
                            tracker.removeTracker();
                        }
                        continue;
                    }
                    Iterator<EntityProperties.PropertiesTracker> it = trackerEntry.getValue().iterator();
                    while (it.hasNext()) {
                        EntityProperties.PropertiesTracker tracker;
                        tracker = it.next();
                        Entity entity = tracker.getEntity();
                        WorldServer entityWorld = DimensionManager.getWorld((int)entity.field_71093_bK);
                        if (entity != null && !entity.field_70128_L && entityWorld != null && entityWorld.field_72996_f.contains(entity)) continue;
                        it.remove();
                        tracker.removeTracker();
                    }
                }
            }
        }
    }

    public <T extends EntityProperties> T getProperties(Entity entity, Class<T> props) {
        if (entity != null && this.propertiesIDMap.containsKey(props)) {
            return (T)((EntityProperties)entity.getExtendedProperties(this.propertiesIDMap.get(props)));
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.original;
        EntityPlayer newPlayer = event.entityPlayer;
        Set<Class<? extends EntityProperties>> applicableProperties = this.propertiesIDMap.keySet();
        if (applicableProperties != null) {
            for (Class<? extends EntityProperties> applicableProperty : applicableProperties) {
                String propertyID = this.propertiesIDMap.get(applicableProperty);
                EntityProperties property = (EntityProperties)oldPlayer.getExtendedProperties(propertyID);
                if (property == null || !property.getEntityClass().isAssignableFrom(EntityPlayer.class) || !property.isPersistent()) continue;
                NBTTagCompound propertyNBT = new NBTTagCompound();
                property.saveNBTData(propertyNBT);
                EntityProperties newProperty = (EntityProperties)newPlayer.getExtendedProperties(propertyID);
                if (newProperty == null) continue;
                newProperty.loadNBTData(propertyNBT);
            }
        }
    }
}

