/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.properties;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public abstract class EntityProperties<E extends Entity>
implements IExtendedEntityProperties {
    private World world;
    private Entity entity;
    private final Set<PropertiesTracker> trackers = Collections.newSetFromMap(new WeakHashMap());

    public final void init(Entity entity, World world) {
        this.entity = entity;
        this.world = world;
        this.initProperties();
    }

    public Set<PropertiesTracker> getTrackers() {
        return Collections.unmodifiableSet(this.trackers);
    }

    public void sync() {
        for (PropertiesTracker tracker : this.trackers) {
            tracker.setReady();
        }
    }

    public final World getWorld() {
        return this.world;
    }

    public final E getEntity() {
        return (E)this.entity;
    }

    protected void initProperties() {
    }

    public abstract String getID();

    public abstract Class<E> getEntityClass();

    public int getTrackingTime() {
        return -1;
    }

    public int getTrackingUpdateTime() {
        return 0;
    }

    protected boolean saveTrackingSensitiveData(NBTTagCompound nbt) {
        return false;
    }

    protected void loadTrackingSensitiveData(NBTTagCompound nbt) {
    }

    protected void onSync() {
    }

    public final PropertiesTracker createTracker(Entity entity) {
        PropertiesTracker tracker = new PropertiesTracker(entity, this);
        this.trackers.add(tracker);
        return tracker;
    }

    protected boolean isPersistent() {
        return false;
    }

    public static final class PropertiesTracker {
        private int trackingTimer = 0;
        private int trackingUpdateTimer = 0;
        private boolean trackerReady = false;
        private boolean trackerDataChanged = false;
        private NBTTagCompound prevTrackerData = new NBTTagCompound();
        private final Entity entity;
        private final EntityProperties props;

        private PropertiesTracker(Entity entity, EntityProperties props) {
            this.entity = entity;
            this.props = props;
        }

        public void updateTracker() {
            int trackingUpdateFrequency;
            int trackingFrequency = this.props.getTrackingTime();
            if (trackingFrequency >= 0 && !this.trackerReady) {
                ++this.trackingTimer;
                if (this.trackingTimer >= trackingFrequency) {
                    this.trackerReady = true;
                }
            }
            if (this.trackingUpdateTimer < (trackingUpdateFrequency = this.props.getTrackingUpdateTime())) {
                ++this.trackingUpdateTimer;
            }
            if (this.trackingUpdateTimer >= trackingUpdateFrequency && !this.trackerDataChanged) {
                this.trackingUpdateTimer = 0;
                NBTTagCompound currentTrackingData = new NBTTagCompound();
                if (this.props.saveTrackingSensitiveData(currentTrackingData)) {
                    this.trackerDataChanged = true;
                } else if (!currentTrackingData.equals((Object)this.prevTrackerData)) {
                    this.trackerDataChanged = true;
                }
                this.prevTrackerData = currentTrackingData;
            }
        }

        void setReady() {
            this.trackerReady = true;
            this.trackerDataChanged = true;
        }

        boolean isTrackerReady() {
            boolean ready;
            boolean bl = ready = this.props.getTrackingTime() >= 0 && this.trackerReady && this.trackerDataChanged;
            if (ready) {
                this.trackingTimer = 0;
                this.trackerReady = false;
                this.trackerDataChanged = false;
                return true;
            }
            return false;
        }

        void onSync() {
            this.props.onSync();
        }

        public EntityProperties getProperties() {
            return this.props;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public void removeTracker() {
            this.props.trackers.remove(this);
        }
    }
}

