/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.projectiles;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBoss;

public class EntityVolatileSoul
extends Entity
implements IProjectile {
    private Entity target = null;
    private int strikes = 0;
    private int ticksInAir;

    public EntityVolatileSoul(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.3f);
        this.field_70145_X = true;
    }

    public EntityVolatileSoul(World world, EntityWight source) {
        this(world);
        this.setOwner(source.func_110124_au().toString());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    public void setOwner(String ownerUUID) {
        this.field_70180_af.func_75692_b(17, (Object)ownerUUID);
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(17);
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID p_152378_1_) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!p_152378_1_.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    protected void onImpact(MovingObjectPosition target) {
        if (target.field_72308_g != null && target.field_72308_g instanceof EntityLivingBase && !(target.field_72308_g instanceof EntityWight) && !this.field_70170_p.field_72995_K) {
            if (target.field_72308_g instanceof EntityPlayer && ((EntityPlayer)target.field_72308_g).func_70632_aY() && ((EntityPlayer)target.field_72308_g).func_71057_bx() <= 10) {
                this.field_70159_w *= -6.0;
                this.field_70181_x *= -6.0;
                this.field_70179_y *= -6.0;
                ++this.strikes;
                return;
            }
            target.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.getOwner()), 3.0f);
            if (!this.field_70128_L && target.field_72308_g instanceof EntityPlayer && (target.field_72308_g.field_70128_L || ((EntityLivingBase)target.field_72308_g).func_110143_aJ() <= 0.0f)) {
                target.field_72308_g.func_70106_y();
            }
            this.func_70106_y();
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        ++this.strikes;
        if (this.strikes >= 3) {
            this.func_70106_y();
            return true;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3 vec3;
            if (!this.field_70170_p.field_72995_K && (vec3 = source.func_76346_g().func_70040_Z()) != null) {
                this.field_70159_w = vec3.field_72450_a * 1.5;
                this.field_70181_x = vec3.field_72448_b * 1.5;
                this.field_70179_y = vec3.field_72449_c * 1.5;
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL || this.getOwner() == null || this.getOwner().field_70128_L)) {
            this.func_70106_y();
            return;
        }
        if (!(this.field_70170_p.field_72995_K || this.getOwner() != null && this.getOwner().func_70089_S() && this.getOwner() instanceof EntityWight && ((EntityWight)this.getOwner()).isVolatile() && !(this.target instanceof EntityFortressBoss))) {
            this.func_70106_y();
        }
        if (!this.field_70128_L) {
            ++this.ticksInAir;
            if (this.field_70170_p.field_72995_K) {
                double px = this.field_70165_t + (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.25f);
                double py = this.field_70163_u + (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.25f);
                double pz = this.field_70161_v + (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.25f);
                Vec3 vec = Vec3.func_72443_a((double)px, (double)py, (double)pz).func_72444_a(Vec3.func_72443_a((double)(this.field_70165_t + 0.125), (double)(this.field_70163_u + 0.125), (double)(this.field_70161_v + 0.125))).func_72432_b();
                BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz, vec.field_72450_a * (double)0.05f, vec.field_72448_b * (double)0.05f, vec.field_72449_c * (double)0.05f, 1.0f, new Object[0]);
            }
            if (this.target == null || this.target.field_70128_L) {
                List targetList = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                ArrayList<Object> eligibleTargets = new ArrayList<Object>();
                if (this.field_70170_p.field_73012_v.nextInt(4) > 0) {
                    for (Entity e : targetList) {
                        if (!(e instanceof EntityPlayer)) continue;
                        eligibleTargets.add((EntityPlayer)e);
                    }
                }
                if (eligibleTargets.isEmpty()) {
                    for (Entity e : targetList) {
                        if (e instanceof EntityWight) continue;
                        eligibleTargets.add(e);
                    }
                }
                if (!eligibleTargets.isEmpty()) {
                    this.target = (Entity)eligibleTargets.get(this.field_70170_p.field_73012_v.nextInt(eligibleTargets.size()));
                }
            }
            if (this.target != null && this.ticksInAir >= 10) {
                double dx = this.target.field_70121_D.field_72340_a + (this.target.field_70121_D.field_72336_d - this.target.field_70121_D.field_72340_a) / 2.0 - this.field_70165_t;
                double dy = this.target.field_70121_D.field_72338_b + (this.target.field_70121_D.field_72337_e - this.target.field_70121_D.field_72338_b) / 2.0 - this.field_70163_u;
                double dz = this.target.field_70121_D.field_72339_c + (this.target.field_70121_D.field_72334_f - this.target.field_70121_D.field_72339_c) / 2.0 - this.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                double speed = 0.075;
                double maxSpeed = 0.8;
                this.field_70159_w += dx / dist * speed;
                this.field_70181_x += dy / dist * speed;
                this.field_70179_y += dz / dist * speed;
                Vec3 motion = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
                if (motion.func_72433_c() > maxSpeed) {
                    motion = motion.func_72432_b();
                    this.field_70159_w = motion.field_72450_a * maxSpeed;
                    this.field_70181_x = motion.field_72448_b * maxSpeed;
                    this.field_70179_y = motion.field_72449_c * maxSpeed;
                }
            }
            Vec3 currentPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition hitObject = this.field_70170_p.func_72933_a(currentPos, nextPos);
            currentPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (hitObject != null) {
                nextPos = Vec3.func_72443_a((double)hitObject.field_72307_f.field_72450_a, (double)hitObject.field_72307_f.field_72448_b, (double)hitObject.field_72307_f.field_72449_c);
            }
            Entity hitEntity = null;
            List hitEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(2.0, 2.0, 2.0));
            double minDist = 0.0;
            for (int i = 0; i < hitEntities.size(); ++i) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)hitEntities.get(i);
                if (!entity1.func_70067_L() || this.ticksInAir < 10 || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(currentPos, nextPos)) == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < minDist) && minDist != 0.0) continue;
                hitEntity = entity1;
                minDist = d1;
            }
            if (hitEntity != null) {
                hitObject = new MovingObjectPosition(hitEntity);
            }
            if (hitObject != null) {
                this.onImpact(hitObject);
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        super.func_70071_h_();
    }

    public void func_70186_c(double x, double y, double z, float speed, float randMotion) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setOwner(nbt.func_74779_i("ownerUUID"));
        this.strikes = nbt.func_74762_e("strikes");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("ownerUUID", this.getOwnerUUID());
        nbt.func_74768_a("strikes", this.strikes);
    }
}

