/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.projectiles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thebetweenlands.items.BLItemRegistry;

public class EntityElixir
extends EntityThrowable {
    private ItemStack elixirStack;

    public EntityElixir(World world) {
        super(world);
        this.func_70096_w().func_75682_a(20, (Object)new ItemStack((Item)BLItemRegistry.elixir));
    }

    public EntityElixir(World world, EntityLivingBase thrower, ItemStack elixir, float strength) {
        super(world, thrower);
        this.elixirStack = elixir;
        this.func_70096_w().func_75682_a(20, (Object)elixir);
        this.field_70159_w *= (double)strength;
        this.field_70181_x *= (double)strength;
        this.field_70179_y *= (double)strength;
    }

    public ItemStack getElixirStack() {
        return this.func_70096_w().func_82710_f(20);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected float func_70182_d() {
        return 0.5f;
    }

    protected float func_70183_g() {
        return -20.0f;
    }

    protected void func_70184_a(MovingObjectPosition hitPosition) {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB hitBB = this.field_70121_D.func_72314_b(4.0, 2.0, 4.0);
            List hitEntities = this.field_70170_p.func_72872_a(EntityLivingBase.class, hitBB);
            if (hitEntities != null && !hitEntities.isEmpty()) {
                for (EntityLivingBase affectedEntity : hitEntities) {
                    double entityDst = this.func_70068_e((Entity)affectedEntity);
                    if (!(entityDst < 16.0)) continue;
                    double modifier = 1.0 - Math.sqrt(entityDst) / 4.0;
                    if (affectedEntity == hitPosition.field_72308_g) {
                        modifier = 1.0;
                    }
                    BLItemRegistry.elixir.applyEffect(this.elixirStack, affectedEntity, modifier);
                }
            }
            this.field_70170_p.func_72926_e(2002, (int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u), (int)Math.round(this.field_70161_v), 0);
            this.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("elixir")) {
            this.elixirStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("elixir"));
            this.func_70096_w().func_75692_b(20, (Object)this.elixirStack);
        }
        if (this.elixirStack == null) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.elixirStack != null) {
            nbt.func_74782_a("elixir", (NBTBase)this.elixirStack.func_77955_b(new NBTTagCompound()));
        }
    }
}

