/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.projectiles;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.herblore.elixirs.ElixirEffectRegistry;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.bow.EnumArrowType;

public class EntityBLArrow
extends EntityArrow
implements IProjectile {
    private static final int DW_SHOOTER = 9;
    private static final int DW_TYPE = 10;
    private boolean checkedShooter = false;
    private boolean inGround = false;
    private int inGroundTicks = 0;

    public EntityBLArrow(World world) {
        super(world);
    }

    public EntityBLArrow(World world, EntityLivingBase entity, float strength) {
        super(world, entity, strength);
        this.field_70250_c = entity;
        this.func_70096_w().func_75692_b(9, (Object)entity.func_110124_au().toString());
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(9, (Object)"");
        this.func_70096_w().func_75682_a(10, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("inGroundTicks", this.inGroundTicks);
        nbt.func_74768_a("arrowType", this.getArrowType().ordinal());
        nbt.func_74778_a("shooter", this.func_70096_w().func_75681_e(9));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.inGroundTicks = nbt.func_74762_e("inGroundTicks");
        this.setArrowType(nbt.func_74762_e("arrowType"));
        this.func_70096_w().func_75692_b(9, (Object)"shooter");
    }

    public void func_70071_h_() {
        if (this.field_70250_c == null && !this.checkedShooter) {
            try {
                UUID uuid = UUID.fromString(this.func_70096_w().func_75681_e(9));
                if (uuid != null) {
                    this.field_70250_c = this.field_70170_p.func_152378_a(uuid);
                }
            }
            catch (Exception uuid) {
            }
            finally {
                this.checkedShooter = true;
            }
        }
        if (this.inGround) {
            ++this.inGroundTicks;
        }
        if (!this.field_70170_p.field_72995_K && !this.inGround) {
            MovingObjectPosition collision = EntityBLArrow.getCollision(this);
            if (collision != null && collision.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && collision.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase hitEntity = (EntityLivingBase)collision.field_72308_g;
                switch (this.getArrowType()) {
                    case ANGLER_POISON: {
                        hitEntity.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 200, 2));
                        break;
                    }
                    case OCTINE: {
                        if (hitEntity.func_70027_ad()) {
                            hitEntity.func_70015_d(9);
                            break;
                        }
                        hitEntity.func_70015_d(5);
                        break;
                    }
                    case BASILISK: {
                        hitEntity.func_70690_d(ElixirEffectRegistry.EFFECT_PETRIFY.createEffect(100, 1));
                        break;
                    }
                }
            } else if (collision != null && collision.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.inGround = true;
            }
        }
        super.func_70071_h_();
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.inGroundTicks > 20 && this.field_70249_b <= 0) {
            boolean canPickUp;
            boolean bl = canPickUp = this.field_70251_a == 1 || this.field_70251_a == 2 && player.field_71075_bZ.field_75098_d;
            if (canPickUp && !this.pickUp(player)) {
                canPickUp = false;
            }
            if (canPickUp) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public boolean pickUp(EntityPlayer player) {
        switch (this.getArrowType()) {
            case ANGLER_POISON: {
                return player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.poisonedAnglerToothArrow, 1));
            }
            case OCTINE: {
                return player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.octineArrow, 1));
            }
            case BASILISK: {
                return player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.basiliskArrow, 1));
            }
        }
        return player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.anglerToothArrow, 1));
    }

    private static MovingObjectPosition getCollision(EntityArrow ea) {
        Vec3 start = Vec3.func_72443_a((double)ea.field_70165_t, (double)ea.field_70163_u, (double)ea.field_70161_v);
        Vec3 dest = Vec3.func_72443_a((double)(ea.field_70165_t + ea.field_70159_w), (double)(ea.field_70163_u + ea.field_70181_x), (double)(ea.field_70161_v + ea.field_70179_y));
        MovingObjectPosition hit = ea.field_70170_p.func_147447_a(start, dest, false, true, false);
        start = Vec3.func_72443_a((double)ea.field_70165_t, (double)ea.field_70163_u, (double)ea.field_70161_v);
        dest = Vec3.func_72443_a((double)(ea.field_70165_t + ea.field_70159_w), (double)(ea.field_70163_u + ea.field_70181_x), (double)(ea.field_70161_v + ea.field_70179_y));
        if (hit != null) {
            dest = Vec3.func_72443_a((double)hit.field_72307_f.field_72450_a, (double)hit.field_72307_f.field_72448_b, (double)hit.field_72307_f.field_72449_c);
        }
        Entity collidedEntity = null;
        List entityList = ea.field_70170_p.func_72839_b((Entity)ea, ea.field_70121_D.func_72321_a(ea.field_70159_w, ea.field_70181_x, ea.field_70179_y).func_72314_b(1.05, 1.05, 1.05));
        double lastDistance = 0.0;
        for (int c = 0; c < entityList.size(); ++c) {
            double currentDistance;
            AxisAlignedBB entityBoundingBox;
            MovingObjectPosition collision;
            Entity currentEntity = (Entity)entityList.get(c);
            if (!currentEntity.func_70067_L() || currentEntity == ea.field_70250_c && ea.field_70173_aa <= 5 || (collision = (entityBoundingBox = currentEntity.field_70121_D.func_72314_b((double)0.35f, (double)0.35f, (double)0.35f)).func_72327_a(start, dest)) == null || !((currentDistance = start.func_72438_d(collision.field_72307_f)) < lastDistance) && lastDistance != 0.0) continue;
            collidedEntity = currentEntity;
            lastDistance = currentDistance;
        }
        if (collidedEntity != null) {
            hit = new MovingObjectPosition(collidedEntity);
        }
        return hit;
    }

    private void setArrowType(int type) {
        this.func_70096_w().func_75692_b(10, (Object)type);
    }

    public void setArrowType(EnumArrowType type) {
        this.func_70096_w().func_75692_b(10, (Object)type.ordinal());
    }

    public EnumArrowType getArrowType() {
        int arrowType = this.func_70096_w().func_75679_c(10);
        return arrowType < EnumArrowType.values().length ? EnumArrowType.values()[arrowType] : EnumArrowType.DEFAULT;
    }
}

