/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.particles;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.blocks.terrain.BlockWisp;

public class EntityWispFX
extends EntityFX {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/particle/wisp.png");
    private float prevFlameScale;
    private float flameScale;
    private int color;
    private int brightness;

    public EntityWispFX(World world, double x, double y, double z, double mx, double my, double mz, float size, int bright, int col) {
        super(world, x, y, z, mx, my, mz);
        this.field_70159_w = this.field_70159_w * 0.01 + mx;
        this.field_70181_x = this.field_70181_x * 0.01 + my;
        this.field_70179_y = this.field_70179_y * 0.01 + mz;
        this.field_70165_t = this.field_70169_q = (x += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.05f));
        this.field_70163_u = this.field_70167_r = (y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.05f));
        this.field_70161_v = this.field_70166_s = (z += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.05f));
        this.flameScale = size;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 1000;
        this.field_70145_X = true;
        this.color = col;
        this.brightness = bright;
    }

    public void func_70539_a(Tessellator par1Tessellator, float partialRenderTicks, float rx, float rxz, float rz, float ryz, float rxy) {
        float currentX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialRenderTicks);
        float currentY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialRenderTicks);
        float currentZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialRenderTicks);
        float ipx = (float)((double)currentX - field_70556_an);
        float ipy = (float)((double)currentY - field_70554_ao);
        float ipz = (float)((double)currentZ - field_70555_ap);
        float scale = (this.prevFlameScale + (this.flameScale - this.prevFlameScale) * partialRenderTicks) / 10.0f;
        par1Tessellator.func_78380_c(this.brightness);
        float distance = 0.0f;
        if (!BlockWisp.canSee(this.field_70170_p)) {
            distance = MathHelper.func_76131_a((float)EntityWispFX.getDistanceToViewer(currentX, currentY, currentZ, partialRenderTicks), (float)10.0f, (float)20.0f);
        }
        float a = (float)(this.color >>> 24 & 0xFF) / 255.0f - MathHelper.func_76126_a((float)(0.15707964f * distance));
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        par1Tessellator.func_78369_a(r, g, b, a);
        par1Tessellator.func_78374_a((double)(ipx - rx * scale - ryz * scale), (double)(ipy - rxz * scale), (double)(ipz - rz * scale - rxy * scale), 0.0, 1.0);
        par1Tessellator.func_78374_a((double)(ipx - rx * scale + ryz * scale), (double)(ipy + rxz * scale), (double)(ipz - rz * scale + rxy * scale), 1.0, 1.0);
        par1Tessellator.func_78374_a((double)(ipx + rx * scale + ryz * scale), (double)(ipy + rxz * scale), (double)(ipz + rz * scale + rxy * scale), 1.0, 0.0);
        par1Tessellator.func_78374_a((double)(ipx + rx * scale - ryz * scale), (double)(ipy - rxz * scale), (double)(ipz + rz * scale - rxy * scale), 0.0, 0.0);
    }

    public static float getDistanceToViewer(double x, double y, double z, float partialRenderTicks) {
        EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
        double dx = (double)((float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialRenderTicks)) - x;
        double dy = (double)((float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialRenderTicks)) - y;
        double dz = (double)((float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialRenderTicks)) - z;
        return MathHelper.func_76129_c((float)((float)(dx * dx + dy * dy + dz * dz)));
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.prevFlameScale = this.flameScale;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.96;
        this.field_70179_y *= 0.96;
        if (this.field_70546_d++ >= this.field_70547_e || this.flameScale <= 0.0f) {
            this.func_70106_y();
        }
        if (this.field_70546_d != 0) {
            if (this.flameScale > 0.0f) {
                this.flameScale = (float)((double)this.flameScale - 0.025);
            }
            this.field_70181_x += 8.0E-5;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }
}

