/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.particles;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thebetweenlands.entities.WeedWoodBushUncollidableEntity;

public class EntityWeedWoodRustleFX
extends EntityFX
implements WeedWoodBushUncollidableEntity {
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/particle/leaf.png");
    private float scale;
    private int color;
    private int textureCount;
    private double relativeTextureHeight;
    private int currentTexture = 0;
    private int textureCounter = 0;

    public EntityWeedWoodRustleFX(World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        Random rand = world.field_73012_v;
        float dx = rand.nextFloat() * 2.0f - 1.0f;
        float dy = rand.nextFloat() * 2.0f - 0.5f;
        float dz = rand.nextFloat() * 2.0f - 1.0f;
        float len = MathHelper.func_76129_c((float)(dx * dx + dy * dy + dz * dz));
        float radius = 0.7f;
        this.field_70165_t += (double)((dx /= len) * radius);
        this.field_70163_u += (double)((dy /= len) * radius);
        this.field_70161_v += (double)((dz /= len) * radius);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float mag = 0.01f + rand.nextFloat() * 0.07f;
        this.field_70159_w = dx * mag;
        this.field_70181_x = dy * mag;
        this.field_70179_y = dz * mag;
        this.field_70547_e = 50 + rand.nextInt(60);
        this.field_70145_X = false;
        this.color = -1;
        this.scale = 0.12f * rand.nextFloat() + 0.03f;
        this.textureCount = 5;
        this.textureCounter = rand.nextInt(5);
        this.relativeTextureHeight = 1.0 / (double)this.textureCount;
        this.field_70545_g = 0.09f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70122_E) {
            ++this.textureCounter;
            if (this.textureCounter >= 5) {
                this.textureCounter = 0;
                ++this.currentTexture;
                if (this.currentTexture >= this.textureCount) {
                    this.currentTexture = 0;
                }
            }
        }
    }

    public void func_70539_a(Tessellator tessellator, float delta, float rx, float rxz, float rz, float ryz, float rxy) {
        float ipx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)delta - field_70556_an);
        float ipy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)delta - field_70554_ao);
        float ipz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)delta - field_70555_ap);
        int prevTex = GL11.glGetInteger((int)32873);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78374_a((double)(ipx - rx * this.scale - ryz * this.scale), (double)(ipy - rxz * this.scale), (double)(ipz - rz * this.scale - rxy * this.scale), 1.0, (double)(this.currentTexture + 1) * this.relativeTextureHeight);
        tessellator.func_78374_a((double)(ipx - rx * this.scale + ryz * this.scale), (double)(ipy + rxz * this.scale), (double)(ipz - rz * this.scale + rxy * this.scale), 1.0, (double)this.currentTexture * this.relativeTextureHeight);
        tessellator.func_78374_a((double)(ipx + rx * this.scale + ryz * this.scale), (double)(ipy + rxz * this.scale), (double)(ipz + rz * this.scale + rxy * this.scale), 0.0, (double)this.currentTexture * this.relativeTextureHeight);
        tessellator.func_78374_a((double)(ipx + rx * this.scale - ryz * this.scale), (double)(ipy - rxz * this.scale), (double)(ipz + rz * this.scale - rxy * this.scale), 0.0, (double)(this.currentTexture + 1) * this.relativeTextureHeight);
        tessellator.func_78381_a();
        GL11.glBindTexture((int)3553, (int)prevTex);
    }

    public int func_70537_b() {
        return 3;
    }
}

