/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.particles;

import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

public class EntityPathParticle
extends EntityFX {
    private int positionIndex = 0;
    private final List<Vector3d> targetPoints;

    public EntityPathParticle(World world, double x, double y, double z, double motionX, double motionY, double motionZ, List<Vector3d> targetPoints) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.targetPoints = targetPoints;
    }

    public Vector3d getPosition(double t) {
        int segments = (int)Math.ceil((double)this.targetPoints.size() / 3.0);
        int segmentIndex = (int)Math.floor((double)segments * t);
        Vector3d[] segment = new Vector3d[4];
        for (int v = 0; v < 4; ++v) {
            int pi = segmentIndex * 3 + v;
            segment[v] = pi >= this.targetPoints.size() ? this.targetPoints.get(this.targetPoints.size() - 1) : this.targetPoints.get(pi);
        }
        double segmentStep = 1.0 / (double)segments;
        double segmentStart = segmentStep * (double)segmentIndex;
        double segmentT = (t - segmentStart) / segmentStep;
        return this.getSegmentPos(segmentT, segment);
    }

    private Vector3d getSegmentPos(double t, Vector3d[] vecs) {
        Vector3d res = new Vector3d();
        Vector3d[] ctrlPoints = new Vector3d[4];
        double revT = 1.0 - t;
        ctrlPoints[0] = this.newScaledVector3d(revT * revT * revT, vecs[0]);
        ctrlPoints[1] = this.newScaledVector3d(revT * revT * 3.0 * t, vecs[1]);
        ctrlPoints[2] = this.newScaledVector3d(revT * 3.0 * t * t, vecs[2]);
        ctrlPoints[3] = this.newScaledVector3d(t * t * t, vecs[3]);
        for (int i = 0; i < 4; ++i) {
            res.add((Tuple3d)ctrlPoints[i]);
        }
        return res;
    }

    private Vector3d newScaledVector3d(double vecScale, Vector3d vec) {
        Vector3d res = new Vector3d(vec);
        res.scale(vecScale);
        return res;
    }
}

