/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.particles;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thebetweenlands.TheBetweenlands;

public class EntityLeafSwirlFX
extends EntityFX {
    private ResourceLocation particleTexture;
    private float scale;
    private int color;
    private int textures;
    private double relativeTextureHeight;
    private int currentTexture = 0;
    private int textureCounter = 0;
    private float progress = 0.0f;
    private final Entity target;
    private final float startRotation;
    private final float endRadius;
    private double dragX;
    private double dragY;
    private double dragZ;
    private static final float VELOCITY_OFFSET_MULTIPLIER = 4.0f;

    public EntityLeafSwirlFX(World world, double x, double y, double z, int maxAge, float scale, int color, ResourceLocation texture, int textures, Entity target, float progress) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        double my;
        this.target = target;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.progress = progress;
        double tmx = this.target.field_70165_t - this.target.field_70142_S;
        double tmy = this.target.field_70163_u - this.target.field_70137_T;
        double tmz = this.target.field_70161_v - this.target.field_70136_U;
        double d = my = this.target.field_70124_G ? 0.0 : tmy * 4.0;
        if (my < -0.3) {
            my = -0.3;
        }
        this.dragX = MathHelper.func_151237_a((double)(tmx * 4.0), (double)-1.0, (double)1.0);
        this.dragY = MathHelper.func_151237_a((double)my, (double)-0.3, (double)1.0);
        this.dragZ = MathHelper.func_151237_a((double)(tmz * 4.0), (double)-1.0, (double)1.0);
        double sx = this.target.field_70165_t - this.dragX;
        double sy = this.target.field_70163_u - 1.6 - this.dragY;
        double sz = this.target.field_70161_v - this.dragZ;
        Vec3 connection = Vec3.func_72443_a((double)(this.target.field_70165_t - sx), (double)(this.target.field_70163_u - sy), (double)(this.target.field_70161_v - sz));
        this.startRotation = (float)((double)this.field_70146_Z.nextFloat() * Math.PI * 2.0);
        this.endRadius = 0.35f + this.field_70146_Z.nextFloat() * 0.35f;
        this.field_70165_t = sx + connection.field_72450_a * (double)(1.0f - (1.0f - this.progress) * (1.0f - this.progress) * (1.0f - this.progress)) + Math.sin((double)this.startRotation + (double)(this.progress * 4.0f) * Math.PI * 2.0) * (double)this.progress * (double)this.endRadius;
        this.field_70163_u = sy + connection.field_72448_b * (double)this.progress + (this.target == TheBetweenlands.proxy.getClientPlayer() ? -1.25 : 0.6);
        this.field_70161_v = sz + connection.field_72449_c * (double)(1.0f - (1.0f - this.progress) * (1.0f - this.progress) * (1.0f - this.progress)) + Math.cos((double)this.startRotation + (double)(this.progress * 4.0f) * Math.PI * 2.0) * (double)this.progress * (double)this.endRadius;
        this.field_70142_S = this.field_70169_q = this.field_70165_t;
        this.field_70137_T = this.field_70167_r = this.field_70163_u;
        this.field_70136_U = this.field_70166_s = this.field_70161_v;
        this.field_70547_e = maxAge;
        this.field_70145_X = false;
        this.color = color;
        this.scale = scale;
        this.textures = textures;
        this.relativeTextureHeight = 1.0 / (double)this.textures;
        this.particleTexture = texture;
    }

    public void func_70539_a(Tessellator par1Tessellator, float partialTicks, float rx, float rxz, float rz, float ryz, float rxy) {
        float ipx = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTicks - field_70556_an);
        float ipy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTicks - field_70554_ao);
        float ipz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTicks - field_70555_ap);
        int prevTex = GL11.glGetInteger((int)32873);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.particleTexture);
        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78380_c(this.func_70070_b(partialTicks));
        par1Tessellator.func_78369_a(r, g, b, a);
        par1Tessellator.func_78374_a((double)(ipx - rx * this.scale - ryz * this.scale), (double)(ipy - rxz * this.scale), (double)(ipz - rz * this.scale - rxy * this.scale), 1.0, (double)(this.currentTexture + 1) * this.relativeTextureHeight);
        par1Tessellator.func_78374_a((double)(ipx - rx * this.scale + ryz * this.scale), (double)(ipy + rxz * this.scale), (double)(ipz - rz * this.scale + rxy * this.scale), 1.0, (double)this.currentTexture * this.relativeTextureHeight);
        par1Tessellator.func_78374_a((double)(ipx + rx * this.scale + ryz * this.scale), (double)(ipy + rxz * this.scale), (double)(ipz + rz * this.scale + rxy * this.scale), 0.0, (double)this.currentTexture * this.relativeTextureHeight);
        par1Tessellator.func_78374_a((double)(ipx + rx * this.scale - ryz * this.scale), (double)(ipy - rxz * this.scale), (double)(ipz + rz * this.scale - rxy * this.scale), 0.0, (double)(this.currentTexture + 1) * this.relativeTextureHeight);
        par1Tessellator.func_78381_a();
        GL11.glBindTexture((int)3553, (int)prevTex);
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_70071_h_() {
        double my;
        super.func_70071_h_();
        if (this.target == null || !this.target.func_70089_S() || this.progress > 1.0f) {
            this.func_70106_y();
            return;
        }
        this.progress += 0.01f;
        float dragIncrement = 0.1f;
        double tmx = this.target.field_70165_t - this.target.field_70142_S;
        double tmy = this.target.field_70163_u - this.target.field_70137_T;
        double tmz = this.target.field_70161_v - this.target.field_70136_U;
        if (this.dragX > tmx * 4.0) {
            this.dragX -= (double)dragIncrement;
        } else if (this.dragX < tmx * 4.0) {
            this.dragX += (double)dragIncrement;
        }
        if (Math.abs(this.dragX - tmx * 4.0) <= (double)dragIncrement) {
            this.dragX = tmx * 4.0;
        }
        double d = my = this.target.field_70124_G ? 0.0 : tmy * 4.0;
        if (this.dragY > my) {
            this.dragY -= (double)dragIncrement;
        } else if (this.dragY < my) {
            this.dragY += (double)dragIncrement;
        }
        if (Math.abs(this.dragY - my) <= (double)dragIncrement) {
            this.dragY = my;
        }
        if (this.dragZ > tmz * 4.0) {
            this.dragZ -= (double)dragIncrement;
        } else if (this.dragZ < tmz * 4.0) {
            this.dragZ += (double)dragIncrement;
        }
        if (Math.abs(this.dragZ - tmz * 4.0) <= (double)dragIncrement) {
            this.dragZ = tmz * 4.0;
        }
        this.dragX = MathHelper.func_151237_a((double)this.dragX, (double)-1.0, (double)1.0);
        this.dragY = MathHelper.func_151237_a((double)this.dragY, (double)-0.3, (double)1.0);
        this.dragZ = MathHelper.func_151237_a((double)this.dragZ, (double)-1.0, (double)1.0);
        double sx = this.target.field_70165_t - this.dragX;
        double sy = this.target.field_70163_u - 1.6 - this.dragY;
        double sz = this.target.field_70161_v - this.dragZ;
        Vec3 connection = Vec3.func_72443_a((double)(this.target.field_70165_t - sx), (double)(this.target.field_70163_u - sy), (double)(this.target.field_70161_v - sz));
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70165_t = sx + connection.field_72450_a * (double)(1.0f - (1.0f - this.progress) * (1.0f - this.progress) * (1.0f - this.progress)) + Math.sin((double)this.startRotation + (double)(this.progress * 4.0f) * Math.PI * 2.0) * (double)this.progress * (double)this.endRadius;
        this.field_70163_u = sy + connection.field_72448_b * (double)this.progress + (this.target == TheBetweenlands.proxy.getClientPlayer() ? -1.25 : 1.0);
        this.field_70161_v = sz + connection.field_72449_c * (double)(1.0f - (1.0f - this.progress) * (1.0f - this.progress) * (1.0f - this.progress)) + Math.cos((double)this.startRotation + (double)(this.progress * 4.0f) * Math.PI * 2.0) * (double)this.progress * (double)this.endRadius;
        ++this.textureCounter;
        if (this.textureCounter >= 5) {
            this.textureCounter = 0;
            ++this.currentTexture;
            if (this.currentTexture >= this.textures) {
                this.currentTexture = 0;
            }
        }
    }
}

