/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs.boss.fortress;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBoss;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBossProjectile;

public class EntityFortressBossTurret
extends EntityMob
implements IEntityBL {
    public static final int TARGET_DW = 17;
    public static final int OWNER_DW = 18;
    public static final int DEFLECTION_STATE_DW = 19;
    private boolean particlesSpawned = false;
    private double anchorX;
    private double anchorY;
    private double anchorZ;
    private int attackTicks = 0;
    private int attackDelay = 40;

    public EntityFortressBossTurret(World world) {
        super(world);
        float width = 0.4f;
        float height = 0.4f;
        this.func_70105_a(width, height);
    }

    public EntityFortressBossTurret(World world, Entity source) {
        super(world);
        if (source != null) {
            this.setOwner(source.func_110124_au().toString());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(18, (Object)"");
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public void setDeflectable(boolean deflectable) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)(deflectable ? 1 : 0)));
    }

    public boolean isDeflectable() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    protected String getTargetUUID() {
        return this.field_70180_af.func_75681_e(17);
    }

    protected void setTargetUUID(String uuid) {
        this.field_70180_af.func_75692_b(17, (Object)(uuid != null ? uuid : ""));
    }

    public void setTarget(EntityPlayer target) {
        this.setTargetUUID(target.func_110124_au().toString());
    }

    public void setOwner(String ownerUUID) {
        this.field_70180_af.func_75692_b(18, (Object)ownerUUID);
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(18);
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID p_152378_1_) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!p_152378_1_.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public EntityPlayer getTarget() {
        if (this.getTargetUUID() != null && this.getTargetUUID().length() > 0) {
            try {
                return this.field_70170_p.func_152378_a(UUID.fromString(this.getTargetUUID()));
            }
            catch (IllegalArgumentException ex) {
                this.setTargetUUID("");
                return null;
            }
        }
        return null;
    }

    @Override
    public String pageName() {
        return "thisShouldntHaveAPageButTheManualImplementationForcesMeToGiveItAPageName";
    }

    public int getAttackDelay() {
        return this.attackDelay;
    }

    public void setAttackDelay(int delay) {
        this.attackDelay = delay;
    }

    public void setAnchor(double x, double y, double z) {
        this.anchorX = x;
        this.anchorY = y;
        this.anchorZ = z;
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public double getAnchorY() {
        return this.anchorY;
    }

    public double getAnchorZ() {
        return this.anchorZ;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("anchorX", this.anchorX);
        nbt.func_74780_a("anchorY", this.anchorY);
        nbt.func_74780_a("anchorZ", this.anchorZ);
        nbt.func_74778_a("targetUUID", this.getTargetUUID());
        nbt.func_74778_a("ownerUUID", this.getOwnerUUID());
        nbt.func_74768_a("attackDelay", this.attackDelay);
        nbt.func_74757_a("deflectable", this.isDeflectable());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.anchorX = nbt.func_74769_h("anchorX");
        this.anchorY = nbt.func_74769_h("anchorY");
        this.anchorZ = nbt.func_74769_h("anchorZ");
        this.setTargetUUID(nbt.func_74779_i("targetUUID"));
        this.setOwner(nbt.func_74779_i("ownerUUID"));
        this.attackDelay = nbt.func_74762_e("attackDelay");
        this.setDeflectable(nbt.func_74767_n("deflectable"));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        super.func_110161_a(data);
        this.anchorX = this.field_70165_t;
        this.anchorY = this.field_70163_u;
        this.anchorZ = this.field_70161_v;
        return data;
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (!this.particlesSpawned) {
                this.particlesSpawned = true;
                for (i = 0; i < 6; ++i) {
                    this.spawnVolatileParticles();
                }
            }
            if (this.field_70170_p.field_73012_v.nextInt(6) == 0) {
                BLParticle.GREEN_FLAME.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)0.2f, this.field_70161_v, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 5.0f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 5.0f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 5.0f, 1.0f, new Object[0]);
            }
        }
        if (this.getTarget() == null) {
            AxisAlignedBB searchBB = this.field_70121_D.func_72314_b(16.0, 16.0, 16.0);
            List eligiblePlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, searchBB);
            EntityPlayer closest = null;
            for (EntityPlayer player : eligiblePlayers) {
                if (closest != null && !(closest.func_70032_d((Entity)this) > player.func_70032_d((Entity)this))) continue;
                closest = player;
            }
            if (closest != null) {
                this.setTarget(closest);
            }
        }
        if (this.getTarget() != null) {
            this.func_70625_a((Entity)this.getTarget(), 360.0f, 360.0f);
            ++this.attackTicks;
            if (this.attackTicks > this.attackDelay) {
                if (!this.field_70170_p.field_72995_K) {
                    if (!this.isObstructedByBoss()) {
                        Vec3 diff = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72444_a(Vec3.func_72443_a((double)(this.getTarget().field_70121_D.field_72340_a + (this.getTarget().field_70121_D.field_72336_d - this.getTarget().field_70121_D.field_72340_a) / 2.0), (double)(this.getTarget().field_70121_D.field_72338_b + (this.getTarget().field_70121_D.field_72337_e - this.getTarget().field_70121_D.field_72338_b) / 2.0), (double)(this.getTarget().field_70121_D.field_72339_c + (this.getTarget().field_70121_D.field_72334_f - this.getTarget().field_70121_D.field_72339_c) / 2.0))).func_72432_b();
                        EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, this.getOwner());
                        bullet.setDeflectable(this.isDeflectable());
                        bullet.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                        float speed = 0.5f;
                        bullet.func_70186_c(diff.field_72450_a, diff.field_72448_b, diff.field_72449_c, speed, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)bullet);
                    }
                    this.func_70106_y();
                } else {
                    for (i = 0; i < 6; ++i) {
                        this.spawnVolatileParticles();
                    }
                    this.func_70106_y();
                }
            }
        } else {
            this.attackTicks = 0;
        }
    }

    public boolean isObstructedByBoss() {
        Vec3 ray = this.func_70040_Z().func_72432_b();
        Vec3 currentPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 nextPos = currentPos.func_72441_c(ray.field_72450_a * 64.0, ray.field_72448_b * 64.0, ray.field_72449_c * 64.0);
        Entity hitEntity = null;
        List hitEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
        double minDist = 0.0;
        for (int i = 0; i < hitEntities.size(); ++i) {
            double dst;
            float f;
            AxisAlignedBB entityBB;
            MovingObjectPosition result;
            Entity entity = (Entity)hitEntities.get(i);
            if (!entity.func_70067_L() || (result = (entityBB = entity.field_70121_D.func_72314_b((double)(f = 0.525f), (double)f, (double)f)).func_72327_a(currentPos, nextPos)) == null || !((dst = currentPos.func_72438_d(result.field_72307_f)) < minDist) && minDist != 0.0) continue;
            hitEntity = entity;
            minDist = dst;
        }
        return hitEntity != null && (hitEntity instanceof EntityFortressBoss || hitEntity == this.getOwner());
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVolatileParticles() {
        double radius = 0.3f;
        double cx = this.field_70165_t;
        double cy = this.field_70163_u + 0.35;
        double cz = this.field_70161_v;
        for (int i = 0; i < 8; ++i) {
            double px = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double py = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double pz = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            Vec3 vec = Vec3.func_72443_a((double)px, (double)py, (double)pz).func_72444_a(Vec3.func_72443_a((double)0.35f, (double)0.35f, (double)0.35f)).func_72432_b();
            px = cx + vec.field_72450_a * (double)0.3f;
            py = cy + vec.field_72448_b * (double)0.3f;
            pz = cz + vec.field_72449_c * (double)0.3f;
            BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70090_H()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_70058_J()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            float groundFriction = 0.16277136f / (friction * friction * friction);
            this.func_70060_a(strafe, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
            friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double dx = this.field_70165_t - this.field_70169_q;
        double dz = this.field_70161_v - this.field_70166_s;
        float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
        if (distanceMoved > 1.0f) {
            distanceMoved = 1.0f;
        }
        this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public boolean func_70652_k(Entity target) {
        return false;
    }
}

