/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs.boss.fortress;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.entities.mobs.IEntityBL;

public class EntityFortressBossSpawner
extends EntityMob
implements IEntityBL {
    public static final int OWNER_DW = 18;
    private double anchorX;
    private double anchorY;
    private double anchorZ;
    public int spawnDelay = 40;
    public final int maxSpawnDelay = 40;
    private String ownerUUID = "";

    public EntityFortressBossSpawner(World world) {
        super(world);
        float width = 0.4f;
        float height = 0.4f;
        this.func_70105_a(width, height);
    }

    public EntityFortressBossSpawner(World world, Entity source) {
        super(world);
        if (source != null) {
            this.setOwner(source.func_110124_au().toString());
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    @Override
    public String pageName() {
        return "thisShouldntHaveAPageButTheManualImplementationForcesMeToGiveItAPageName";
    }

    public void setOwner(String ownerUUID) {
        this.ownerUUID = ownerUUID == null ? "" : ownerUUID;
        Entity owner = this.getOwnerFromUUID();
        this.field_70180_af.func_75692_b(18, (Object)(owner != null ? owner.func_145782_y() : -1));
    }

    private Entity getOwnerFromUUID() {
        try {
            UUID uuid = UUID.fromString(this.ownerUUID);
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public Entity getOwner() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(18));
        }
        return this.getOwnerFromUUID();
    }

    private Entity getEntityByUUID(UUID p_152378_1_) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!p_152378_1_.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public void setAnchor(double x, double y, double z) {
        this.anchorX = x;
        this.anchorY = y;
        this.anchorZ = z;
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public double getAnchorY() {
        return this.anchorY;
    }

    public double getAnchorZ() {
        return this.anchorZ;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("anchorX", this.anchorX);
        nbt.func_74780_a("anchorY", this.anchorY);
        nbt.func_74780_a("anchorZ", this.anchorZ);
        nbt.func_74768_a("spawnDelay", this.spawnDelay);
        nbt.func_74778_a("ownerUUID", this.ownerUUID != null ? this.ownerUUID : "");
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.anchorX = nbt.func_74769_h("anchorX");
        this.anchorY = nbt.func_74769_h("anchorY");
        this.anchorZ = nbt.func_74769_h("anchorZ");
        this.spawnDelay = nbt.func_74762_e("spawnDelay");
        this.setOwner(nbt.func_74779_i("ownerUUID"));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        super.func_110161_a(data);
        this.anchorX = this.field_70165_t;
        this.anchorY = this.field_70163_u;
        this.anchorZ = this.field_70161_v;
        return data;
    }

    public void func_70071_h_() {
        Entity owner;
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
            for (int i = 0; i < 3; ++i) {
                double sx = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double sy = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25;
                double sz = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double ex = owner.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)owner.field_70130_N;
                double ey = owner.field_70163_u + this.field_70146_Z.nextDouble() * (double)owner.field_70131_O - 0.25;
                double ez = owner.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)owner.field_70130_N;
                this.field_70170_p.func_72869_a("portal", sx, sy, sz, ex - sx, ey - sy, ez - sz);
            }
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        } else if (!this.field_70170_p.field_72995_K) {
            EntityWight wight = new EntityWight(this.field_70170_p);
            wight.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            wight.setCanTurnVolatile(false);
            wight.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            wight.func_70606_j(wight.func_110138_aP());
            this.field_70170_p.func_72838_d((Entity)wight);
            this.func_70106_y();
        } else {
            for (int i = 0; i < 6; ++i) {
                this.spawnVolatileParticles();
            }
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVolatileParticles() {
        double radius = 0.3f;
        double cx = this.field_70165_t;
        double cy = this.field_70163_u + 0.35;
        double cz = this.field_70161_v;
        for (int i = 0; i < 8; ++i) {
            double px = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double py = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double pz = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            Vec3 vec = Vec3.func_72443_a((double)px, (double)py, (double)pz).func_72444_a(Vec3.func_72443_a((double)0.35f, (double)0.35f, (double)0.35f)).func_72432_b();
            px = cx + vec.field_72450_a * (double)0.3f;
            py = cy + vec.field_72448_b * (double)0.3f;
            pz = cz + vec.field_72449_c * (double)0.3f;
            BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        }
    }

    public void func_70612_e(float strafe, float forward) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_70652_k(Entity target) {
        return false;
    }
}

