/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs.boss.fortress;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBoss;

public class EntityFortressBossProjectile
extends Entity
implements IProjectile {
    public static final int OWNER_DW = 18;
    public static final int DEFLECTION_STATE_DW = 19;
    private String throwerUUID = "";
    private int ticksInAir = 0;
    private boolean canDismount = false;

    public EntityFortressBossProjectile(World world) {
        super(world);
        this.func_70105_a(0.65f, 0.65f);
        this.field_70145_X = true;
    }

    public EntityFortressBossProjectile(World world, Entity source) {
        this(world);
        if (source != null) {
            this.setOwner(source.func_110124_au().toString());
            this.setThrower(source.func_110124_au().toString());
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(18, (Object)"");
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public void setDeflectable(boolean deflectable) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)(deflectable ? 1 : 0)));
    }

    public boolean isDeflectable() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    public void setOwner(String ownerUUID) {
        this.field_70180_af.func_75692_b(18, (Object)ownerUUID);
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(18);
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void setThrower(String throwerUUID) {
        this.throwerUUID = throwerUUID;
    }

    public Entity getThrower() {
        try {
            UUID uuid = UUID.fromString(this.throwerUUID);
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID p_152378_1_) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!p_152378_1_.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    protected void onImpact(MovingObjectPosition target) {
        if (!(target.field_72308_g instanceof EntityFortressBossProjectile)) {
            if (target.field_72308_g != null && target.field_72308_g instanceof EntityLivingBase) {
                if (target.field_72308_g instanceof EntityFortressBoss) {
                    EntityFortressBoss boss = (EntityFortressBoss)target.field_72308_g;
                    Vec3 ray = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
                    ray = ray.func_72432_b();
                    ray.field_72450_a *= 64.0;
                    ray.field_72448_b *= 64.0;
                    ray.field_72449_c *= 64.0;
                    int shieldHit = boss.rayTraceShield(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), ray, false);
                    if (shieldHit >= 0) {
                        if (!this.field_70170_p.field_72995_K) {
                            boss.setShieldActive(shieldHit, false);
                            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:fortressBossShieldDown", 1.0f, 1.0f);
                            double angle = 0.3490658503988659;
                            for (int i = 0; i < 18; ++i) {
                                Vec3 dir = Vec3.func_72443_a((double)Math.sin(angle * (double)i), (double)0.0, (double)Math.cos(angle * (double)i));
                                dir = dir.func_72432_b();
                                float speed = 0.8f;
                                EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, this.getOwner());
                                bullet.func_70012_b(boss.field_70165_t, boss.field_70163_u, boss.field_70161_v, 0.0f, 0.0f);
                                bullet.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, speed, 0.0f);
                                this.field_70170_p.func_72838_d((Entity)bullet);
                            }
                        }
                    } else {
                        boss.func_70097_a(DamageSource.field_76377_j, 10.0f);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        boss.setFloating(false);
                    }
                } else {
                    target.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.getOwner()), 2.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            } else if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.func_70106_y();
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.isDeflectable()) {
            ItemStack heldItem;
            this.func_70018_K();
            if (source.func_76346_g() instanceof EntityPlayer && (heldItem = ((EntityPlayer)source.func_76346_g()).func_70694_bm()) != null && heldItem.func_77973_b() instanceof ItemSword && !this.field_70170_p.field_72995_K && source.func_76346_g().field_70153_n == null) {
                this.func_70078_a(source.func_76346_g());
                return true;
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        return false;
    }

    public double func_70033_W() {
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityPlayer && this.field_70154_o == TheBetweenlands.proxy.getClientPlayer()) {
            return -1.75;
        }
        return this.field_70129_M;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70128_L) {
            if (this.field_70154_o == null) {
                ++this.ticksInAir;
                if (this.ticksInAir > 200) {
                    this.func_70106_y();
                }
                Vec3 currentPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
                MovingObjectPosition hitObject = this.field_70170_p.func_72933_a(currentPos, nextPos);
                currentPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
                if (hitObject != null) {
                    nextPos = Vec3.func_72443_a((double)hitObject.field_72307_f.field_72450_a, (double)hitObject.field_72307_f.field_72448_b, (double)hitObject.field_72307_f.field_72449_c);
                }
                Entity hitEntity = null;
                List hitEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(0.1, 0.1, 0.1));
                double minDist = 0.0;
                for (int i = 0; i < hitEntities.size(); ++i) {
                    double d1;
                    float f;
                    AxisAlignedBB axisalignedbb;
                    MovingObjectPosition movingobjectposition1;
                    Entity entity = (Entity)hitEntities.get(i);
                    if (!entity.func_70067_L() || entity == this.getThrower() || entity == this || (movingobjectposition1 = (axisalignedbb = entity.field_70121_D.func_72314_b((double)(f = 0.1f), (double)f, (double)f)).func_72327_a(currentPos, nextPos)) == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < minDist) && minDist != 0.0) continue;
                    hitEntity = entity;
                    minDist = d1;
                }
                if (hitEntity != null) {
                    hitObject = new MovingObjectPosition(hitEntity);
                }
                if (hitObject != null && hitObject.field_72308_g != this.getThrower()) {
                    this.onImpact(hitObject);
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            } else if (this.field_70154_o instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.field_70154_o;
                ItemStack heldItem = player.func_70694_bm();
                if (!this.isDeflectable() || heldItem == null || !(heldItem.func_77973_b() instanceof ItemSword)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70106_y();
                    }
                } else {
                    player.func_70110_aj();
                    player.field_70181_x -= 1.5;
                    if (player.field_82175_bq) {
                        if (this.canDismount) {
                            Vec3 look = this.field_70154_o.func_70040_Z();
                            look.func_72432_b();
                            this.func_70186_c(look.field_72450_a, look.field_72448_b, look.field_72449_c, 0.5f, 0.0f);
                            this.field_70154_o = null;
                            this.setThrower(player.func_110124_au().toString());
                        }
                    } else {
                        this.canDismount = true;
                    }
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70186_c(double x, double y, double z, float speed, float randMotion) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.field_70133_I = true;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setOwner(nbt.func_74779_i("ownerUUID"));
        this.setThrower(nbt.func_74779_i("throwerUUID"));
        this.ticksInAir = nbt.func_74762_e("ticksInAir");
        this.canDismount = nbt.func_74767_n("canDismount");
        this.setDeflectable(nbt.func_74767_n("deflectable"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("ownerUUID", this.getOwnerUUID());
        nbt.func_74778_a("throwerUUID", this.throwerUUID);
        nbt.func_74768_a("ticksInAir", this.ticksInAir);
        nbt.func_74757_a("canDismount", this.canDismount);
        nbt.func_74757_a("deflectable", this.isDeflectable());
    }
}

