/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs.boss.fortress;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.entities.mobs.IEntityBL;

public class EntityFortressBossBlockade
extends EntityMob
implements IEntityBL {
    public static final int OWNER_DW = 18;
    public static final int SIZE_DW = 19;
    public static final int ROTATION_DW = 20;
    private String ownerUUID = "";
    private float rotation = 0.0f;
    private int despawnTicks = 0;
    private int maxDespawnTicks = 160;

    public EntityFortressBossBlockade(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.2f);
    }

    public EntityFortressBossBlockade(World world, Entity source) {
        super(world);
        if (source != null) {
            this.setOwner(source.func_110124_au().toString());
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)-1);
        this.field_70180_af.func_75682_a(19, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_75682_a(20, (Object)Float.valueOf(this.rotation));
    }

    public void setOwner(String ownerUUID) {
        this.ownerUUID = ownerUUID == null ? "" : ownerUUID;
        Entity owner = this.getOwnerFromUUID();
        this.field_70180_af.func_75692_b(18, (Object)(owner != null ? owner.func_145782_y() : -1));
    }

    private Entity getOwnerFromUUID() {
        try {
            UUID uuid = UUID.fromString(this.ownerUUID);
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public Entity getOwner() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(18));
        }
        return this.getOwnerFromUUID();
    }

    private Entity getEntityByUUID(UUID p_152378_1_) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!p_152378_1_.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public void setTriangleSize(float size) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(size));
        if (this.field_70170_p.field_72995_K) {
            double prevX = this.field_70165_t;
            double prevZ = this.field_70161_v;
            this.func_70105_a(size * 2.0f, this.field_70131_O);
            this.func_70107_b(prevX, this.field_70163_u, prevZ);
        }
    }

    public float getTriangleSize() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setMaxDespawnTicks(int ticks) {
        this.maxDespawnTicks = ticks;
    }

    public int getMaxDespawnTicks() {
        return this.maxDespawnTicks;
    }

    public int getDespawnTicks() {
        return this.despawnTicks;
    }

    @Override
    public String pageName() {
        return "thisShouldntHaveAPageButTheManualImplementationForcesMeToGiveItAPageName";
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("triangleSize", this.getTriangleSize());
        nbt.func_74776_a("triangleRotation", this.field_70180_af.func_111145_d(20));
        nbt.func_74768_a("despawnTicks", this.despawnTicks);
        nbt.func_74768_a("maxDespawnTicks", this.maxDespawnTicks);
        nbt.func_74778_a("ownerUUID", this.ownerUUID != null ? this.ownerUUID : "");
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTriangleSize(nbt.func_74760_g("triangleSize"));
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(nbt.func_74760_g("triangleRotation")));
        this.despawnTicks = nbt.func_74762_e("despawnTicks");
        this.maxDespawnTicks = nbt.func_74762_e("maxDespawnTicks");
        this.setOwner(nbt.func_74779_i("ownerUUID"));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        this.setTriangleSize(this.getTriangleSize());
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            ++this.despawnTicks;
            if (this.despawnTicks >= this.getMaxDespawnTicks()) {
                this.func_70106_y();
            }
            this.rotation += 1.0f;
            this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(this.rotation));
            List targets = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b((double)(this.getTriangleSize() * 2.0f), 0.0, (double)(this.getTriangleSize() * 2.0f)));
            for (EntityPlayer target : targets) {
                float damage;
                Vec3[] vertices = this.getTriangleVertices();
                if (!this.rayTraceTriangle(Vec3.func_72443_a((double)(target.field_70165_t - this.field_70165_t), (double)(this.field_70163_u + 1.0), (double)(target.field_70161_v - this.field_70161_v)), Vec3.func_72443_a((double)0.0, (double)-16.0, (double)0.0), vertices[0], vertices[1], vertices[2]) || !target.func_70097_a(DamageSource.field_76376_m, damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()) || this.getOwner() == null || !(this.getOwner() instanceof EntityLivingBase) || !(((EntityLivingBase)this.getOwner()).func_110143_aJ() < ((EntityLivingBase)this.getOwner()).func_110138_aP() - damage)) continue;
                ((EntityLivingBase)this.getOwner()).func_70691_i(damage * 3.0f);
            }
        } else {
            this.rotation = this.field_70180_af.func_111145_d(20);
            for (int c = 0; c < 4; ++c) {
                float r1 = this.field_70170_p.field_73012_v.nextFloat();
                float r2 = this.field_70170_p.field_73012_v.nextFloat();
                this.rotation += 15.0f;
                Vec3[] vertices = this.getTriangleVertices();
                this.rotation -= 15.0f;
                Vec3 rp = Vec3.func_72443_a((double)0.0, (double)vertices[0].field_72448_b, (double)0.0);
                block7: for (int i = 0; i < 3; ++i) {
                    Vec3 vertex = vertices[i];
                    switch (i) {
                        case 0: {
                            rp.field_72450_a += vertex.field_72450_a * (1.0 - Math.sqrt(r1));
                            rp.field_72449_c += vertex.field_72449_c * (1.0 - Math.sqrt(r1));
                            continue block7;
                        }
                        case 1: {
                            rp.field_72450_a += Math.sqrt(r1) * (double)(1.0f - r2) * vertex.field_72450_a;
                            rp.field_72449_c += Math.sqrt(r1) * (double)(1.0f - r2) * vertex.field_72449_c;
                            continue block7;
                        }
                        case 2: {
                            rp.field_72450_a += Math.sqrt(r1) * (double)r2 * vertex.field_72450_a;
                            rp.field_72449_c += Math.sqrt(r1) * (double)r2 * vertex.field_72449_c;
                        }
                    }
                }
                double sx = this.field_70165_t + rp.field_72450_a;
                double sy = this.field_70163_u + rp.field_72448_b + 4.0;
                double sz = this.field_70161_v + rp.field_72449_c;
                double ex = this.field_70165_t + rp.field_72450_a;
                double ey = this.field_70163_u + rp.field_72448_b;
                double ez = this.field_70161_v + rp.field_72449_c;
                if (this.getOwner() != null) {
                    sx = this.getOwner().field_70165_t;
                    sy = this.getOwner().field_70121_D.field_72338_b + (this.getOwner().field_70121_D.field_72337_e - this.getOwner().field_70121_D.field_72338_b) / 2.0;
                    sz = this.getOwner().field_70161_v;
                }
                this.field_70170_p.func_72869_a("portal", sx, sy, sz, ex - sx, ey - sy, ez - sz);
            }
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70090_H()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_70058_J()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            float groundFriction = 0.16277136f / (friction * friction * friction);
            this.func_70060_a(strafe, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
            friction = 0.91f;
            if (this.field_70122_E) {
                friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double dx = this.field_70165_t - this.field_70169_q;
        double dz = this.field_70161_v - this.field_70166_s;
        float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
        if (distanceMoved > 1.0f) {
            distanceMoved = 1.0f;
        }
        this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public Vec3[] getTriangleVertices() {
        Vec3[] vertices = new Vec3[3];
        double angle = 2.0943951023931953;
        for (int i = 0; i < 3; ++i) {
            double sin = Math.sin(angle * (double)i + Math.toRadians(this.rotation));
            double cos = Math.cos(angle * (double)i + Math.toRadians(this.rotation));
            vertices[i] = Vec3.func_72443_a((double)(sin * (double)this.getTriangleSize()), (double)0.0, (double)(cos * (double)this.getTriangleSize()));
        }
        return vertices;
    }

    public boolean func_70652_k(Entity target) {
        return false;
    }

    private boolean rayTraceTriangle(Vec3 pos, Vec3 ray, Vec3 v0, Vec3 v1, Vec3 v2) {
        Vec3 diff2;
        Vec3 rayCross;
        double epsilon = 1.0E-5;
        Vec3 diff1 = v1.func_72444_a(v0);
        double angleDifference = diff1.func_72430_b(rayCross = ray.func_72431_c(diff2 = v2.func_72444_a(v0)));
        if (angleDifference > -1.0E-5 && angleDifference < 1.0E-5) {
            return false;
        }
        double f = 1.0 / angleDifference;
        Vec3 s = pos.func_72444_a(v0);
        double u = f * s.func_72430_b(rayCross);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        Vec3 q = s.func_72431_c(diff1);
        double v = f * ray.func_72430_b(q);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = -f * diff2.func_72430_b(q);
        return t > 1.0E-5;
    }
}

