/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs.boss.fortress;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.IEntityMusic;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.entities.mobs.boss.IBossBL;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBossBlockade;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBossProjectile;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBossSpawner;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBossTurret;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.network.packet.client.PacketPlayIdleSound;
import thebetweenlands.utils.RotationMatrix;
import thebetweenlands.world.storage.chunk.storage.StorageHelper;
import thebetweenlands.world.storage.chunk.storage.location.GuardedLocationStorage;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class EntityFortressBoss
extends EntityMob
implements IEntityBL,
IBossBL,
IEntityMusic {
    public static final RotationMatrix ROTATION_MATRIX = new RotationMatrix();
    public static final int SHIELD_DW = 20;
    public static final int SHIELD_ROTATION_DW = 21;
    public static final int FLOATING_DW = 22;
    public static final int GROUND_ATTACK_STATE_DW = 23;
    public static final int ANCHOR_X_DW = 24;
    public static final int ANCHOR_Y_DW = 25;
    public static final int ANCHOR_Z_DW = 26;
    public static final int ANCHOR_RADIUS_DW = 27;
    public static final double SHIELD_OFFSET_X = 0.0;
    public static final double SHIELD_OFFSET_Y = 1.0;
    public static final double SHIELD_OFFSET_Z = 0.0;
    private static final double ICOSAHEDRON_X = 0.5257311121191336;
    private static final double ICOSAHEDRON_Z = 0.8506508083520399;
    public static final double[][] ICOSAHEDRON_VERTICES = new double[][]{{-0.5257311121191336, 0.0, 0.8506508083520399}, {0.5257311121191336, 0.0, 0.8506508083520399}, {-0.5257311121191336, 0.0, -0.8506508083520399}, {0.5257311121191336, 0.0, -0.8506508083520399}, {0.0, 0.8506508083520399, 0.5257311121191336}, {0.0, 0.8506508083520399, -0.5257311121191336}, {0.0, -0.8506508083520399, 0.5257311121191336}, {0.0, -0.8506508083520399, -0.5257311121191336}, {0.8506508083520399, 0.5257311121191336, 0.0}, {-0.8506508083520399, 0.5257311121191336, 0.0}, {0.8506508083520399, -0.5257311121191336, 0.0}, {-0.8506508083520399, -0.5257311121191336, 0.0}};
    public static final int[][] ICOSAHEDRON_INDICES = new int[][]{{0, 4, 1}, {0, 9, 4}, {9, 5, 4}, {4, 5, 8}, {4, 8, 1}, {8, 10, 1}, {8, 3, 10}, {5, 3, 8}, {5, 2, 3}, {2, 7, 3}, {7, 10, 3}, {7, 6, 10}, {7, 11, 6}, {11, 0, 6}, {0, 1, 6}, {6, 1, 10}, {9, 0, 11}, {9, 11, 2}, {9, 2, 5}, {7, 2, 11}};
    private boolean[] activeShields = new boolean[20];
    public int[] shieldAnimationTicks = new int[20];
    public final AxisAlignedBB coreBoundingBox;
    private double anchorX;
    private double anchorY;
    private double anchorZ;
    private double anchorRadius;
    public float shieldRotationYaw;
    public float shieldRotationPitch;
    public float shieldRotationRoll;
    public float lastShieldRotationYaw;
    public float lastShieldRotationPitch;
    public float lastShieldRotationRoll;
    public float shieldExplosion;
    public float lastShieldExplosion;
    private int groundTicks = 0;
    private int turretTicks = -1;
    private int groundAttackTicks = -1;
    private int turretStreak = -1;
    private int turretStreakTicks = 0;
    private int wightSpawnTicks = -1;
    private int teleportTicks = -1;
    private List<EntityLivingBase> trackedEntities = new ArrayList<EntityLivingBase>();
    private int blockadeSpawnTicks = -1;
    public int deathTicks = 0;

    public EntityFortressBoss(World world) {
        super(world);
        float width = 1.9f;
        float height = 1.9f;
        this.func_70105_a(width, height);
        float coreWidth = 1.0f;
        float coreHeight = 1.0f;
        this.coreBoundingBox = AxisAlignedBB.func_72330_a((double)(-coreWidth / 2.0f), (double)(0.0f + height / 4.0f), (double)(-coreWidth / 2.0f), (double)(coreWidth / 2.0f), (double)(coreHeight + height / 4.0f), (double)(coreWidth / 2.0f));
        for (int i = 0; i < 20; ++i) {
            this.activeShields[i] = true;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(320.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(22, (Object)1);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(25, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(26, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(27, (Object)Float.valueOf(0.0f));
    }

    @Override
    public String pageName() {
        return "fortressBoss";
    }

    public float getShieldExplosion(float partialTicks) {
        return this.lastShieldExplosion + (this.shieldExplosion - this.lastShieldExplosion) * partialTicks;
    }

    public void setAnchor(double x, double y, double z, double radius) {
        this.anchorX = x;
        this.anchorY = y;
        this.anchorZ = z;
        this.anchorRadius = radius;
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public double getAnchorY() {
        return this.anchorY;
    }

    public double getAnchorZ() {
        return this.anchorZ;
    }

    public double getAnchorRadius() {
        return this.anchorRadius;
    }

    private int packShieldData() {
        int packedData = 0;
        for (int i = 0; i <= 19; ++i) {
            packedData |= (this.activeShields[i] ? 1 : 0) << i;
        }
        return packedData;
    }

    private void unpackShieldData(int packedData) {
        for (int i = 0; i <= 19; ++i) {
            this.activeShields[i] = (packedData >> i & 1) == 1;
        }
    }

    public boolean hasShield() {
        for (int i = 0; i <= 19; ++i) {
            if (!this.activeShields[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isShieldActive(int shield) {
        return this.activeShields[shield];
    }

    public void setShieldActive(int shield, boolean active) {
        this.activeShields[shield] = active;
    }

    public int getGroundAttackTicks() {
        return this.groundAttackTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShieldRotationYaw(float partialTicks) {
        return this.lastShieldRotationYaw + (this.shieldRotationYaw - this.lastShieldRotationYaw) * partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShieldRotationPitch(float partialTicks) {
        return this.lastShieldRotationPitch + (this.shieldRotationPitch - this.lastShieldRotationPitch) * partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShieldRotationRoll(float partialTicks) {
        return this.lastShieldRotationRoll + (this.shieldRotationRoll - this.lastShieldRotationRoll) * partialTicks;
    }

    public int rayTraceShield(Vec3 pos, Vec3 ray, boolean back) {
        int shield = -1;
        double centroidX = 0.0;
        double centroidY = 0.0;
        double centroidZ = 0.0;
        ROTATION_MATRIX.setRotations((float)Math.toRadians(-this.shieldRotationPitch), (float)Math.toRadians(-this.shieldRotationYaw), (float)Math.toRadians(-this.shieldRotationRoll));
        Vec3 centerPos = Vec3.func_72443_a((double)(this.field_70165_t + 0.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 0.0));
        pos = ROTATION_MATRIX.transformVec(pos, centerPos);
        ray = ROTATION_MATRIX.transformVec(ray, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0));
        for (int i = 0; i <= 19; ++i) {
            if (!this.isShieldActive(i)) continue;
            double[] v3 = ICOSAHEDRON_VERTICES[ICOSAHEDRON_INDICES[i][0]];
            double[] v2 = ICOSAHEDRON_VERTICES[ICOSAHEDRON_INDICES[i][1]];
            double[] v1 = ICOSAHEDRON_VERTICES[ICOSAHEDRON_INDICES[i][2]];
            double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
            double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
            double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
            double len = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
            double a = len + (double)this.getShieldExplosion(1.0f);
            Vec3 center = Vec3.func_72443_a((double)centerX, (double)centerY, (double)centerZ);
            centerX += this.field_70165_t + 0.0;
            centerY += this.field_70163_u + 1.0;
            centerZ += this.field_70161_v + 0.0;
            Vec3 vert1Exploded = Vec3.func_72443_a((double)v1[0], (double)v1[1], (double)v1[2]);
            double b = vert1Exploded.func_72430_b(center);
            double d = a * Math.tan(b);
            double vertexExplode = Math.sqrt(a * a + d * d) - 1.0;
            Vec3 v1Normalized = Vec3.func_72443_a((double)v1[0], (double)v1[1], (double)v1[2]).func_72432_b();
            Vec3 v2Normalized = Vec3.func_72443_a((double)v2[0], (double)v2[1], (double)v2[2]).func_72432_b();
            Vec3 v3Normalized = Vec3.func_72443_a((double)v3[0], (double)v3[1], (double)v3[2]).func_72432_b();
            Vec3 vert1 = Vec3.func_72443_a((double)(v1[0] + v1Normalized.field_72450_a * vertexExplode), (double)(v1[1] + v1Normalized.field_72448_b * vertexExplode), (double)(v1[2] + v1Normalized.field_72449_c * vertexExplode));
            Vec3 vert2 = Vec3.func_72443_a((double)(v2[0] + v2Normalized.field_72450_a * vertexExplode), (double)(v2[1] + v2Normalized.field_72448_b * vertexExplode), (double)(v2[2] + v2Normalized.field_72449_c * vertexExplode));
            Vec3 vert3 = Vec3.func_72443_a((double)(v3[0] + v3Normalized.field_72450_a * vertexExplode), (double)(v3[1] + v3Normalized.field_72448_b * vertexExplode), (double)(v3[2] + v3Normalized.field_72449_c * vertexExplode));
            vert1 = vert1.func_72441_c(this.field_70165_t + 0.0, this.field_70163_u + 1.0, this.field_70161_v + 0.0);
            vert2 = vert2.func_72441_c(this.field_70165_t + 0.0, this.field_70163_u + 1.0, this.field_70161_v + 0.0);
            vert3 = vert3.func_72441_c(this.field_70165_t + 0.0, this.field_70163_u + 1.0, this.field_70161_v + 0.0);
            Vec3 normal = vert2.func_72444_a(vert1).func_72431_c(vert3.func_72444_a(vert1));
            if (!this.rayTraceTriangle(pos, ray, vert1, vert2, vert3) || !back && !(normal.func_72432_b().func_72430_b(ray.func_72432_b()) < Math.cos(Math.toRadians(90.0)))) continue;
            double dx = centerX - pos.field_72450_a;
            double dy = centerY - pos.field_72448_b;
            double dz = centerZ - pos.field_72449_c;
            double pdx = centroidX - pos.field_72450_a;
            double pdy = centroidY - pos.field_72448_b;
            double pdz = centroidZ - pos.field_72449_c;
            if (shield != -1 && !(Math.sqrt(dx * dx + dy * dy + dz * dz) < Math.sqrt(pdx * pdx + pdy * pdy + pdz * pdz))) continue;
            shield = i;
            centroidX = centerX;
            centroidY = centerY;
            centroidZ = centerZ;
        }
        return shield;
    }

    private boolean rayTraceTriangle(Vec3 pos, Vec3 ray, Vec3 v0, Vec3 v1, Vec3 v2) {
        Vec3 diff2;
        Vec3 rayCross;
        double epsilon = 1.0E-5;
        Vec3 diff1 = v1.func_72444_a(v0);
        double angleDifference = diff1.func_72430_b(rayCross = ray.func_72431_c(diff2 = v2.func_72444_a(v0)));
        if (angleDifference > -1.0E-5 && angleDifference < 1.0E-5) {
            return false;
        }
        double f = 1.0 / angleDifference;
        Vec3 s = pos.func_72444_a(v0);
        double u = f * s.func_72430_b(rayCross);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        Vec3 q = s.func_72431_c(diff1);
        double v = f * ray.func_72430_b(q);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = -f * diff2.func_72430_b(q);
        return t > 1.0E-5;
    }

    public boolean isFloating() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setFloating(boolean floating) {
        this.field_70180_af.func_75692_b(22, (Object)((byte)(floating ? 1 : 0)));
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_76346_g() instanceof Entity) {
            int shieldHit;
            Entity entity = ((EntityDamageSource)source).func_76346_g();
            if (source instanceof EntityDamageSourceIndirect && ((EntityDamageSourceIndirect)source).func_76364_f() != null) {
                entity = ((EntityDamageSourceIndirect)source).func_76364_f();
            }
            if (entity == null) {
                return false;
            }
            Vec3 ray = entity.func_70040_Z();
            if (!(entity instanceof EntityLivingBase)) {
                ray = Vec3.func_72443_a((double)entity.field_70159_w, (double)entity.field_70181_x, (double)entity.field_70179_y).func_72432_b();
            }
            ray.field_72450_a *= 64.0;
            ray.field_72448_b *= 64.0;
            ray.field_72449_c *= 64.0;
            Vec3 pos = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e() + (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af() ? -0.08 : 0.0)), (double)entity.field_70161_v);
            if ((this.hasShield() && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d) || entity.func_70093_af()) && (shieldHit = this.rayTraceShield(pos, ray, false)) >= 0) {
                if (!this.field_70170_p.field_72995_K && entity.func_70093_af() && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                    this.setShieldActive(shieldHit, false);
                }
                if (this.field_70170_p.field_72995_K) {
                    this.shieldAnimationTicks[shieldHit] = 20;
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:fortressBossNope", 1.0f, 1.0f, false);
                }
                double dx = entity.field_70165_t - this.field_70165_t;
                double dy = entity.field_70163_u - this.field_70163_u;
                double dz = entity.field_70161_v - this.field_70161_v;
                double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
                entity.field_70159_w = dx / len * (double)0.8f;
                entity.field_70181_x = dy / len * (double)0.8f;
                entity.field_70179_y = dz / len * (double)0.8f;
                entity.func_70097_a(DamageSource.field_76376_m, 2.0f);
                return false;
            }
            MovingObjectPosition result = this.coreBoundingBox.func_72325_c(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72327_a(pos, ray.func_72441_c(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
            if (result != null) {
                return super.func_70097_a(source, damage);
            }
            return false;
        }
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("shields", this.packShieldData());
        nbt.func_74780_a("anchorX", this.anchorX);
        nbt.func_74780_a("anchorY", this.anchorY);
        nbt.func_74780_a("anchorZ", this.anchorZ);
        nbt.func_74780_a("anchorRadius", this.anchorRadius);
        nbt.func_74757_a("floating", this.isFloating());
        nbt.func_74768_a("groundTicks", this.groundTicks);
        nbt.func_74768_a("turretTicks", this.turretTicks);
        nbt.func_74768_a("groundAttackTicks", this.groundAttackTicks);
        nbt.func_74768_a("turretStreak", this.turretStreak);
        nbt.func_74768_a("turretStreakTicks", this.turretStreakTicks);
        nbt.func_74768_a("wightSpawnTicks", this.wightSpawnTicks);
        nbt.func_74768_a("teleportTicks", this.teleportTicks);
        nbt.func_74768_a("blockadeSpawnTicks", this.blockadeSpawnTicks);
        nbt.func_74768_a("deathTicks", this.deathTicks);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.unpackShieldData(nbt.func_74762_e("shields"));
        this.anchorX = nbt.func_74769_h("anchorX");
        this.anchorY = nbt.func_74769_h("anchorY");
        this.anchorZ = nbt.func_74769_h("anchorZ");
        this.anchorRadius = nbt.func_74769_h("anchorRadius");
        this.setFloating(nbt.func_74767_n("floating"));
        this.groundTicks = nbt.func_74762_e("groundTicks");
        this.turretTicks = nbt.func_74762_e("turretTicks");
        this.groundAttackTicks = nbt.func_74762_e("groundAttackTicks");
        this.turretStreak = nbt.func_74762_e("turretStreak");
        this.turretStreakTicks = nbt.func_74762_e("turretStreakTicks");
        this.wightSpawnTicks = nbt.func_74762_e("wightSpawnTicks");
        this.teleportTicks = nbt.func_74762_e("teleportTicks");
        this.blockadeSpawnTicks = nbt.func_74762_e("blockadeSpawnTicks");
        this.deathTicks = nbt.func_74762_e("deathTicks");
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        super.func_110161_a(data);
        this.anchorX = this.field_70165_t;
        this.anchorY = this.field_70163_u;
        this.anchorZ = this.field_70161_v;
        this.anchorRadius = 10.0;
        return data;
    }

    public void func_70653_a(Entity entity, float dmg, double x, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityPlayer closestPlayer = this.field_70170_p.func_72856_b((Entity)this, 32.0);
        if (closestPlayer != null) {
            this.func_70625_a((Entity)closestPlayer, 360.0f, 360.0f);
        }
        this.lastShieldRotationYaw = this.shieldRotationYaw;
        this.lastShieldRotationPitch = this.shieldRotationPitch;
        this.lastShieldRotationRoll = this.shieldRotationRoll;
        this.lastShieldExplosion = this.shieldExplosion;
        this.shieldExplosion = this.func_70089_S() ? 0.2f : 0.2f + (float)(this.deathTicks % 16) / 16.0f * ((float)this.deathTicks / 60.0f);
        float shieldRotation = 0.0f;
        if (this.field_70170_p.field_72995_K) {
            shieldRotation = this.field_70180_af.func_111145_d(21);
            this.anchorX = this.field_70180_af.func_111145_d(24);
            this.anchorY = this.field_70180_af.func_111145_d(25);
            this.anchorZ = this.field_70180_af.func_111145_d(26);
            this.anchorRadius = this.field_70180_af.func_111145_d(27);
            this.unpackShieldData(this.field_70180_af.func_75679_c(20));
        } else {
            if (this.func_70089_S()) {
                shieldRotation = this.field_70173_aa;
                this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(shieldRotation + 1.0f));
            }
            this.field_70180_af.func_75692_b(24, (Object)Float.valueOf((float)this.anchorX));
            this.field_70180_af.func_75692_b(25, (Object)Float.valueOf((float)this.anchorY));
            this.field_70180_af.func_75692_b(26, (Object)Float.valueOf((float)this.anchorZ));
            this.field_70180_af.func_75692_b(27, (Object)Float.valueOf((float)this.anchorRadius));
        }
        int activeShields = 0;
        for (int i = 0; i <= 19; ++i) {
            if (!this.isShieldActive(i)) continue;
            ++activeShields;
        }
        if (this.func_70089_S()) {
            this.shieldRotationYaw = shieldRotation * (1.0f + 0.3f * (float)(20 - activeShields));
            this.shieldRotationPitch = shieldRotation * (1.4f + 0.4f * (float)(20 - activeShields));
            this.shieldRotationRoll = shieldRotation * (1.6f + 0.5f * (float)(20 - activeShields));
        } else {
            this.shieldRotationYaw = shieldRotation * 2.0f;
            this.shieldRotationPitch = 0.0f;
            this.shieldRotationRoll = 0.0f;
        }
        if (this.func_70089_S()) {
            AxisAlignedBB checkArea;
            List players;
            if (!this.field_70170_p.field_72995_K) {
                int tpy;
                if (this.isFloating() && this.field_70163_u < this.anchorY) {
                    this.field_70181_x = 0.1f;
                } else if (!this.isFloating()) {
                    this.field_70181_x += (double)-0.1f;
                    ++this.groundTicks;
                    if (this.groundTicks > 180 && this.groundAttackTicks > 20) {
                        this.groundTicks = 0;
                        this.setFloating(true);
                    }
                }
                if (this.isFloating() && (this.func_70011_f(this.anchorX, this.field_70163_u, this.anchorZ) > this.anchorRadius || Math.abs(this.field_70163_u - this.anchorY) > this.anchorRadius)) {
                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:fortressBossTeleport", 1.0f, 1.0f);
                    this.func_70107_b(this.anchorX, this.anchorY, this.anchorZ);
                }
                List currentlyTrackedEntities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(this.anchorRadius * 2.0, 512.0, this.anchorRadius * 2.0));
                Iterator it = currentlyTrackedEntities.iterator();
                while (it.hasNext()) {
                    EntityLivingBase living = (EntityLivingBase)it.next();
                    if (!(living.func_70011_f(this.anchorX, living.field_70163_u, this.anchorZ) > this.anchorRadius) && !(Math.abs(living.field_70163_u - this.anchorY) > this.anchorRadius)) continue;
                    it.remove();
                }
                if (!this.trackedEntities.isEmpty() && Math.abs(this.anchorY - (double)(tpy = this.field_70170_p.func_72976_f(MathHelper.func_76128_c((double)this.anchorX), MathHelper.func_76128_c((double)this.anchorZ)))) < this.anchorRadius) {
                    for (EntityLivingBase living : this.trackedEntities) {
                        if (living == null || !living.func_70089_S() || currentlyTrackedEntities.contains(living) || living instanceof EntityPlayer && ((EntityPlayer)living).field_71075_bZ.field_75098_d) continue;
                        if (living instanceof EntityPlayerMP) {
                            EntityPlayerMP player = (EntityPlayerMP)living;
                            player.func_70078_a(null);
                            player.field_71135_a.func_147364_a(this.anchorX, (double)tpy, this.anchorZ, player.field_70177_z, player.field_70125_A);
                        } else {
                            living.func_70078_a(null);
                            living.func_70012_b(this.anchorX, (double)tpy, this.anchorZ, living.field_70177_z, living.field_70125_A);
                        }
                        living.field_70143_R = 0.0f;
                        living.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 60, 2));
                        currentlyTrackedEntities.add(living);
                    }
                }
                this.trackedEntities.clear();
                this.trackedEntities.addAll(currentlyTrackedEntities);
            }
            if (!(players = this.field_70170_p.func_72872_a(EntityPlayer.class, checkArea = this.field_70121_D.func_72314_b(32.0, 16.0, 32.0))).isEmpty()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70180_af.func_75692_b(20, (Object)this.packShieldData());
                    if (this.isFloating() && this.field_70163_u >= this.anchorY) {
                        List blockades;
                        AxisAlignedBB checkAABB = this.field_70121_D.func_72314_b(16.0, 16.0, 16.0);
                        List wights = this.field_70170_p.func_72872_a(EntityWight.class, checkAABB);
                        List spawners = this.field_70170_p.func_72872_a(EntityFortressBossSpawner.class, checkAABB);
                        if (wights.isEmpty() && spawners.isEmpty()) {
                            --this.wightSpawnTicks;
                            if (this.wightSpawnTicks <= 0) {
                                int spawnY;
                                if (this.wightSpawnTicks == 0 && Math.abs((double)(spawnY = this.field_70170_p.func_72976_f(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v))) - this.field_70163_u) < this.anchorRadius) {
                                    EntityFortressBossSpawner spawner = new EntityFortressBossSpawner(this.field_70170_p, (Entity)this);
                                    spawner.func_70012_b(MathHelper.func_76128_c((double)this.field_70165_t), spawnY, MathHelper.func_76128_c((double)this.field_70161_v), 0.0f, 0.0f);
                                    this.field_70170_p.func_72838_d((Entity)spawner);
                                }
                                this.wightSpawnTicks = 160 + this.field_70170_p.field_73012_v.nextInt(200);
                            }
                        }
                        if ((blockades = this.field_70170_p.func_72872_a(EntityFortressBossBlockade.class, checkAABB)).isEmpty()) {
                            --this.blockadeSpawnTicks;
                            if (this.blockadeSpawnTicks <= 0) {
                                int spawnY;
                                if (this.blockadeSpawnTicks == 0 && Math.abs((double)(spawnY = this.field_70170_p.func_72976_f(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v))) - this.field_70163_u) < this.anchorRadius) {
                                    EntityFortressBossBlockade blockade = new EntityFortressBossBlockade(this.field_70170_p, (Entity)this);
                                    blockade.func_70012_b(this.field_70165_t, spawnY, this.field_70161_v, 0.0f, 0.0f);
                                    blockade.setTriangleSize(1.2f + this.field_70170_p.field_73012_v.nextFloat() * 1.6f);
                                    blockade.setMaxDespawnTicks(400);
                                    this.field_70170_p.func_72838_d((Entity)blockade);
                                }
                                this.blockadeSpawnTicks = 190 + this.field_70170_p.field_73012_v.nextInt(160);
                            }
                        }
                        --this.teleportTicks;
                        if (this.teleportTicks <= 0) {
                            if (this.teleportTicks == 0) {
                                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:fortressBossTeleport", 1.0f, 1.0f);
                                this.func_70012_b(this.anchorX + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f) * (this.anchorRadius - 1.0), this.anchorY, this.anchorZ + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f) * (this.anchorRadius - 1.0), 0.0f, 0.0f);
                            }
                            this.teleportTicks = 140 + this.field_70170_p.field_73012_v.nextInt(200);
                        }
                        if (this.turretStreak <= 0 && this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                            if (this.turretStreak == 0) {
                                EntityFortressBossTurret turret;
                                Vec3 dir;
                                ++this.turretStreakTicks;
                                int turretFrequency = MathHelper.func_76128_c((double)(15.0 - 0.04666666666666667 * (double)this.turretStreakTicks));
                                if (this.turretStreakTicks % turretFrequency == 0) {
                                    double angle = 0.041887902047863905 * (double)this.turretStreakTicks;
                                    for (int d = 0; d < 2; ++d) {
                                        dir = Vec3.func_72443_a((double)(Math.sin(angle) * (double)(d == 0 ? 1 : -1)), (double)0.0, (double)(Math.cos(angle) * (double)(d == 0 ? 1 : -1)));
                                        dir = dir.func_72432_b();
                                        dir.field_72450_a *= this.anchorRadius;
                                        dir.field_72448_b *= this.anchorRadius;
                                        dir.field_72449_c *= this.anchorRadius;
                                        turret = new EntityFortressBossTurret(this.field_70170_p, (Entity)this);
                                        turret.func_70012_b(this.anchorX + dir.field_72450_a, this.anchorY + dir.field_72448_b, this.anchorZ + dir.field_72449_c, 0.0f, 0.0f);
                                        turret.setAnchor(this.anchorX + dir.field_72450_a, this.anchorY + dir.field_72448_b, this.anchorZ + dir.field_72449_c);
                                        turret.setAttackDelay(turretFrequency);
                                        this.field_70170_p.func_72838_d((Entity)turret);
                                        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:fortressBossSummonProjectiles", 0.25f, 0.3f + 0.0023333333f * (float)this.turretStreakTicks);
                                    }
                                }
                                if (this.turretStreakTicks >= 300) {
                                    double angle = 0.19634954084936207;
                                    for (int i = 0; i < 32; ++i) {
                                        dir = Vec3.func_72443_a((double)Math.sin(angle * (double)i), (double)0.0, (double)Math.cos(angle * (double)i));
                                        dir = dir.func_72432_b();
                                        dir.field_72450_a *= this.anchorRadius;
                                        dir.field_72448_b *= this.anchorRadius;
                                        dir.field_72449_c *= this.anchorRadius;
                                        turret = new EntityFortressBossTurret(this.field_70170_p, (Entity)this);
                                        turret.func_70012_b(this.anchorX + dir.field_72450_a, this.anchorY + dir.field_72448_b, this.anchorZ + dir.field_72449_c, 0.0f, 0.0f);
                                        turret.setAnchor(this.anchorX + dir.field_72450_a, this.anchorY + dir.field_72448_b, this.anchorZ + dir.field_72449_c);
                                        turret.setAttackDelay(5 + i / 3);
                                        this.field_70170_p.func_72838_d((Entity)turret);
                                    }
                                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:fortressBossSummonProjectiles", 1.0f, 1.0f);
                                    this.turretStreakTicks = 0;
                                    this.turretStreak = -1;
                                }
                            }
                            if (this.turretStreak < 0) {
                                this.turretStreak = 250 + this.field_70170_p.field_73012_v.nextInt(200);
                                this.turretStreakTicks = 0;
                            }
                        } else if (this.turretTicks <= 0) {
                            if (this.turretTicks == 0) {
                                double angle = 0.6981317007977318;
                                for (int i = 0; i < 9; ++i) {
                                    if (this.field_70170_p.field_73012_v.nextInt(3) != 0) continue;
                                    Vec3 dir = Vec3.func_72443_a((double)Math.sin(angle * (double)i), (double)0.0, (double)Math.cos(angle * (double)i));
                                    dir = dir.func_72432_b();
                                    dir.field_72450_a *= 8.0;
                                    dir.field_72448_b *= 8.0;
                                    dir.field_72449_c *= 8.0;
                                    EntityFortressBossTurret turret = new EntityFortressBossTurret(this.field_70170_p, (Entity)this);
                                    turret.func_70012_b(this.anchorX + dir.field_72450_a, this.anchorY + dir.field_72448_b, this.anchorZ + dir.field_72449_c, 0.0f, 0.0f);
                                    turret.setAnchor(this.field_70165_t + dir.field_72450_a, this.field_70163_u + dir.field_72448_b, this.field_70161_v + dir.field_72449_c);
                                    turret.setDeflectable(this.field_70170_p.field_73012_v.nextInt(2) != 0);
                                    this.field_70170_p.func_72838_d((Entity)turret);
                                }
                                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:fortressBossSummonProjectiles", 1.0f, 1.0f);
                            }
                            this.turretTicks = 100 + this.field_70170_p.field_73012_v.nextInt(200);
                        } else {
                            --this.turretTicks;
                            if (this.turretStreak > 0) {
                                --this.turretStreak;
                            }
                        }
                    }
                    if (!this.isFloating() && this.field_70122_E) {
                        if (this.groundAttackTicks <= 0) {
                            if (this.groundAttackTicks == 0) {
                                double angle = 0.19634954084936207;
                                for (int i = 0; i < 32; ++i) {
                                    Vec3 dir = Vec3.func_72443_a((double)Math.sin(angle * (double)i), (double)0.0, (double)Math.cos(angle * (double)i));
                                    dir = dir.func_72432_b();
                                    float speed = 0.8f;
                                    EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, (Entity)this);
                                    bullet.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0f, 0.0f);
                                    bullet.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, speed, 0.0f);
                                    this.field_70170_p.func_72838_d((Entity)bullet);
                                }
                            }
                            this.groundAttackTicks = 40 + this.field_70170_p.field_73012_v.nextInt(80);
                            this.field_70180_af.func_75692_b(23, (Object)0);
                            this.turretStreak = -1;
                            this.turretTicks = -1;
                        } else {
                            --this.groundAttackTicks;
                            if (this.groundAttackTicks <= 20) {
                                this.field_70180_af.func_75692_b(23, (Object)1);
                            }
                        }
                    } else {
                        this.field_70180_af.func_75692_b(23, (Object)0);
                    }
                } else {
                    for (int i = 0; i <= 19; ++i) {
                        if (this.shieldAnimationTicks[i] == 0 && this.field_70170_p.field_73012_v.nextInt(50) == 0) {
                            this.shieldAnimationTicks[i] = 40;
                        }
                        if (this.shieldAnimationTicks[i] <= 0) continue;
                        int n = i;
                        this.shieldAnimationTicks[n] = this.shieldAnimationTicks[n] - 1;
                        if (this.shieldAnimationTicks[i] != 20) continue;
                        this.shieldAnimationTicks[i] = 0;
                    }
                    if (this.field_70180_af.func_75683_a(23) == 1) {
                        if (this.groundAttackTicks < 20) {
                            ++this.groundAttackTicks;
                        }
                    } else {
                        this.groundAttackTicks = 0;
                    }
                }
            }
        } else {
            this.setFloating(true);
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.isFloating()) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_70058_J()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
                }
                float groundFriction = 0.16277136f / (friction * friction * friction);
                this.func_70060_a(strafe, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
                friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)friction;
                this.field_70181_x *= (double)friction;
                this.field_70179_y *= (double)friction;
            }
            this.field_70722_aY = this.field_70721_aZ;
            double dx = this.field_70165_t - this.field_70169_q;
            double dz = this.field_70161_v - this.field_70166_s;
            float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
            if (distanceMoved > 1.0f) {
                distanceMoved = 1.0f;
            }
            this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.func_70637_d(false);
            super.func_70612_e(0.0f, 0.0f);
        }
    }

    protected void func_70609_aI() {
        if (this.deathTicks == 0 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72908_a(this.anchorX, this.anchorY, this.anchorZ, "thebetweenlands:fortressBossTeleport", 1.0f, 1.0f);
            this.func_70107_b(this.anchorX, this.anchorY, this.anchorZ);
            AxisAlignedBB checkAABB = this.field_70121_D.func_72314_b(16.0, 16.0, 16.0);
            List trackedEntities = this.field_70170_p.func_72872_a(EntityWight.class, this.field_70121_D.func_72314_b(this.anchorRadius * 2.0, 512.0, this.anchorRadius * 2.0));
            Iterator it = trackedEntities.iterator();
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                if (!(entity.func_70011_f(this.anchorX, entity.field_70163_u, this.anchorZ) > this.anchorRadius) && !(Math.abs(entity.field_70163_u - this.anchorY) > this.anchorRadius)) continue;
                it.remove();
            }
            for (Entity entity : trackedEntities) {
                if (!(entity instanceof EntityWight) && !(entity instanceof EntityFortressBossSpawner) && !(entity instanceof EntityFortressBossProjectile) && !(entity instanceof EntityFortressBossTurret) && !(entity instanceof EntityFortressBossBlockade)) continue;
                entity.func_70106_y();
            }
        }
        ++this.deathTicks;
        this.field_70180_af.func_75692_b(21, (Object)Float.valueOf((float)this.deathTicks / 3.0f * ((float)this.deathTicks / 3.0f)));
        for (int i = 0; i <= 19; ++i) {
            this.activeShields[i] = (float)i * 6.8421054f > (float)this.deathTicks;
        }
        this.field_70180_af.func_75692_b(20, (Object)this.packShieldData());
        if (!this.field_70170_p.field_72995_K) {
            int xp;
            if (this.deathTicks > 100 && this.deathTicks % 5 == 0) {
                int dropXP;
                for (xp = 800; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks > 130) {
                int dropXP;
                for (xp = 3000; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
                for (int c = 0; c < 4; ++c) {
                    double yawAngle = 1.0471975511965976;
                    for (int i = 0; i < 6; ++i) {
                        Vec3 dir = Vec3.func_72443_a((double)Math.sin(yawAngle * (double)i), (double)((double)(c - 2) / 4.0 * 2.0), (double)Math.cos(yawAngle * (double)i));
                        dir = dir.func_72432_b();
                        float speed = 0.8f;
                        EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, (Entity)this);
                        bullet.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0f, 0.0f);
                        bullet.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, speed, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)bullet);
                    }
                }
                this.func_145779_a(BLItemRegistry.ringOfRecruitment, 1);
                this.func_145779_a(BLItemRegistry.amuletSlot, 1);
                boolean hadArea = false;
                List<LocationStorage> locations = StorageHelper.getAreas(this.field_70170_p, AxisAlignedBB.func_72330_a((double)(this.anchorX - 60.0), (double)(this.anchorY - 100.0), (double)(this.anchorZ - 60.0), (double)(this.anchorX + 60.0), (double)(this.anchorY + 40.0), (double)(this.anchorZ + 60.0)));
                for (LocationStorage location : locations) {
                    if (!(location instanceof GuardedLocationStorage)) continue;
                    ((GuardedLocationStorage)location).setGuarded(false);
                    location.getChunkData().markDirty();
                    hadArea = true;
                }
                if (hadArea) {
                    AxisAlignedBB checkAABB = AxisAlignedBB.func_72330_a((double)(this.anchorX - 60.0), (double)(this.anchorY - 100.0), (double)(this.anchorZ - 60.0), (double)(this.anchorX + 60.0), (double)(this.anchorY + 40.0), (double)(this.anchorZ + 60.0));
                    List players = this.field_70170_p.func_72872_a(EntityPlayer.class, checkAABB);
                    for (EntityPlayer player : players) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.guard.drop", new Object[0]));
                    }
                }
                this.func_70106_y();
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:fortressBossLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:fortressBossHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:fortressBossDeath";
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public IChatComponent getBossName() {
        return this.func_145748_c_();
    }

    public void func_70642_aH() {
        if (!this.field_70170_p.field_72995_K) {
            String sound = this.func_70639_aQ();
            float volume = 1.0f;
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketPlayIdleSound(sound, (Entity)this, 1.0f, 1.0f)), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, volume > 1.0f ? (double)(16.0f * volume) : 16.0));
        } else {
            super.func_70642_aH();
        }
    }

    public void func_85030_a(String sound, float volume, float pitch) {
        if (sound != null && sound.equals(this.func_70673_aS())) {
            pitch = 1.0f;
            volume = 3.0f;
        }
        this.field_70170_p.func_72956_a((Entity)this, sound, volume, pitch);
    }

    @Override
    public String getMusicFile(EntityPlayer listener) {
        return "thebetweenlands:fortressBossLoop";
    }

    @Override
    public double getMusicRange(EntityPlayer listener) {
        return 20.0;
    }

    @Override
    public boolean isMusicActive(EntityPlayer listener) {
        return this.func_70089_S();
    }
}

