/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.entities.mobs.boss.fortress.EntityFortressBoss;
import thebetweenlands.entities.projectiles.EntityVolatileSoul;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class EntityWight
extends EntityMob
implements IEntityBL {
    public static final IAttribute VOLATILE_HEALTH_START_ATTRIB = new RangedAttribute("bl.volatileHealthStart", 1.0, 0.0, 1.0).func_111117_a("Volatile Health Percentage Start");
    public static final IAttribute VOLATILE_COOLDOWN_ATTRIB = new RangedAttribute("bl.volatileCooldown", 400.0, 10.0, 2.147483647E9).func_111117_a("Volatile Cooldown");
    public static final IAttribute VOLATILE_FLIGHT_SPEED_ATTRIB = new RangedAttribute("bl.volatileFlightSpeed", 0.25, 0.0, 5.0).func_111117_a("Volatile Flight Speed");
    public static final IAttribute VOLATILE_LENGTH_ATTRIB = new RangedAttribute("bl.volatileLength", 600.0, 0.0, 2.147483647E9).func_111117_a("Volatile Length");
    public static final IAttribute VOLATILE_MAX_DAMAGE_ATTRIB = new RangedAttribute("bl.volatileMaxDamage", 20.0, 0.0, Double.MAX_VALUE).func_111117_a("Volatile Max Damage");
    public static final int ATTACK_STATE_DW = 20;
    public static final int ANIMATION_STATE_DW = 21;
    public static final int VOLATILE_STATE_DW = 22;
    public static final int GUARD_STATE_DW = 23;
    public static final int REPAIR_X_DW = 24;
    public static final int REPAIR_Y_DW = 25;
    public static final int REPAIR_Z_DW = 26;
    private EntityAIAttackOnCollide meleeAttack = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 0.5, false);
    private EntityPlayer previousTarget;
    private boolean updateHasBeenSeen = false;
    private int volatileCooldown = (int)VOLATILE_COOLDOWN_ATTRIB.func_111110_b() / 2 + 20;
    private int volatileProgress = 0;
    private float volatileReceivedDamage = 0.0f;
    private double waypointX;
    private double waypointY;
    private double waypointZ;
    private boolean prevVolatile = false;
    private String locationViolatorUUID = null;
    private boolean breakBlock = false;
    private Block repairBlock = null;
    private int repairMeta = 0;
    private int repairX = 0;
    private int repairY = 0;
    private int repairZ = 0;
    private boolean canTurnVolatile = true;
    private boolean canTurnVolatileOnTarget = false;

    public EntityWight(World world) {
        super(world);
        this.func_70105_a(0.7f, 2.2f);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.meleeAttack);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(76.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(80.0);
        this.func_110140_aT().func_111150_b(VOLATILE_HEALTH_START_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_FLIGHT_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(VOLATILE_MAX_DAMAGE_ATTRIB);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("volatileState", this.func_70096_w().func_75683_a(22));
        nbt.func_74768_a("volatileCooldown", this.volatileCooldown);
        nbt.func_74768_a("volatileProgress", this.volatileProgress);
        nbt.func_74776_a("volatileReceivedDamage", this.volatileReceivedDamage);
        nbt.func_74757_a("isLocationGuard", this.isLocationGuard());
        if (this.locationViolatorUUID != null) {
            nbt.func_74778_a("locationViolatorUUID", this.locationViolatorUUID);
        }
        nbt.func_74757_a("isRepairGuard", this.isRepairGuard());
        nbt.func_74768_a("repairMeta", this.repairMeta);
        nbt.func_74768_a("repairX", this.repairX);
        nbt.func_74768_a("repairY", this.repairY);
        nbt.func_74768_a("repairZ", this.repairZ);
        nbt.func_74757_a("breakBlock", this.breakBlock);
        if (this.repairBlock != null) {
            nbt.func_74778_a("repairBlock", Block.field_149771_c.func_148750_c((Object)this.repairBlock));
        }
        nbt.func_74757_a("canTurnVolatile", this.canTurnVolatile);
        nbt.func_74757_a("canTurnVolatileOnTarget", this.canTurnVolatileOnTarget);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.func_70096_w().func_75692_b(22, (Object)nbt.func_74771_c("volatileState"));
        this.volatileCooldown = nbt.func_74762_e("volatileCooldown");
        this.volatileProgress = nbt.func_74762_e("volatileProgress");
        this.volatileReceivedDamage = nbt.func_74760_g("volatileReceivedDamage");
        if (nbt.func_74767_n("isLocationGuard")) {
            this.field_70180_af.func_75692_b(23, (Object)1);
        }
        if (this.isLocationGuard() && nbt.func_74764_b("locationViolatorUUID")) {
            this.locationViolatorUUID = nbt.func_74779_i("locationViolatorUUID");
        }
        if (nbt.func_74767_n("isRepairGuard")) {
            this.field_70180_af.func_75692_b(23, (Object)2);
        }
        if (this.isRepairGuard()) {
            this.repairMeta = nbt.func_74762_e("repairMeta");
            this.repairX = nbt.func_74762_e("repairX");
            this.repairY = nbt.func_74762_e("repairY");
            this.repairZ = nbt.func_74762_e("repairZ");
            this.breakBlock = nbt.func_74767_n("breakBlock");
            this.repairBlock = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("repairBlock"));
        }
        this.canTurnVolatile = nbt.func_74767_n("canTurnVolatile");
        this.canTurnVolatileOnTarget = nbt.func_74767_n("canTurnVolatileOnTarget");
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public int func_70641_bl() {
        return 3;
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:wightMoan";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:wightHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:wightDeath";
    }

    public boolean canPossess(EntityLivingBase entity) {
        return !this.isRepairGuard() && (this.isLocationGuard() || !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_82169_q(3) == null || ((EntityPlayer)entity).func_82169_q(3).func_77973_b() != BLItemRegistry.skullMask);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isLocationGuard() && (this.getViolator() == null || !this.getViolator().func_70089_S())) {
                this.func_70106_y();
            } else if (this.isLocationGuard() && this.getViolator() != null) {
                if (!LocationStorage.isLocationGuarded((Entity)this.getViolator())) {
                    this.func_70106_y();
                } else {
                    this.func_70624_b((EntityLivingBase)this.getViolator());
                }
            }
        }
        if (!this.isRepairGuard()) {
            EntityPlayer target;
            EntityPlayer entityPlayer = target = this.func_70638_az() instanceof EntityPlayer ? (EntityPlayer)this.func_70638_az() : null;
            if (target == null || target.field_70128_L || (double)target.func_70032_d((Entity)this) > this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) {
                target = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            }
            if (target != null && !target.func_70093_af()) {
                this.setTargetSpotted(target, true);
            }
            if (target != null && target != this.previousTarget && target.func_70093_af()) {
                this.setTargetSpotted(target, false);
            }
            if (target == null && this.previousTarget != null) {
                this.setTargetSpotted(target, false);
            }
            if (this.func_70638_az() instanceof EntityFortressBoss) {
                this.setTargetSpotted(null, false);
            }
            if (this.field_70154_o instanceof EntityFortressBoss) {
                this.func_110145_l(this.field_70154_o);
            }
            if (this.func_70638_az() != null) {
                if (this.getAnimation() > 0.0f) {
                    this.setAnimation(this.getAnimation() - 0.1f);
                }
            } else {
                if (this.getAnimation() < 1.0f) {
                    this.setAnimation(this.getAnimation() + 0.1f);
                }
                if (this.getAnimation() == 0.0f && this.previousTarget != null) {
                    this.previousTarget = null;
                }
            }
            if (this.func_70638_az() == null) {
                this.canTurnVolatileOnTarget = false;
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
                this.field_70180_af.func_75692_b(20, (Object)1);
                if (!this.isVolatile() && this.canPossess(this.func_70638_az()) && this.canTurnVolatile && this.canTurnVolatileOnTarget) {
                    if (this.volatileCooldown > 0) {
                        --this.volatileCooldown;
                    }
                    if ((double)this.func_110143_aJ() <= (double)this.func_110138_aP() * this.func_110148_a(VOLATILE_HEALTH_START_ATTRIB).func_111126_e() && this.volatileCooldown <= 0) {
                        this.setVolatile(true);
                        this.volatileCooldown = this.getVolatileCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getVolatileCooldown()) + 20;
                        this.volatileProgress = 0;
                    }
                } else if (this.isVolatile() && !this.canPossess(this.func_70638_az())) {
                    this.setVolatile(false);
                }
            }
            if (this.isVolatile()) {
                if (this.func_70638_az() != null) {
                    if (this.field_70154_o == null) {
                        double dy;
                        double dx = this.func_70638_az().field_70165_t - this.field_70165_t;
                        double dz = this.func_70638_az().field_70161_v - this.field_70161_v;
                        if (this.func_70638_az() instanceof EntityLivingBase) {
                            EntityLivingBase entitylivingbase = this.func_70638_az();
                            dy = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
                        } else {
                            dy = (this.func_70638_az().field_70121_D.field_72338_b + this.func_70638_az().field_70121_D.field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
                        }
                        double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        float pitch = (float)(-(Math.atan2(dy, dist) * 180.0 / Math.PI));
                        this.func_70101_b(yaw, pitch);
                        if (this.field_70170_p.field_72995_K) {
                            this.func_70034_d(yaw);
                        }
                    } else {
                        this.func_70101_b(this.field_70154_o.field_70177_z, 0.0f);
                        if (this.field_70170_p.field_72995_K) {
                            this.func_70034_d(this.field_70154_o.field_70177_z);
                        }
                    }
                }
                if (!this.field_70170_p.field_72995_K) {
                    List existingSouls;
                    if (this.field_70154_o != null && this.field_70154_o.field_70128_L) {
                        this.func_110145_l(this.field_70154_o);
                    }
                    if ((double)this.volatileProgress < this.func_110148_a(VOLATILE_LENGTH_ATTRIB).func_111126_e()) {
                        ++this.volatileProgress;
                    }
                    if (this.volatileProgress >= 20) {
                        if (this.func_70638_az() != null) {
                            this.waypointX = this.func_70638_az().field_70165_t;
                            this.waypointY = this.func_70638_az().field_70121_D.field_72338_b + (this.func_70638_az().field_70121_D.field_72337_e - this.func_70638_az().field_70121_D.field_72338_b) / 2.0;
                            this.waypointZ = this.func_70638_az().field_70161_v;
                        } else {
                            this.waypointX = this.field_70165_t;
                            this.waypointY = this.field_70163_u;
                            this.waypointZ = this.field_70161_v;
                        }
                    } else {
                        this.waypointX = this.field_70165_t;
                        this.waypointY = this.field_70163_u + 3.0;
                        this.waypointZ = this.field_70161_v;
                    }
                    if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 1.0f) {
                        this.onCollideWithEntity(this.func_70638_az());
                    }
                    if (this.field_70154_o != null && this.field_70173_aa % 30 == 0 && (existingSouls = this.field_70170_p.func_72872_a(EntityVolatileSoul.class, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0))).size() < 16) {
                        EntityVolatileSoul soul = new EntityVolatileSoul(this.field_70170_p);
                        float mx = this.field_70170_p.field_73012_v.nextFloat() - 0.5f;
                        float my = this.field_70170_p.field_73012_v.nextFloat() / 2.0f;
                        float mz = this.field_70170_p.field_73012_v.nextFloat() - 0.5f;
                        Vec3 dir = Vec3.func_72443_a((double)mx, (double)my, (double)mz).func_72432_b();
                        soul.setOwner(this.func_110124_au().toString());
                        soul.func_70012_b(this.field_70165_t + dir.field_72450_a * 0.5, this.field_70163_u + dir.field_72448_b * 1.5, this.field_70161_v + dir.field_72449_c * 0.5, 0.0f, 0.0f);
                        soul.func_70186_c((double)mx * 2.0, (double)my * 2.0, (double)mz * 2.0, 1.0f, 1.0f);
                        this.field_70170_p.func_72838_d((Entity)soul);
                    }
                } else if (this.field_70154_o == null || this.field_70173_aa % 4 == 0) {
                    this.spawnVolatileParticles();
                }
                this.func_70105_a(0.7f, 0.7f);
            } else {
                this.func_70105_a(0.7f, 2.2f);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
                this.field_70180_af.func_75692_b(20, (Object)0);
            }
            if (this.prevVolatile != this.isVolatile()) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 80; ++i) {
                        double px = this.field_70165_t + (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.7f);
                        double py = this.field_70163_u + (double)(this.field_70170_p.field_73012_v.nextFloat() * 2.2f);
                        double pz = this.field_70161_v + (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.7f);
                        Vec3 vec = Vec3.func_72443_a((double)px, (double)py, (double)pz).func_72444_a(Vec3.func_72443_a((double)(this.field_70165_t + (double)0.35f), (double)(this.field_70163_u + (double)1.1f), (double)(this.field_70161_v + (double)0.35f))).func_72432_b();
                        BLParticle.SWAMP_SMOKE.spawn(this.field_70170_p, px, py, pz, vec.field_72450_a * 0.25, vec.field_72448_b * 0.25, vec.field_72449_c * 0.25, 1.0f, new Object[0]);
                    }
                }
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:wightAttack", 1.6f, 1.0f);
            }
            this.prevVolatile = this.isVolatile();
        } else {
            this.func_70624_b(null);
            this.setVolatile(true);
            this.waypointX = (double)this.repairX + 0.5;
            this.waypointY = (double)this.repairY + 0.5;
            this.waypointZ = (double)this.repairZ + 0.5;
            if (this.func_70011_f((double)this.repairX + 0.5, (double)this.repairY + 0.5, (double)this.repairZ + 0.5) <= this.func_110148_a(VOLATILE_FLIGHT_SPEED_ATTRIB).func_111126_e() + 0.1) {
                if (this.breakBlock) {
                    this.field_70170_p.func_147449_b(this.repairX, this.repairY, this.repairZ, Blocks.field_150350_a);
                } else if (this.repairBlock != null) {
                    this.field_70170_p.func_147465_d(this.repairX, this.repairY, this.repairZ, this.repairBlock, this.repairMeta, 2);
                }
                this.func_70106_y();
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(24, (Object)this.repairX);
                this.field_70180_af.func_75692_b(25, (Object)this.repairY);
                this.field_70180_af.func_75692_b(26, (Object)this.repairZ);
            } else {
                int i;
                this.spawnVolatileParticles();
                this.repairX = this.field_70180_af.func_75679_c(24);
                this.repairY = this.field_70180_af.func_75679_c(25);
                this.repairZ = this.field_70180_af.func_75679_c(26);
                for (i = 0; i <= 2; ++i) {
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY, this.repairZ, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY, this.repairZ + 1, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY + 1, this.repairZ, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, (double)this.repairX + 0.5 * (double)i, this.repairY + 1, this.repairZ + 1, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                }
                for (i = 0; i <= 2; ++i) {
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, (double)this.repairY + 0.5 * (double)i, this.repairZ, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, (double)this.repairY + 0.5 * (double)i, this.repairZ + 1, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, (double)this.repairY + 0.5 * (double)i, this.repairZ, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, (double)this.repairY + 0.5 * (double)i, this.repairZ + 1, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                }
                for (i = 0; i <= 2; ++i) {
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, this.repairY, (double)this.repairZ + 0.5 * (double)i, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX, this.repairY + 1, (double)this.repairZ + 0.5 * (double)i, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, this.repairY, (double)this.repairZ + 0.5 * (double)i, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                    BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, this.repairX + 1, this.repairY + 1, (double)this.repairZ + 0.5 * (double)i, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                }
            }
            AxisAlignedBB repairBB = AxisAlignedBB.func_72330_a((double)this.repairX, (double)this.repairY, (double)this.repairZ, (double)(this.repairX + 1), (double)(this.repairY + 1), (double)(this.repairZ + 1));
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, repairBB);
            for (EntityLivingBase entity : entities) {
                if (entity == this || entity instanceof EntityWight) continue;
                if (entity.field_70165_t < (double)this.repairX + 0.5) {
                    entity.field_70159_w = -0.5;
                } else if (entity.field_70165_t > (double)this.repairX + 0.5) {
                    entity.field_70159_w = 0.5;
                }
                if (entity.field_70163_u < (double)this.repairY + 0.5) {
                    entity.field_70181_x = -0.5;
                } else if (entity.field_70163_u > (double)this.repairY + 0.5) {
                    entity.field_70181_x = 0.5;
                }
                if (entity.field_70161_v < (double)this.repairZ + 0.5) {
                    entity.field_70179_y = -0.5;
                } else if (entity.field_70161_v > (double)this.repairZ + 0.5) {
                    entity.field_70179_y = 0.5;
                }
                entity.func_70097_a(DamageSource.field_76376_m, 4.0f);
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.func_76396_c(), 160, 2));
                entity.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 160, 2));
            }
        }
        super.func_70071_h_();
    }

    public void onCollideWithEntity(EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K && this.isVolatile() && entity == this.func_70638_az() && entity.field_70153_n == null) {
            this.func_70078_a((Entity)entity);
            this.volatileProgress = 20;
        }
    }

    public void setLocationGuard(EntityPlayer violator) {
        this.field_70180_af.func_75692_b(23, (Object)1);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(999.0);
        this.func_70606_j(999.0f);
        this.locationViolatorUUID = violator.func_110124_au().toString();
    }

    public EntityPlayer getViolator() {
        if (this.locationViolatorUUID != null) {
            try {
                return this.field_70170_p.func_152378_a(UUID.fromString(this.locationViolatorUUID));
            }
            catch (Exception ex) {
                this.locationViolatorUUID = null;
            }
        }
        return null;
    }

    public boolean isLocationGuard() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setRepairGuard(Block block, int x, int y, int z, int meta) {
        this.field_70180_af.func_75692_b(23, (Object)2);
        this.breakBlock = false;
        this.repairBlock = block;
        this.repairX = x;
        this.repairY = y;
        this.repairZ = z;
        this.repairMeta = meta;
    }

    public void setRepairGuard(int x, int y, int z) {
        this.field_70180_af.func_75692_b(23, (Object)2);
        this.breakBlock = true;
        this.repairX = x;
        this.repairY = y;
        this.repairZ = z;
    }

    public boolean isRepairGuard() {
        return this.field_70180_af.func_75683_a(23) == 2;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVolatileParticles() {
        double radius = 0.3f;
        double cx = this.field_70165_t;
        double cy = this.field_70163_u + 0.35;
        double cz = this.field_70161_v;
        for (int i = 0; i < 8; ++i) {
            double px = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double py = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double pz = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            Vec3 vec = Vec3.func_72443_a((double)px, (double)py, (double)pz).func_72444_a(Vec3.func_72443_a((double)0.35f, (double)0.35f, (double)0.35f)).func_72432_b();
            px = cx + vec.field_72450_a * (double)0.3f;
            py = cy + vec.field_72448_b * (double)0.3f;
            pz = cz + vec.field_72449_c * (double)0.3f;
            BLParticle.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return !this.isVolatile() ? super.func_70053_R() : 0.0f;
    }

    protected void func_70069_a(float dst) {
        if (!this.isVolatile()) {
            super.func_70069_a(dst);
        }
    }

    protected void func_70064_a(double dst, boolean onGround) {
        if (!this.isVolatile()) {
            super.func_70064_a(dst, onGround);
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.isVolatile()) {
            if (this.func_70090_H()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_70058_J()) {
                this.func_70060_a(strafe, forward, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
                }
                float groundFriction = 0.16277136f / (friction * friction * friction);
                this.func_70060_a(strafe, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
                friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)friction;
                this.field_70181_x *= (double)friction;
                this.field_70179_y *= (double)friction;
            }
            this.field_70722_aY = this.field_70721_aZ;
            double dx = this.field_70165_t - this.field_70169_q;
            double dz = this.field_70161_v - this.field_70166_s;
            float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
            if (distanceMoved > 1.0f) {
                distanceMoved = 1.0f;
            }
            this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isVolatile()) {
            this.field_70145_X = true;
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            if ((double)this.volatileProgress >= this.func_110148_a(VOLATILE_LENGTH_ATTRIB).func_111126_e()) {
                this.field_70181_x -= 0.075;
                if (this.field_70122_E) {
                    this.setVolatile(false);
                }
            } else {
                double speed;
                double dx = this.waypointX - this.field_70165_t;
                double dy = this.waypointY - this.field_70163_u;
                double dz = this.waypointZ - this.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                if (dist <= (speed = this.func_110148_a(VOLATILE_FLIGHT_SPEED_ATTRIB).func_111126_e())) {
                    this.waypointX = this.field_70165_t;
                    this.waypointY = this.field_70163_u;
                    this.waypointZ = this.field_70161_v;
                } else {
                    this.field_70159_w = dx / dist * speed;
                    this.field_70181_x = dy / dist * speed;
                    this.field_70179_y = dz / dist * speed;
                }
            }
        } else {
            this.field_70145_X = false;
        }
    }

    private void setTargetSpotted(EntityPlayer target, boolean hasBeenSeen) {
        if (hasBeenSeen) {
            if (!this.updateHasBeenSeen) {
                this.updateHasBeenSeen = true;
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.meleeAttack);
                this.func_70624_b((EntityLivingBase)target);
                this.previousTarget = target;
            }
        } else if (this.updateHasBeenSeen) {
            this.updateHasBeenSeen = false;
            this.func_70624_b(null);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAttack);
        }
    }

    private void setAnimation(float progress) {
        this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(progress));
    }

    public float getAnimation() {
        return this.field_70180_af.func_111145_d(21);
    }

    public boolean func_85032_ar() {
        return this.field_70180_af.func_75683_a(20) == 0;
    }

    public boolean func_70104_M() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (!this.isLocationGuard() && !this.isRepairGuard()) {
            this.func_70099_a(new ItemStack(BLItemRegistry.wightsHeart), 0.0f);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isVolatile() && source == DamageSource.field_76368_d) {
            return false;
        }
        float prevHealth = this.func_110143_aJ();
        boolean ret = super.func_70097_a(source, damage);
        float dealtDamage = prevHealth - this.func_110143_aJ();
        if (this.isVolatile() && this.field_70154_o != null) {
            this.volatileReceivedDamage += dealtDamage;
            if ((double)this.volatileReceivedDamage >= this.func_110148_a(VOLATILE_MAX_DAMAGE_ATTRIB).func_111126_e()) {
                this.setVolatile(false);
            }
        }
        if (this.func_70638_az() != null && source instanceof EntityDamageSource && ((EntityDamageSource)source).func_76346_g() == this.func_70638_az()) {
            this.canTurnVolatileOnTarget = true;
        }
        return ret;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isVolatile()) {
            return false;
        }
        if (super.func_70652_k(entity)) {
            if (entity == this.func_70638_az()) {
                this.canTurnVolatileOnTarget = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public String pageName() {
        return "wight";
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public double func_70033_W() {
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            if (this.field_70154_o == TheBetweenlands.proxy.getClientPlayer()) {
                return -1.6;
            }
            return 0.05;
        }
        return this.field_70129_M;
    }

    public int getVolatileCooldown() {
        return (int)this.func_110148_a(VOLATILE_COOLDOWN_ATTRIB).func_111126_e();
    }

    public void setVolatile(boolean v) {
        if (!this.canTurnVolatile) {
            v = false;
        }
        this.field_70180_af.func_75692_b(22, (Object)((byte)(v ? 1 : 0)));
        this.volatileProgress = 0;
        this.volatileReceivedDamage = 0.0f;
        if (!v && this.field_70154_o != null) {
            this.func_110145_l(this.field_70154_o);
            this.field_70154_o = null;
        }
    }

    public boolean isVolatile() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setCanTurnVolatile(boolean canTurnVolatile) {
        this.canTurnVolatile = canTurnVolatile;
    }
}

