/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.utils.Mesh;

public class EntityTarminion
extends EntityTameable
implements IEntityBL {
    private boolean playOnce = true;
    private String ownerUUID = null;
    private int despawnTicks = 0;

    public EntityTarminion(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.3f, 0.5f);
        this.field_70155_l = 2.5;
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityMob.class, 0.5, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 0.7, 3.0f, 40.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true));
        this.field_70728_aV = 0;
    }

    public void setOwner(String ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.func_152115_b(this.ownerUUID);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.85);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.9);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_110164_bC() {
        return !this.func_70692_ba() && super.func_110164_bC();
    }

    protected String func_70673_aS() {
        return "thebetweenlands:squish";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_85030_a("thebetweenlands:tarBeastStep", 0.8f, 1.5f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            ++this.despawnTicks;
            if (this.despawnTicks > 7200) {
                this.func_70097_a(DamageSource.field_76377_j, this.func_110138_aP());
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
            this.renderParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z);
        }
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74768_a("despawnTicks", this.despawnTicks);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.despawnTicks = nbt.func_74762_e("despawnTicks");
    }

    public void func_70106_y() {
        Mesh.Triangle.Vertex.Vector3D vec;
        float rz;
        float ry;
        float rx;
        Object rnd;
        int i;
        if (this.func_70638_az() != null || this.func_70777_m() != null) {
            if (this.field_70170_p.field_72995_K) {
                for (i = 0; i < 200; ++i) {
                    rnd = this.field_70170_p.field_73012_v;
                    rx = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    ry = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    rz = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    vec = new Mesh.Triangle.Vertex.Vector3D(rx, ry, rz);
                    vec = vec.normalized();
                    BLParticle.SPLASH_TAR_BEAST.spawn(this.field_70170_p, this.field_70165_t + (double)rx + (double)0.1f, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + (double)0.1f, vec.x * (double)0.4f, vec.y * (double)0.4f, vec.z * (double)0.4f, 1.0f, new Object[0]);
                }
            } else {
                for (int i2 = 0; i2 < 8; ++i2) {
                    this.func_85030_a("thebetweenlands:tarBeastStep", 1.0f, (this.field_70146_Z.nextFloat() * 0.4f + 0.8f) * 0.8f);
                }
                List affectedEntities = this.field_70170_p.func_72872_a(EntityCreature.class, this.field_70121_D.func_72314_b(5.25, 5.25, 5.25));
                for (EntityCreature e : affectedEntities) {
                    if (e == this || e.func_70032_d((Entity)this) > 5.25f || !e.func_70685_l((Entity)this) || e instanceof EntityTarminion) continue;
                    double dst = e.func_70032_d((Entity)this);
                    e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 4.0f);
                    e.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), (int)(20.0 + (1.0 - dst / 5.25) * 150.0), 1, true));
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.INANIMATE_TARMINION), 0.0f);
        }
        if (this.playOnce) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thebetweenlands:tarBeastStep", 2.5f, 0.5f);
            this.playOnce = false;
            if (this.field_70170_p.field_72995_K) {
                for (i = 0; i < 100; ++i) {
                    rnd = this.field_70170_p.field_73012_v;
                    rx = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    ry = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    rz = ((Random)rnd).nextFloat() * 1.0f - 0.5f;
                    vec = new Mesh.Triangle.Vertex.Vector3D(rx, ry, rz);
                    vec = vec.normalized();
                    BLParticle.SPLASH_TAR_BEAST.spawn(this.field_70170_p, this.field_70165_t + (double)rx + (double)0.1f, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + (double)0.1f, vec.x * (double)0.2f, vec.y * (double)0.2f, vec.z * (double)0.2f, 1.0f, new Object[0]);
                }
            }
        }
        super.func_70106_y();
    }

    public boolean func_70652_k(Entity entity) {
        super.func_70652_k(entity);
        return this.attack(entity);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityCreature) {
            this.attack(source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean attack(Entity entity) {
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase owner;
            if (this.field_70122_E) {
                double dx = entity.field_70165_t - this.field_70165_t;
                double dz = entity.field_70161_v - this.field_70161_v;
                float dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                this.field_70159_w = dx / (double)dist * 0.2 + this.field_70159_w * 0.2;
                this.field_70179_y = dz / (double)dist * 0.2 + this.field_70179_y * 0.2;
                this.field_70181_x = 0.3;
            }
            Object damageSource = (owner = this.func_70902_q()) != null ? new EntityDamageSourceIndirect("mob", (Entity)this, (Entity)owner) : DamageSource.func_76358_a((EntityLivingBase)this);
            entity.func_70097_a(damageSource, (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            this.field_70170_p.func_72956_a(entity, "thebetweenlands:tarBeastStep", 1.0f, 2.0f);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, this.field_70170_p.field_73013_u.ordinal() * 50, 0));
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 3; ++count) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.0 + rand.nextDouble() * 0.1 - rand.nextDouble() * 0.1;
            double offSetZ = Math.cos(a) * 0.0 + rand.nextDouble() * 0.1 - rand.nextDouble() * 0.1;
            BLParticle.DRIP_TAR_BEAST.spawn(world, x + offSetX, y + 0.1, z + offSetZ);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        return null;
    }

    @Override
    public String pageName() {
        return "tarminion";
    }
}

