/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.BLMaterial;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.items.tools.ItemAxeBL;
import thebetweenlands.items.tools.ItemPickaxeBL;
import thebetweenlands.items.tools.ItemSpadeBL;
import thebetweenlands.items.tools.ItemSwordBL;
import thebetweenlands.utils.Mesh;

public class EntityTarBeast
extends EntityMob
implements IEntityBL {
    public static final IAttribute SHED_COOLDOWN_ATTRIB = new RangedAttribute("bl.shedCooldown", 70.0, 10.0, 2.147483647E9).func_111117_a("Shed Cooldown");
    public static final IAttribute SHED_SPEED_ATTRIB = new RangedAttribute("bl.shedSpeed", 10.0, 0.0, 2.147483647E9).func_111117_a("Shedding Speed");
    public static final IAttribute SUCK_COOLDOWN_ATTRIB = new RangedAttribute("bl.suckCooldown", 400.0, 0.0, 2.147483647E9).func_111117_a("Sucking Cooldown");
    public static final IAttribute SUCK_PREPARATION_SPEED_ATTRIB = new RangedAttribute("bl.suckPreparationSpeed", 40.0, 0.0, 2.147483647E9).func_111117_a("Sucking Preparation Speed");
    public static final IAttribute SUCK_LENGTH_ATTRIB = new RangedAttribute("bl.suckLength", 130.0, 0.0, 2.147483647E9).func_111117_a("Sucking Length");
    private int shedCooldown = (int)SHED_COOLDOWN_ATTRIB.func_111110_b();
    private int sheddingProgress = 0;
    public static final int SHEDDING_STATE_DW = 20;
    private int suckingCooldown = (int)SUCK_COOLDOWN_ATTRIB.func_111110_b();
    private int suckingPreparation = 0;
    private int suckingProgress = 0;
    public static final int SUCKING_STATE_DW = 21;

    public EntityTarBeast(World world) {
        super(world);
        this.func_70105_a(1.25f, 2.0f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SHED_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(SHED_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(SUCK_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(SUCK_PREPARATION_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(SUCK_LENGTH_ATTRIB);
    }

    public boolean func_70601_bi() {
        boolean isDifficultyValid;
        boolean bl = isDifficultyValid = this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
        if (isDifficultyValid) {
            int bz;
            int by;
            int bx = MathHelper.func_76128_c((double)this.field_70165_t);
            boolean isInTar = this.field_70170_p.func_147439_a(bx, by = MathHelper.func_76128_c((double)this.field_70163_u), bz = MathHelper.func_76128_c((double)this.field_70161_v)) == BLBlockRegistry.tarFluid && this.field_70170_p.func_147439_a(bx - 1, by, bz) == BLBlockRegistry.tarFluid && this.field_70170_p.func_147439_a(bx + 1, by, bz) == BLBlockRegistry.tarFluid && this.field_70170_p.func_147439_a(bx, by, bz - 1) == BLBlockRegistry.tarFluid && this.field_70170_p.func_147439_a(bx, by, bz + 1) == BLBlockRegistry.tarFluid;
            boolean canSpawn = this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && isInTar;
            return canSpawn;
        }
        return false;
    }

    public int func_70641_bl() {
        return 3;
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:tarBeastLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:tarBeastHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:tarBeastDeath";
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("shedCooldown", this.shedCooldown);
        nbt.func_74768_a("sheddingProgress", this.sheddingProgress);
        nbt.func_74774_a("sheddingState", this.func_70096_w().func_75683_a(20));
        nbt.func_74768_a("suckingCooldown", this.suckingCooldown);
        nbt.func_74768_a("suckingPreparation", this.suckingPreparation);
        nbt.func_74768_a("suckingProgress", this.suckingProgress);
        nbt.func_74774_a("suckingState", this.func_70096_w().func_75683_a(21));
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.shedCooldown = nbt.func_74762_e("shedCooldown");
        this.sheddingProgress = nbt.func_74762_e("sheddingProgress");
        this.func_70096_w().func_75692_b(20, (Object)nbt.func_74771_c("sheddingState"));
        this.suckingCooldown = nbt.func_74762_e("suckingCooldown");
        this.suckingPreparation = nbt.func_74762_e("suckingPreparation");
        this.suckingProgress = nbt.func_74762_e("suckingProgress");
        this.func_70096_w().func_75692_b(21, (Object)nbt.func_74771_c("suckingState"));
        super.func_70037_a(nbt);
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("thebetweenlands:tarBeastStep", 1.0f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.TAR_DRIP), 0.0f);
    }

    protected void func_70600_l(int looting) {
        this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.TAR_BEAST_HEART), 0.0f);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        EntityPlayer entityPlayer;
        ItemStack heldItem;
        if (source.func_76364_f() instanceof EntityPlayer && (heldItem = (entityPlayer = (EntityPlayer)source.func_76364_f()).func_71045_bC()) != null) {
            if (heldItem.func_77973_b() instanceof ItemSwordBL || heldItem.func_77973_b() instanceof ItemAxeBL || heldItem.func_77973_b() instanceof ItemPickaxeBL || heldItem.func_77973_b() instanceof ItemSpadeBL) {
                return super.func_70097_a(source, damage);
            }
            return super.func_70097_a(source, (float)MathHelper.func_76123_f((float)(damage * 0.5f)));
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70071_h_() {
        int i;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            Mesh.Triangle.Vertex.Vector3D vec;
            float rz;
            float ry;
            float rx;
            Random rnd;
            if (this.field_70173_aa % 10 == 0) {
                this.renderParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z);
            }
            if (this.sheddingProgress > this.getSheddingSpeed()) {
                this.sheddingProgress = 0;
                for (i = 0; i < 200; ++i) {
                    rnd = this.field_70170_p.field_73012_v;
                    rx = rnd.nextFloat() * 4.0f - 2.0f;
                    ry = rnd.nextFloat() * 4.0f - 2.0f;
                    rz = rnd.nextFloat() * 4.0f - 2.0f;
                    vec = new Mesh.Triangle.Vertex.Vector3D(rx, ry, rz);
                    vec = vec.normalized();
                    BLParticle.SPLASH_TAR_BEAST.spawn(this.field_70170_p, this.field_70165_t + (double)rx + 0.25, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + 0.25, vec.x * 0.5, vec.y * 0.5, vec.z * 0.5, 1.0f, new Object[0]);
                }
            } else {
                this.sheddingProgress = this.isShedding() || this.sheddingProgress > 0 ? ++this.sheddingProgress : 0;
            }
            if (this.isSucking()) {
                for (i = 0; i < 5; ++i) {
                    rnd = this.field_70170_p.field_73012_v;
                    rx = rnd.nextFloat() * 8.0f - 4.0f;
                    ry = rnd.nextFloat() * 8.0f - 4.0f;
                    rz = rnd.nextFloat() * 8.0f - 4.0f;
                    vec = new Mesh.Triangle.Vertex.Vector3D(rx, ry, rz);
                    vec = vec.normalized();
                    this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (double)rx + 0.25, this.field_70163_u + (double)ry, this.field_70161_v + (double)rz + 0.25, -vec.x * 0.5, -vec.y * 0.5, -vec.z * 0.5);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70138_W = this.func_70055_a(BLMaterial.tar) ? 2.0f : 0.75f;
            if (this.shedCooldown > 0 && this.func_70777_m() != null) {
                --this.shedCooldown;
            }
            if (!this.isSucking() && !this.isPreparing()) {
                if (this.shedCooldown == 0 && this.func_70777_m() != null && (double)this.func_70777_m().func_70032_d((Entity)this) < 6.0 && this.func_70685_l(this.func_70777_m())) {
                    this.setShedding(true);
                    this.shedCooldown = this.getSheddingCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getSheddingCooldown() / 2);
                }
                if (this.sheddingProgress > this.getSheddingSpeed()) {
                    this.func_85030_a("thebetweenlands:tarBeastLiving", 1.0f, (this.field_70146_Z.nextFloat() * 0.2f + 1.0f) * 0.6f);
                    for (i = 0; i < 8; ++i) {
                        this.func_85030_a("thebetweenlands:tarBeastStep", 1.0f, (this.field_70146_Z.nextFloat() * 0.4f + 0.8f) * 0.8f);
                    }
                    this.sheddingProgress = 0;
                    this.setShedding(false);
                    if (this.func_70777_m() != null) {
                        List affectedEntities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(6.0, 6.0, 6.0));
                        for (EntityLivingBase e : affectedEntities) {
                            if (e == this || e.func_70032_d((Entity)this) > 6.0f || !e.func_70685_l((Entity)this) || e instanceof EntityTarBeast || e instanceof EntityPlayer && ((EntityPlayer)e).func_70632_aY()) continue;
                            double dst = e.func_70032_d((Entity)this);
                            float dmg = (float)(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / dst * 7.0);
                            e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmg);
                            e.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), (int)(20.0 + (1.0 - dst / 6.0) * 150.0), 1, true));
                        }
                    }
                }
                this.sheddingProgress = this.isShedding() ? ++this.sheddingProgress : 0;
            }
            if (this.suckingCooldown > 0 && this.func_70777_m() != null) {
                --this.suckingCooldown;
            }
            if (!this.isShedding()) {
                if (this.suckingCooldown == 0 && this.func_70777_m() != null && (double)this.func_70777_m().func_70032_d((Entity)this) <= 10.0 && this.func_70685_l(this.func_70777_m())) {
                    this.setPreparing();
                }
                if (this.isPreparing()) {
                    ++this.suckingPreparation;
                    if ((double)this.suckingPreparation > this.func_110148_a(SUCK_PREPARATION_SPEED_ATTRIB).func_111126_e()) {
                        this.suckingPreparation = 0;
                        this.setSucking(true);
                        this.suckingCooldown = this.getSuckingCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getSuckingCooldown() / 2);
                        this.func_85030_a("thebetweenlands:tarBeastSuck", 1.0f, 1.0f);
                    }
                }
                if (this.suckingProgress > (int)this.func_110148_a(SUCK_LENGTH_ATTRIB).func_111126_e()) {
                    this.setSucking(false);
                    this.suckingProgress = 0;
                }
                if (this.isSucking()) {
                    ++this.suckingProgress;
                    List affectedEntities = this.field_70170_p.func_72872_a(Entity.class, this.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                    for (Entity e : affectedEntities) {
                        if (e == this || e.func_70032_d((Entity)this) > 10.0f || !this.func_70685_l(e) || e instanceof EntityTarBeast) continue;
                        Mesh.Triangle.Vertex.Vector3D vec = new Mesh.Triangle.Vertex.Vector3D(this.field_70165_t - e.field_70165_t, this.field_70163_u - e.field_70163_u, this.field_70161_v - e.field_70161_v);
                        vec = vec.normalized();
                        float dst = e.func_70032_d((Entity)this);
                        float mod = (float)Math.pow(1.0f - dst / 13.0f, 1.2);
                        if (e instanceof EntityPlayer && ((EntityPlayer)e).func_70632_aY()) {
                            mod *= 0.18f;
                        }
                        if (dst < 1.0f && e instanceof EntityLivingBase) {
                            ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 20, 3, true));
                            ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 20, 3, true));
                            e.field_70159_w *= (double)0.008f;
                            e.field_70181_x *= (double)0.008f;
                            e.field_70179_y *= (double)0.008f;
                            if (e instanceof EntityPlayer) {
                                ((EntityPlayer)e).field_70747_aH = 0.0f;
                            }
                            if (this.field_70173_aa % 12 == 0) {
                                e.func_70097_a(DamageSource.field_76369_e, 1.0f);
                            }
                        }
                        e.field_70159_w += vec.x * (double)0.18f * (double)mod;
                        e.field_70181_x += vec.y * (double)0.18f * (double)mod;
                        e.field_70179_y += vec.z * (double)0.18f * (double)mod;
                        e.field_70133_I = true;
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
                } else {
                    this.suckingProgress = 0;
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                }
            }
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.isSucking();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 3; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextInt(2) * 2 - 1;
            int motionZ = rand.nextInt(2) * 2 - 1;
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.5 + rand.nextDouble() * 0.3 - rand.nextDouble() * 0.3;
            double offSetZ = Math.cos(a) * 0.5 + rand.nextDouble() * 0.3 - rand.nextDouble() * 0.3;
            velY = ((double)rand.nextFloat() - 0.5) * 0.125;
            velZ = rand.nextFloat() * 0.5f * (float)motionZ;
            velX = rand.nextFloat() * 0.5f * (float)motionX;
            BLParticle.SPLASH_TAR_BEAST.spawn(world, x, y + rand.nextDouble() * 1.9, z, velX * 0.15, velY * 0.1, velZ * 0.15, 0.0f, new Object[0]);
            BLParticle.DRIP_TAR_BEAST.spawn(world, x + offSetX, y + 1.2, z + offSetZ);
        }
    }

    protected void func_82167_n(Entity e) {
        if (!this.isSucking()) {
            e.func_70108_f((Entity)this);
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && !this.isSucking();
    }

    public boolean isShedding() {
        return this.func_70096_w().func_75683_a(20) == 1;
    }

    public void setShedding(boolean shedding) {
        this.func_70096_w().func_75692_b(20, (Object)((byte)(shedding ? 1 : 0)));
    }

    public int getSheddingProgress() {
        return this.sheddingProgress;
    }

    public int getSheddingCooldown() {
        return (int)this.func_110148_a(SHED_COOLDOWN_ATTRIB).func_111126_e();
    }

    public int getSheddingSpeed() {
        return (int)this.func_110148_a(SHED_SPEED_ATTRIB).func_111126_e();
    }

    public int getSuckingCooldown() {
        return (int)this.func_110148_a(SUCK_COOLDOWN_ATTRIB).func_111126_e();
    }

    public boolean isSucking() {
        return this.func_70096_w().func_75683_a(21) == 1;
    }

    public boolean isPreparing() {
        return this.func_70096_w().func_75683_a(21) == 2;
    }

    public void setSucking(boolean sucking) {
        this.func_70096_w().func_75692_b(21, (Object)((byte)(sucking ? 1 : 0)));
    }

    public void setPreparing() {
        this.func_70096_w().func_75692_b(21, (Object)2);
    }

    @Override
    public String pageName() {
        return "tarBeast";
    }
}

