/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.entityAI.EntityAIBLBreakDoor;
import thebetweenlands.entities.entityAI.EntityAIHurtByTargetImproved;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.utils.AnimationMathHelper;

public class EntitySwampHag
extends EntityMob
implements IEntityBL {
    public float jawFloat;
    public float breatheFloat;
    AnimationMathHelper animationTalk = new AnimationMathHelper();
    AnimationMathHelper animationBreathe = new AnimationMathHelper();
    private int animationTick;
    private byte randomLivingSound;

    public EntitySwampHag(World world) {
        super(world);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBLBreakDoor((EntityLiving)this, BLBlockRegistry.doorWeedwood, 10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false));
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public int func_70641_bl() {
        return 3;
    }

    protected String func_70639_aQ() {
        int randomSound = this.field_70146_Z.nextInt(4) + 1;
        this.setTalkSound((byte)randomSound);
        return "thebetweenlands:swampHagLiving" + this.getTalkSound();
    }

    private void setTalkSound(int soundIndex) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)soundIndex));
    }

    private byte getTalkSound() {
        return this.field_70180_af.func_75683_a(19);
    }

    protected String func_70621_aR() {
        this.setTalkSound(4);
        this.setShouldJawMove(true);
        return "thebetweenlands:swampHagHurt";
    }

    protected String func_70673_aS() {
        this.setTalkSound(4);
        this.setShouldJawMove(true);
        return "thebetweenlands:swampHagDeath";
    }

    public void func_70636_d() {
        this.breatheFloat = this.animationBreathe.swing(0.2f, 0.5f, false);
        if (!this.field_70170_p.field_72995_K) {
            this.updateLivingSoundTime();
        }
        if (this.animationTick > 0) {
            --this.animationTick;
        }
        if (this.animationTick == 0) {
            this.setShouldJawMove(false);
            this.jawFloat = this.animationTalk.swing(0.0f, 0.0f, true);
        }
        if (this.getLivingSoundTime() == -this.func_70627_aG()) {
            this.setShouldJawMove(true);
        }
        if (!this.shouldJawMove()) {
            this.jawFloat = this.animationTalk.swing(0.0f, 0.0f, true);
        } else if (this.shouldJawMove() && this.getTalkSound() != 3 && this.getTalkSound() != 4) {
            this.jawFloat = this.animationTalk.swing(2.0f, 0.1f, false);
        } else if (this.shouldJawMove() && this.getTalkSound() == 3 || this.shouldJawMove() && this.getTalkSound() == 4) {
            this.jawFloat = this.animationTalk.swing(0.4f, 1.2f, false);
        }
        super.func_70636_d();
    }

    public void setShouldJawMove(boolean jawState) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(jawState ? 1 : 0)));
        if (jawState) {
            this.animationTick = 20;
        }
    }

    public boolean shouldJawMove() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    private void updateLivingSoundTime() {
        this.field_70180_af.func_75692_b(21, (Object)this.field_70757_a);
    }

    private int getLivingSoundTime() {
        return this.field_70180_af.func_75679_c(21);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.SLIMY_BONE, this.field_70170_p.field_73012_v.nextInt(3) + 1), 0.0f);
    }

    @Override
    public String pageName() {
        return "swampHag";
    }
}

