/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.entities.mobs.EntityDreadfulMummy;
import thebetweenlands.entities.mobs.EntityPeatMummy;

public class EntitySludgeBall
extends EntityThrowable {
    private int bounces = 0;
    private String ownerUUID;

    public EntitySludgeBall(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.75f);
        this.ownerUUID = "";
    }

    public EntitySludgeBall(World world, EntityLivingBase owner) {
        this(world);
        this.ownerUUID = owner.func_110124_au().toString();
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.ownerUUID);
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID uuid) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70165_t = this.field_70142_S;
        this.field_70163_u = this.field_70137_T;
        this.field_70161_v = this.field_70136_U;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        double prevMotionX = this.field_70159_w;
        double prevMotionY = this.field_70181_x;
        double prevMotionZ = this.field_70179_y;
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K && prevX == this.field_70165_t && prevY == this.field_70163_u && prevZ == this.field_70161_v) {
            this.explode();
        }
        this.field_70159_w = prevMotionX;
        this.field_70181_x = prevMotionY;
        this.field_70179_y = prevMotionZ;
    }

    protected void func_70184_a(MovingObjectPosition collision) {
        MovingObjectPosition intercept;
        AxisAlignedBB collisionBox;
        Block block;
        if (collision.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.field_70170_p.func_147439_a(collision.field_72311_b, collision.field_72312_c, collision.field_72309_d)).func_149678_a(this.field_70170_p.func_72805_g(collision.field_72311_b, collision.field_72312_c, collision.field_72309_d), false) && (collisionBox = block.func_149668_a(this.field_70170_p, collision.field_72311_b, collision.field_72312_c, collision.field_72309_d)) != null && (intercept = collisionBox.func_72327_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y)))) != null) {
            if (collision.field_72310_e == 1 || collision.field_72310_e == 0) {
                this.field_70181_x *= -0.9;
                this.field_70133_I = true;
                ++this.bounces;
                if (this.bounces >= 3) {
                    if (this.field_70170_p.field_72995_K) {
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70159_w = 0.0;
                    }
                    this.explode();
                } else {
                    this.func_85030_a("mob.slime.big", 1.0f, 0.9f);
                    this.spawnBounceParticles(8);
                }
            } else if (collision.field_72310_e == 2 || collision.field_72310_e == 3) {
                this.field_70179_y *= -0.9;
                this.field_70133_I = true;
                ++this.bounces;
                if (this.bounces >= 3) {
                    if (this.field_70170_p.field_72995_K) {
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70159_w = 0.0;
                    }
                    this.explode();
                }
            } else if (collision.field_72310_e == 4 || collision.field_72310_e == 5) {
                this.field_70159_w *= -0.9;
                this.field_70133_I = true;
                ++this.bounces;
                if (this.bounces >= 3) {
                    if (this.field_70170_p.field_72995_K) {
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70159_w = 0.0;
                    }
                    this.explode();
                }
            }
        }
        if (collision.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && !(collision.field_72308_g instanceof EntityPeatMummy) && !(collision.field_72308_g instanceof EntityDreadfulMummy)) {
            this.explode();
        }
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            float radius = 3.0f;
            AxisAlignedBB region = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - (double)radius), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + (double)radius), (double)(this.field_70161_v + (double)radius));
            List entities = this.field_70170_p.func_72839_b((Entity)this, region);
            double radiusSq = radius * radius;
            for (Entity entity : entities) {
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPeatMummy || entity instanceof EntityDreadfulMummy || !(this.func_70068_e(entity) < radiusSq)) continue;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 80, 3, false));
                Entity owner = this.getOwner();
                if (owner != null) {
                    entity.func_70097_a((DamageSource)new EntityDamageSourceIndirect("mob", (Entity)this, owner), 8.0f);
                    continue;
                }
                entity.func_70097_a((DamageSource)new EntityDamageSource("entity", (Entity)this), 8.0f);
            }
            this.func_85030_a("mob.slime.big", 1.0f, 0.5f);
            this.func_85030_a("mob.slime.small", 1.0f, 0.5f);
            this.func_85030_a("mob.slime.small", 1.0f, 1.0f);
            this.func_85030_a("mob.slime.big", 1.0f, 1.0f);
            this.func_70106_y();
        } else {
            this.spawnBounceParticles(20);
        }
    }

    protected float func_70185_h() {
        return 0.08f;
    }

    private void spawnBounceParticles(int amount) {
        for (int i = 0; i <= amount; ++i) {
            this.field_70170_p.func_72869_a("slime", this.field_70165_t + (double)(amount / 8) * ((double)this.field_70146_Z.nextFloat() - 0.5), this.field_70163_u + 0.3, this.field_70161_v + (double)(amount / 8) * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("bounces", this.bounces);
        nbt.func_74778_a("ownerUUID", this.ownerUUID);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.bounces = nbt.func_74762_e("bounces");
        this.ownerUUID = nbt.func_74779_i("ownerUUID");
    }
}

