/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.model.ControlledAnimation;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.misc.ItemGeneric;

public class EntitySludge
extends EntityMob
implements IEntityBL {
    private int sludgeJumpDelay;
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    public ControlledAnimation scale = new ControlledAnimation(5);

    public EntitySludge(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70178_ae = true;
        this.func_70105_a(1.1f, 1.2f);
        this.sludgeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.SLUDGE_BALL, 3 + looting), 0.0f);
        }
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if ((this.getIsPlayerNearby(7.0, 3.0, 7.0, 7.0) || this.func_70638_az() != null || this.field_70170_p.field_73012_v.nextInt(1900) == 0) && !this.getActive()) {
                this.setActive(true);
                this.field_70181_x += 0.6;
            }
            if (this.getActive()) {
                if (this.field_70122_E && !flag) {
                    this.squishAmount = -0.5f;
                    this.func_85030_a("mob.slime.big", 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                } else if (!this.field_70122_E && flag) {
                    this.squishAmount = 1.0f;
                }
                this.alterSquishAmount();
                int bx = MathHelper.func_76128_c((double)this.field_70165_t);
                int by = MathHelper.func_76128_c((double)this.field_70163_u);
                int bz = MathHelper.func_76128_c((double)this.field_70161_v);
                if (this.field_70170_p.func_147439_a(bx, by, bz) == Blocks.field_150350_a && BLBlockRegistry.sludge.func_149742_c(this.field_70170_p, bx, by, bz)) {
                    BLBlockRegistry.sludge.generateBlockTemporary(this.field_70170_p, bx, by, bz);
                }
                if (this.func_70638_az() == null && this.field_70170_p.field_73012_v.nextInt(350) == 0) {
                    this.setActive(false);
                }
            } else {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.getActive()) {
                this.scale.increaseTimer();
            } else {
                this.scale.decreaseTimer();
            }
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.8f;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || !this.getActive();
    }

    protected void func_70626_be() {
        EntityPlayer newTarget;
        super.func_70626_be();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70638_az() == null && (newTarget = this.field_70170_p.func_72856_b((Entity)this, 8.0)) != null) {
            this.func_70624_b((EntityLivingBase)newTarget);
        }
        if ((this.field_70122_E || this.func_70090_H()) && this.sludgeJumpDelay-- <= 0) {
            this.sludgeJumpDelay = this.getJumpDelay();
            if (this.func_70638_az() != null) {
                this.sludgeJumpDelay = (int)((float)this.sludgeJumpDelay / 3.0f);
            }
            this.field_70703_bu = true;
            float f = this.field_70702_br = this.func_70638_az() == null ? 1.0f - this.field_70146_Z.nextFloat() * 2.0f : (1.0f - this.field_70146_Z.nextFloat() * 2.0f) / 10.0f;
            if (this.func_70638_az() != null) {
                this.func_70060_a(0.0f, 0.65f, 1.0f);
            } else {
                this.field_70701_bs = 1.0f;
            }
            this.func_85030_a("mob.slime.big", 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
        if (this.field_70146_Z.nextFloat() < 0.8f && this.func_70090_H()) {
            this.field_70703_bu = true;
        }
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        if (!player.field_71075_bZ.field_75098_d && !this.field_70170_p.field_72995_K && this.func_70635_at().func_75522_a((Entity)player) && this.getActive() && player.field_70121_D.field_72337_e >= this.field_70121_D.field_72338_b && player.field_70121_D.field_72338_b <= this.field_70121_D.field_72337_e) {
            player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
            player.field_70159_w = 0.0;
            player.field_70181_x = 0.0;
            player.field_70179_y = 0.0;
        }
    }

    public int func_70641_bl() {
        return 2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)((byte)(this.field_70170_p.field_73012_v.nextInt(5) == 0 ? 1 : 0)));
    }

    public boolean func_70104_M() {
        return false;
    }

    public void setActive(boolean active) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(active ? 1 : 0)));
    }

    public boolean getActive() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public boolean getIsPlayerNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(distanceX, distanceY, distanceZ));
        ArrayList listEntityPlayers = new ArrayList();
        for (Entity entityNeighbor : list) {
            if (!(entityNeighbor instanceof EntityPlayer) || !((double)this.func_70032_d(entityNeighbor) <= radius) || ((EntityPlayer)entityNeighbor).field_71075_bZ.field_75102_a || this.field_70170_p.field_72995_K || !this.func_70635_at().func_75522_a(entityNeighbor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String pageName() {
        return "sludge";
    }
}

