/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;

public class EntitySiltCrab
extends EntityMob
implements IEntityBL {
    private EntityAIAttackOnCollide meleeAttack = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 0.7, false);
    private EntityAIAvoidEntity runAway = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 10.0f, 0.7, 0.7);
    private EntityAINearestAttackableTarget target = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true);
    private int aggroCooldown = 200;
    private boolean canAttack = false;

    public EntitySiltCrab(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.6f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.meleeAttack);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.runAway);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.target);
        this.field_70138_W = 2.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70601_bi() {
        boolean canSpawn = super.func_70601_bi() && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)) == BLBlockRegistry.silt;
        return canSpawn;
    }

    public int func_70641_bl() {
        return 5;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_70099_a(ItemGeneric.createStack(BLItemRegistry.siltCrabClaw, 2, 0), 0.0f);
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 2.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.aggroCooldown == 200 && !this.canAttack) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.runAway);
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.meleeAttack);
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.target);
                this.canAttack = true;
            }
            if (this.aggroCooldown == 0 && this.canAttack) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAttack);
                this.field_70715_bh.func_85156_a((EntityAIBase)this.target);
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.runAway);
                this.canAttack = false;
            }
            if (this.aggroCooldown < 201) {
                ++this.aggroCooldown;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.func_70032_d((Entity)player) <= 1.5f && this.canAttack) {
            this.aggroCooldown = 0;
        }
    }

    @Override
    public String pageName() {
        return "siltCrab";
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

