/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.IScreenShake;
import thebetweenlands.entities.entityAI.EntityAIApproachItem;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.BLItemRegistry;

public class EntityPeatMummy
extends EntityMob
implements IEntityBL,
IScreenShake {
    public static final IAttribute SPAWN_LENGTH_ATTRIB = new RangedAttribute("bl.spawnLength", 100.0, 0.0, 2.147483647E9).func_111117_a("Spawning Length");
    public static final IAttribute SPAWN_OFFSET_ATTRIB = new RangedAttribute("bl.spawnOffset", 2.0, -2.147483647E9, 2.147483647E9).func_111117_a("Spawning Y Offset");
    public static final IAttribute SPAWN_RANGE_ATTRIB = new RangedAttribute("bl.spawnRange", 8.0, 0.0, Double.MAX_VALUE).func_111117_a("Spawning Range");
    public static final IAttribute CHARGING_COOLDOWN_ATTRIB = new RangedAttribute("bl.chargingCooldown", 160.0, 0.0, 2.147483647E9).func_111117_a("Charging Cooldown");
    public static final IAttribute CHARGING_PREPARATION_SPEED_ATTRIB = new RangedAttribute("bl.chargingPreparationSpeed", 60.0, 0.0, 2.147483647E9).func_111117_a("Charging Preparation Speed");
    public static final IAttribute CHARGING_TIME_ATTRIB = new RangedAttribute("bl.chargingTime", 320.0, 0.0, 2.147483647E9).func_111117_a("Charging Time");
    public static final IAttribute CHARGING_SPEED_ATTRIB = new RangedAttribute("bl.chargingSpeed", 0.55, 0.0, Double.MAX_VALUE).func_111117_a("Charging Movement Speed");
    public static final IAttribute CHARGING_DAMAGE_MULTIPLIER_ATTRIB = new RangedAttribute("bl.chargingDamageMultiplier", 2.0, 0.0, Double.MAX_VALUE).func_111117_a("Charging Damage Multiplier");
    private static final int BREAK_COUNT = 5;
    public static final float BASE_SPEED = 0.2f;
    public static final float BASE_DAMAGE = 8.0f;
    private float prevYOffset;
    public static final int SPAWNING_STATE_DW = 20;
    private int chargingCooldown = (int)CHARGING_COOLDOWN_ATTRIB.func_111110_b();
    private int chargingPreparation;
    private int chargingTime;
    public static final int CHARGING_STATE_DW = 21;
    private int prevScreamTimer;
    private int screamTimer;
    private boolean screaming = false;
    private boolean wasScreaming = false;
    private static final int SCREAMING_TIMER_MAX = 50;
    private boolean carryShimmerstone = false;
    private static final List<Block> SPAWN_BLOCKS = new ArrayList<Block>();

    public EntityPeatMummy(World world) {
        super(world);
        this.func_70105_a(1.2f, 1.2f);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIApproachItem((EntityCreature)this, BLItemRegistry.shimmerStone, 80, 64.0f, (double)1.9f, 1.5){

            @Override
            protected double getNearSpeed() {
                if (EntityPeatMummy.this.isCharging()) {
                    return 1.0;
                }
                return super.getNearSpeed();
            }

            @Override
            protected double getFarSpeed() {
                if (EntityPeatMummy.this.isCharging()) {
                    return 1.0;
                }
                return super.getFarSpeed();
            }

            @Override
            protected void onPickup() {
                EntityPeatMummy entity = EntityPeatMummy.this;
                if (entity.isCharging()) {
                    entity.stopCharging();
                }
                entity.carryShimmerstone = true;
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(110.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SPAWN_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(SPAWN_OFFSET_ATTRIB);
        this.func_110140_aT().func_111150_b(SPAWN_RANGE_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_COOLDOWN_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_PREPARATION_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_TIME_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_SPEED_ATTRIB);
        this.func_110140_aT().func_111150_b(CHARGING_DAMAGE_MULTIPLIER_ATTRIB);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("mudSpawningState", this.getSpawningState());
        nbt.func_74780_a("initialPosY", this.field_70163_u);
        nbt.func_74776_a("previousYOffset", this.prevYOffset);
        nbt.func_74768_a("chargingCooldown", this.chargingCooldown);
        nbt.func_74768_a("chargingPreparation", this.chargingPreparation);
        nbt.func_74768_a("chargingTime", this.chargingTime);
        nbt.func_74774_a("chargingState", this.field_70180_af.func_75683_a(21));
        nbt.func_74757_a("carryShimmerstone", this.carryShimmerstone);
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.field_70180_af.func_75692_b(20, (Object)nbt.func_74762_e("mudSpawningState"));
        this.field_70163_u = nbt.func_74769_h("initialPosY");
        this.field_70129_M = nbt.func_74760_g("previousYOffset");
        this.chargingCooldown = nbt.func_74762_e("chargingCooldown");
        this.chargingPreparation = nbt.func_74762_e("chargingPreparation");
        this.chargingTime = nbt.func_74762_e("chargingTime");
        this.field_70180_af.func_75692_b(21, (Object)nbt.func_74771_c("chargingState"));
        this.carryShimmerstone = nbt.func_74767_n("carryShimmerstone");
        super.func_70037_a(nbt);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.getSpawningProgress() != 1.0f && this.getSpawningProgress() != 0.0f) {
                this.field_70129_M = this.getCurrentOffset();
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.getSpawningState() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.22, this.field_70161_v);
                }
                int breakPoint = this.getSpawningLength() / 5;
                if ((this.getSpawningState() - breakPoint / 2 - 1) % breakPoint == 0) {
                    int x = MathHelper.func_76128_c((double)this.field_70165_t);
                    int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)this.field_70129_M));
                    int z = MathHelper.func_76128_c((double)this.field_70161_v);
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    int metadata = this.field_70170_p.func_72805_g(x, y, z);
                    String particle = "blockdust_" + Block.func_149682_b((Block)block) + "_" + metadata;
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u - (double)this.field_70129_M + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, block.field_149762_H.func_150495_a(), this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f, false);
                    int amount = this.field_70146_Z.nextInt(20) + 15;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.field_70170_p.func_72869_a(particle, px + ox, py, pz + oz, motionX, motionY, motionZ);
                    }
                }
            } else {
                this.field_70129_M = 0.0f;
            }
        } else {
            this.prevYOffset = this.field_70129_M;
            this.updateTarget();
            if (this.shouldUpdateState()) {
                if (this.getSpawningState() == 0) {
                    this.func_85030_a("thebetweenlands:peatMummyEmerge", 1.2f, 1.0f);
                }
                this.updateSpawningState();
            } else if (this.getSpawningProgress() != 0.0f) {
                this.setSpawningFinished();
            }
            if (this.isInValidSpawnPad() && this.getSpawningProgress() != 1.0f) {
                this.field_70129_M = this.getCurrentOffset();
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70133_I = true;
                if (this.func_70777_m() != null) {
                    this.func_70625_a(this.func_70777_m(), 360.0f, 360.0f);
                }
                if (this.getSpawningState() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.22, this.field_70161_v);
                }
            } else {
                this.setSpawningFinished();
                this.field_70129_M = 0.0f;
            }
        }
        if (this.getSpawningProgress() != 1.0f) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isPreparing() && !this.wasScreaming && !this.screaming) {
                this.screaming = true;
                this.wasScreaming = true;
            } else if (!this.isPreparing()) {
                this.wasScreaming = false;
            }
            this.prevScreamTimer = this.screamTimer++;
            if (!this.screaming && this.screamTimer > 0) {
                this.screamTimer = 0;
            }
            if (this.screamTimer >= 50) {
                this.screaming = false;
            }
        } else {
            if (!this.isPreparing() && !this.isCharging()) {
                if (this.chargingCooldown > 0 && this.func_70777_m() != null) {
                    --this.chargingCooldown;
                }
                if (this.chargingCooldown == 0) {
                    this.chargingCooldown = this.getChargingCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getChargingCooldown() / 2);
                    this.func_85030_a("thebetweenlands:peatMummyCharge", 1.75f, (this.field_70146_Z.nextFloat() * 0.4f + 0.8f) * 0.8f);
                    this.setChargingState(1);
                }
            } else if (this.isPreparing()) {
                ++this.chargingPreparation;
                if (this.getPreparationProgress() == 1.0f) {
                    this.chargingPreparation = 0;
                    this.setChargingState(2);
                }
            } else if (this.isCharging()) {
                ++this.chargingTime;
                if ((double)this.chargingTime >= this.func_110148_a(CHARGING_TIME_ATTRIB).func_111126_e()) {
                    this.chargingTime = 0;
                    this.setChargingState(0);
                }
            }
            if (this.isCharging()) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0 * this.func_110148_a(CHARGING_DAMAGE_MULTIPLIER_ATTRIB).func_111126_e());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110148_a(CHARGING_SPEED_ATTRIB).func_111126_e());
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
            }
        }
    }

    public boolean shouldUpdateState() {
        return this.func_70777_m() != null;
    }

    public boolean isInValidSpawnPad() {
        double initialPosY = this.field_70163_u - (double)this.field_70129_M;
        int ebx = MathHelper.func_76128_c((double)this.field_70165_t);
        int eby = MathHelper.func_76128_c((double)initialPosY);
        int ebz = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.inMud(ebx, eby, ebz);
    }

    private boolean inMud(int ebx, int eby, int ebz) {
        for (int y = -MathHelper.func_76143_f((double)this.getSpawnOffset()); y < 0; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Block cb = this.field_70170_p.func_147439_a(ebx + x, eby + y, ebz + z);
                    if (y != -1 ? cb.func_149662_c() || SPAWN_BLOCKS.contains(cb) : SPAWN_BLOCKS.contains(cb)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void updateTarget() {
        EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, this.getSpawningProgress() == 1.0f ? this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() : this.getSpawningRange());
        if (player != null && this.func_70777_m() == null) {
            double prevPosY = this.field_70163_u;
            this.field_70163_u -= (double)this.field_70129_M;
            if (player.func_70685_l((Entity)this)) {
                this.func_70784_b((Entity)player);
            }
            this.field_70163_u = prevPosY;
        } else if (this.func_70777_m() != null && player == null) {
            this.func_70784_b(null);
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.getSpawningProgress() == 1.0f) {
            super.func_70100_b_(player);
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.getSpawningProgress() == 1.0f && this.getChargingState() == 0;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.getSpawningProgress() != 1.0f || this.getChargingState() == 1;
    }

    public int func_70641_bl() {
        return 2;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.isInValidSpawnPad();
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isCharging()) {
            this.stopCharging();
        }
        if (this.getSpawningProgress() < 1.0f) {
            return false;
        }
        return super.func_70652_k(entity);
    }

    public void func_70642_aH() {
        if (this.getSpawningProgress() == 1.0f) {
            super.func_70642_aH();
        }
    }

    public void stopCharging() {
        this.setChargingState(0);
        this.chargingCooldown = this.getChargingCooldown() + this.field_70170_p.field_73012_v.nextInt(this.getChargingCooldown() / 2);
        this.chargingPreparation = 0;
        this.chargingTime = 0;
    }

    public float getCurrentOffset() {
        return (float)(-this.getSpawnOffset() + (double)this.getSpawningProgress() * this.getSpawnOffset());
    }

    public double getSpawnOffset() {
        return this.func_110148_a(SPAWN_OFFSET_ATTRIB).func_111126_e();
    }

    public int getSpawningState() {
        return this.field_70180_af.func_75679_c(20);
    }

    public int getSpawningLength() {
        return (int)this.func_110148_a(SPAWN_LENGTH_ATTRIB).func_111126_e();
    }

    public double getSpawningRange() {
        return this.func_110148_a(SPAWN_RANGE_ATTRIB).func_111126_e();
    }

    public float getSpawningProgress() {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * (float)this.getSpawningState();
    }

    public float getSpawningProgress(float delta) {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * ((float)this.getSpawningState() + (this.getSpawningState() == this.getSpawningLength() ? 0.0f : delta));
    }

    public void updateSpawningState() {
        int spawningState = this.getSpawningState();
        if (spawningState < this.getSpawningLength()) {
            this.field_70180_af.func_75692_b(20, (Object)(spawningState + 1));
        }
    }

    public void resetSpawningState() {
        this.field_70180_af.func_75692_b(20, (Object)0);
    }

    public void setSpawningFinished() {
        if (this.getSpawningProgress() == 1.0f) {
            return;
        }
        this.field_70180_af.func_75692_b(20, (Object)this.getSpawningLength());
    }

    public int getChargingCooldown() {
        return (int)this.func_110148_a(CHARGING_COOLDOWN_ATTRIB).func_111126_e();
    }

    public void setChargingState(int state) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)state));
    }

    public byte getChargingState() {
        return this.field_70180_af.func_75683_a(21);
    }

    public boolean isPreparing() {
        return this.getChargingState() == 1;
    }

    public boolean isCharging() {
        return this.getChargingState() == 2;
    }

    public float getPreparationProgress() {
        return 1.0f / (float)((int)this.func_110148_a(CHARGING_PREPARATION_SPEED_ATTRIB).func_111126_e()) * (float)this.chargingPreparation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isScreaming() {
        return this.screaming;
    }

    @SideOnly(value=Side.CLIENT)
    public float getScreamingProgress(float delta) {
        return 0.02f * ((float)this.prevScreamTimer + (float)(this.screamTimer - this.prevScreamTimer) * delta);
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:peatMummyLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:peatMummyHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:peatMummyDeath";
    }

    protected void func_70628_a(boolean killedByPlayer, int looting) {
        if (this.carryShimmerstone) {
            if (this.field_70170_p.field_73012_v.nextInt(8) != 0) {
                this.func_145779_a(BLItemRegistry.shimmerStone, 1);
            }
        } else if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
            this.func_145779_a(BLItemRegistry.shimmerStone, 1);
            if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                this.func_145779_a(BLItemRegistry.shimmerStone, this.field_70170_p.field_73012_v.nextInt(5) + 1);
            }
        }
    }

    @Override
    public String pageName() {
        return "peatMummy";
    }

    public void setCarryShimmerStone(boolean shimmerStone) {
        this.carryShimmerstone = shimmerStone;
    }

    @Override
    public float getShakeIntensity(EntityLivingBase viewer, float partialTicks) {
        if (this.isScreaming()) {
            double dist = this.func_70032_d((Entity)viewer);
            float screamMult = (float)(1.0 - dist / 30.0);
            if (dist >= 30.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.getScreamingProgress(partialTicks) * Math.PI) + (double)0.1f) * (double)0.15f * (double)screamMult);
        }
        return 0.0f;
    }

    static {
        SPAWN_BLOCKS.add(BLBlockRegistry.mud);
        SPAWN_BLOCKS.add(BLBlockRegistry.peat);
    }
}

