/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.items.BLItemRegistry;

public class EntityMummyArm
extends EntityCreature
implements IEntityBL {
    public static final int OWNER_DW = 18;
    public int attackSwing = 0;
    private int spawnTicks = 0;
    private int despawnTicks = 0;
    private int deathTicks = 0;

    public EntityMummyArm(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.7f);
    }

    @Override
    public String pageName() {
        return "mummyArm";
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)"");
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.field_70177_z = this.field_70170_p.field_73012_v.nextFloat() * 360.0f;
        return data;
    }

    public void setOwner(String ownerUUID) {
        this.field_70180_af.func_75692_b(18, (Object)ownerUUID);
    }

    public String getOwnerUUID() {
        return this.field_70180_af.func_75681_e(18);
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerUUID());
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID uuid) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public void func_70071_h_() {
        int z;
        int y;
        int x;
        Block block;
        Entity owner;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            int bz;
            int by;
            int bx = MathHelper.func_76128_c((double)this.field_70165_t);
            Block blockBelow = this.field_70170_p.func_147439_a(bx, by = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5)), bz = MathHelper.func_76128_c((double)this.field_70161_v));
            if (blockBelow == Blocks.field_150350_a || !this.field_70170_p.func_147439_a(bx, by, bz).isSideSolid((IBlockAccess)this.field_70170_p, bx, by, bz, ForgeDirection.UP)) {
                this.func_70106_y();
            }
            if ((owner = this.getOwner()) == null || (double)owner.func_70032_d((Entity)this) > 32.0) {
                this.func_70606_j(0.0f);
            } else if (owner instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)owner;
                if (!this.isUsingRing(player)) {
                    this.func_70606_j(0.0f);
                }
            } else {
                this.func_70606_j(0.0f);
            }
            if (this.despawnTicks >= 150) {
                this.func_70606_j(0.0f);
            } else if (this.spawnTicks >= 40) {
                ++this.despawnTicks;
            }
        }
        if (this.deathTicks > 0) {
            this.field_70129_M = (float)(-this.deathTicks) / 40.0f;
        } else if (this.spawnTicks >= 40) {
            this.field_70129_M = 0.0f;
        }
        if (this.func_70089_S()) {
            if (this.spawnTicks >= 4) {
                List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D);
                for (EntityLivingBase target : targets) {
                    if (target == this || target == this.getOwner() || !(target instanceof EntityMob)) continue;
                    owner = this.getOwner();
                    Object damageSource = owner != null ? new EntityDamageSourceIndirect("mob", (Entity)this, owner) : DamageSource.func_76358_a((EntityLivingBase)this);
                    target.func_70097_a(damageSource, 3.0f);
                    if (this.attackSwing > 0) continue;
                    this.attackSwing = 20;
                }
            }
            if (this.spawnTicks < 40) {
                ++this.spawnTicks;
                this.field_70129_M = -1.0f + (float)this.spawnTicks / 40.0f;
            } else {
                this.field_70129_M = 0.0f;
            }
            if (this.attackSwing > 0) {
                --this.attackSwing;
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(this.field_70129_M < 0.0f ? 2 : 8) == 0 && (block = this.field_70170_p.func_147439_a(x = MathHelper.func_76128_c((double)this.field_70165_t), y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5)), z = MathHelper.func_76128_c((double)this.field_70161_v))) != Blocks.field_150350_a) {
            int metadata = this.field_70170_p.func_72805_g(x, y, z);
            String particle = "blockdust_" + Block.func_149682_b((Block)block) + "_" + metadata;
            double px = this.field_70165_t;
            double py = this.field_70163_u;
            double pz = this.field_70161_v;
            int amount = 2 + this.field_70146_Z.nextInt(this.field_70129_M < 0.0f ? 8 : 3);
            for (int i = 0; i < amount; ++i) {
                double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                double motionY = this.field_70146_Z.nextDouble() * 0.1 + 0.1;
                double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                this.field_70170_p.func_72869_a(particle, px + ox, py, pz + oz, motionX, motionY, motionZ);
            }
        }
    }

    private boolean isUsingRing(EntityPlayer player) {
        EquipmentInventory inventory = EquipmentInventory.getEquipmentInventory((Entity)player);
        List<Equipment> rings = inventory.getEquipment(EnumEquipmentCategory.RING);
        for (Equipment equipment : rings) {
            if (equipment.item.func_77973_b() != BLItemRegistry.ringOfSummoning || equipment.item.func_77960_j() >= equipment.item.func_77958_k()) continue;
            return true;
        }
        return false;
    }

    public void func_70612_e(float strafe, float forward) {
    }

    public void func_70108_f(Entity entity) {
    }

    protected void func_82167_n(Entity entity) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (!this.field_70170_p.field_72995_K && this.deathTicks >= 40) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("ownerUUID", this.getOwnerUUID());
        nbt.func_74768_a("spawnTicks", this.spawnTicks);
        nbt.func_74768_a("despawnTicks", this.despawnTicks);
        nbt.func_74768_a("deathTicks", this.deathTicks);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setOwner(nbt.func_74779_i("ownerUUID"));
        this.spawnTicks = nbt.func_74762_e("spawnTicks");
        this.despawnTicks = nbt.func_74762_e("despawnTicks");
        this.deathTicks = nbt.func_74762_e("deathTicks");
    }
}

