/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.EntityAngler;
import thebetweenlands.entities.mobs.EntityDragonFly;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.utils.MathUtils;

public class EntityLurker
extends EntityMob
implements IEntityBL {
    private static final int MOUTH_OPEN_TICKS = 20;
    private ChunkCoordinates currentSwimTarget;
    private Class<?>[] prey = new Class[]{EntityAngler.class, EntityDragonFly.class};
    private float prevRotationPitchBody;
    private float rotationPitchBody;
    private float prevTailYaw;
    private float tailYaw;
    private float prevTailPitch;
    private float tailPitch;
    private float prevMouthOpenTicks;
    private float mouthOpenTicks;
    private int ticksUntilBiteDamage = -1;
    private Entity entityBeingBit;
    private int anger;
    private boolean prevInWater;
    private int leapRiseTime;
    private int leapFallTime;

    public EntityLurker(World world) {
        super(world);
        this.func_70105_a(1.9f, 0.9f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 0.5, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)Float.valueOf(1.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(55.0);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.getRelativeBlock(0) == BLBlockRegistry.swampWater;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this);
    }

    private Block getRelativeBlock(int offsetY) {
        return this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) + offsetY, MathHelper.func_76128_c((double)this.field_70161_v));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            if (!this.field_70170_p.field_72995_K) {
                Entity entityToAttack = this.func_70777_m();
                if (entityToAttack == null) {
                    this.swimAbout();
                } else {
                    this.currentSwimTarget = new ChunkCoordinates(MathHelper.func_76128_c((double)entityToAttack.field_70165_t), MathHelper.func_76128_c((double)entityToAttack.field_70163_u), MathHelper.func_76128_c((double)entityToAttack.field_70161_v));
                    this.swimToTarget();
                }
                if (this.field_70181_x < 0.0 && this.isLeaping()) {
                    this.setIsLeaping(false);
                }
            }
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
        } else if (this.field_70170_p.field_72995_K) {
            if (this.prevInWater && this.isLeaping()) {
                this.breachWater();
            }
        } else if (this.field_70122_E) {
            this.setIsLeaping(false);
        } else {
            this.field_70159_w *= 0.4;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.4;
        }
        if (this.isLeaping()) {
            ++this.leapRiseTime;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70177_z += 10.0f;
            }
        } else {
            if (this.leapRiseTime > 0 && this.leapFallTime == this.leapRiseTime) {
                this.leapRiseTime = 0;
                this.leapFallTime = 0;
            }
            if (this.leapFallTime < this.leapRiseTime) {
                ++this.leapFallTime;
            }
        }
        float magnitude = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * (float)(!this.field_70122_E ? 1 : 0);
        float motionPitch = (float)Math.atan2(magnitude, this.field_70181_x) / (float)Math.PI * 180.0f - 90.0f;
        if (magnitude > 1.0f) {
            magnitude = 1.0f;
        }
        float newRotationPitch = this.isLeaping() ? 90.0f : (this.leapFallTime > 0 ? -45.0f : (this.rotationPitchBody - motionPitch) * magnitude * 4.0f * (float)(this.field_70171_ac ? 1 : 0));
        this.tailPitch += (this.rotationPitchBody - newRotationPitch) * 0.75f;
        this.rotationPitchBody += (newRotationPitch - this.rotationPitchBody) * 0.3f;
        if (Math.abs(this.rotationPitchBody) < 0.05f) {
            this.rotationPitchBody = 0.0f;
        }
    }

    private void breachWater() {
        int ring = 2;
        int waterColorMultiplier = this.getWaterColor();
        while (ring-- > 0) {
            int particleCount = ring * 12 + 20 + this.field_70146_Z.nextInt(10);
            for (int p = 0; p < particleCount; ++p) {
                float theta = (float)p / (float)particleCount * ((float)Math.PI * 2);
                float dx = MathHelper.func_76134_b((float)theta);
                float dz = MathHelper.func_76126_a((float)theta);
                double x = this.field_70165_t + (double)(dx * (float)ring * 1.0f) * MathUtils.linearTransformd(this.field_70146_Z.nextDouble(), 0.0, 1.0, 0.6, 1.2) + this.field_70146_Z.nextDouble() * 0.3 - 0.15;
                double y = this.field_70163_u - this.field_70146_Z.nextDouble() * 0.2;
                double z = this.field_70161_v + (double)(dz * (float)ring * 1.0f) * MathUtils.linearTransformd(this.field_70146_Z.nextDouble(), 0.0, 1.0, 0.6, 1.2) + this.field_70146_Z.nextDouble() * 0.3 - 0.15;
                double motionX = dx * MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, 0.03f, 0.2f);
                double motionY = (double)((float)ring * 0.3f) + this.field_70146_Z.nextDouble() * 0.1;
                double motionZ = dz * MathUtils.linearTransformf(this.field_70146_Z.nextFloat(), 0.0f, 1.0f, 0.03f, 0.2f);
                BLParticle.SPLASH.spawn(this.field_70170_p, x, y, z, motionX, motionY, motionZ, 1.0f, waterColorMultiplier);
            }
        }
    }

    private int getWaterColor() {
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
        int y = 0;
        while (this.getRelativeBlock(y--) == Blocks.field_150350_a && this.field_70163_u - (double)y > 0.0) {
        }
        int blockY = MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b + (double)y));
        Block block = this.field_70170_p.func_147439_a(blockX, blockY, blockZ);
        if (block.func_149688_o().func_76224_d()) {
            int r = 255;
            int g = 255;
            int b = 255;
            if (block == BLBlockRegistry.swampWater) {
                r = 147;
                g = 132;
                b = 83;
            } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                r = 49;
                g = 70;
                b = 245;
            } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                r = 207;
                g = 85;
                b = 16;
            }
            int multiplier = block.func_149720_d((IBlockAccess)this.field_70170_p, blockX, blockY, blockZ);
            return 0xFF000000 | r * (multiplier >> 16 & 0xFF) / 255 << 16 | g * (multiplier >> 8 & 0xFF) / 255 << 8 | b * (multiplier & 0xFF) / 255;
        }
        return -1;
    }

    public void func_70071_h_() {
        float movementSpeed;
        this.prevRotationPitchBody = this.rotationPitchBody;
        this.prevTailPitch = this.tailPitch;
        this.prevTailYaw = this.tailYaw;
        while (this.rotationPitchBody - this.prevRotationPitchBody < -180.0f) {
            this.prevRotationPitchBody -= 360.0f;
        }
        while (this.rotationPitchBody - this.prevRotationPitchBody >= 180.0f) {
            this.prevRotationPitchBody += 360.0f;
        }
        while (this.tailPitch - this.prevTailPitch < -180.0f) {
            this.prevTailPitch -= 360.0f;
        }
        while (this.tailPitch - this.prevTailPitch >= 180.0f) {
            this.prevTailPitch += 360.0f;
        }
        while (this.tailYaw - this.prevTailYaw < -180.0f) {
            this.prevTailYaw -= 360.0f;
        }
        while (this.tailYaw - this.prevTailYaw >= 180.0f) {
            this.prevTailYaw += 360.0f;
        }
        this.prevMouthOpenTicks = this.mouthOpenTicks;
        this.prevInWater = this.field_70171_ac;
        super.func_70071_h_();
        if (this.shouldMouthBeOpen()) {
            if (this.mouthOpenTicks < 20.0f) {
                this.mouthOpenTicks += this.getMouthMoveSpeed();
            }
            if (this.mouthOpenTicks > 20.0f) {
                this.mouthOpenTicks = 20.0f;
            }
        } else {
            if (this.mouthOpenTicks > 0.0f) {
                this.mouthOpenTicks -= this.getMouthMoveSpeed();
            }
            if (this.mouthOpenTicks < 0.0f) {
                this.mouthOpenTicks = 0.0f;
            }
        }
        if (this.ticksUntilBiteDamage > -1) {
            --this.ticksUntilBiteDamage;
            if (this.ticksUntilBiteDamage == -1) {
                this.setShouldMouthBeOpen(false);
                if (this.entityBeingBit != null) {
                    if (!this.entityBeingBit.field_70128_L) {
                        super.func_70652_k(this.entityBeingBit);
                        if (this.field_70153_n == this.entityBeingBit) {
                            this.field_70153_n.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), ((EntityLivingBase)this.entityBeingBit).func_110138_aP());
                        }
                    }
                    this.entityBeingBit = null;
                }
            }
        }
        if ((movementSpeed = MathHelper.func_76133_a((double)((this.field_70169_q - this.field_70165_t) * (this.field_70169_q - this.field_70165_t) + (this.field_70167_r - this.field_70163_u) * (this.field_70167_r - this.field_70163_u) + (this.field_70166_s - this.field_70161_v) * (this.field_70166_s - this.field_70161_v)))) > 1.0f) {
            movementSpeed = 1.0f;
        } else if ((double)movementSpeed < 0.08) {
            movementSpeed = 0.0f;
        }
        if (Math.abs(this.tailYaw) < 90.0f) {
            this.tailYaw += this.field_70760_ar - this.field_70761_aq;
        }
        if (Math.abs(this.tailPitch) < 90.0f) {
            this.tailPitch += this.prevRotationPitchBody - this.rotationPitchBody;
        }
        this.tailPitch *= 0.5f;
        this.tailYaw *= 1.0f - movementSpeed;
    }

    protected void func_70626_be() {
        super.func_70626_be();
        if (this.field_70789_a == null) {
            if (this.entityBeingBit == null) {
                this.field_70789_a = this.findEnemyToAttack();
            }
        } else if (this.field_70789_a.func_70068_e((Entity)this) > 256.0) {
            this.field_70789_a = null;
        }
        if (this.anger > 0) {
            --this.anger;
            if (this.anger == 0) {
                this.field_70789_a = null;
            }
        }
    }

    protected Entity func_70782_k() {
        return this.anger == 0 ? null : super.func_70782_k();
    }

    public void swimAbout() {
        if (this.currentSwimTarget != null && (this.field_70170_p.func_147439_a(this.currentSwimTarget.field_71574_a, this.currentSwimTarget.field_71572_b, this.currentSwimTarget.field_71573_c).func_149688_o() != Material.field_151586_h || this.currentSwimTarget.field_71572_b < 1)) {
            this.currentSwimTarget = null;
        }
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.currentSwimTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentSwimTarget.func_71569_e(x, y, z) < 4.0f) {
            this.currentSwimTarget = new ChunkCoordinates(x + this.field_70146_Z.nextInt(10) - this.field_70146_Z.nextInt(10), y - this.field_70146_Z.nextInt(4) + 1, z + this.field_70146_Z.nextInt(10) - this.field_70146_Z.nextInt(10));
        }
        this.swimToTarget();
    }

    private void swimToTarget() {
        if (this.field_70153_n != null) {
            return;
        }
        double targetX = (double)this.currentSwimTarget.field_71574_a + 0.5 - this.field_70165_t;
        double targetY = (double)this.currentSwimTarget.field_71572_b - this.field_70163_u;
        double targetZ = (double)this.currentSwimTarget.field_71573_c + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(targetX) * 0.2 - this.field_70159_w) * 0.2;
        this.field_70181_x += (Math.signum(targetY) * 0.4 - this.field_70181_x) * 0.01;
        this.field_70181_x -= 0.01;
        this.field_70179_y += (Math.signum(targetZ) * 0.2 - this.field_70179_y) * 0.2;
        this.field_70701_bs = 0.5f;
    }

    private Entity findEnemyToAttack() {
        List nearEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(8.0, 10.0, 8.0));
        for (int i = 0; i < nearEntities.size(); ++i) {
            Entity entity = (Entity)nearEntities.get(i);
            for (int n = 0; n < this.prey.length; ++n) {
                if (entity.getClass() != this.prey[n]) continue;
                return entity;
            }
        }
        return null;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    protected void func_70785_a(Entity entity, float distance) {
        if (this.entityBeingBit != null || this.field_70153_n != null || entity.field_70154_o != null) {
            return;
        }
        if (this.field_70171_ac && entity instanceof EntityDragonFly && !this.isLeaping() && distance < 5.0f) {
            this.setIsLeaping(true);
            double distanceX = entity.field_70165_t - this.field_70165_t;
            double distanceZ = entity.field_70161_v - this.field_70161_v;
            float magnitude = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            this.field_70159_w += distanceX / (double)magnitude * 0.8;
            this.field_70181_x += 0.9;
            this.field_70179_y += distanceZ / (double)magnitude * 0.8;
        }
        if (this.field_70724_aR <= 0 && distance < 3.0f && entity.field_70121_D.field_72337_e >= this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b <= this.field_70121_D.field_72337_e && this.ticksUntilBiteDamage == -1) {
            this.setShouldMouthBeOpen(true);
            this.setMouthMoveSpeed(10.0f);
            this.ticksUntilBiteDamage = 10;
            this.field_70724_aR = 20;
            this.entityBeingBit = entity;
            if (this.isLeaping() && entity instanceof EntityDragonFly) {
                entity.func_70078_a((Entity)this);
                this.field_70789_a = null;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar() || source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        Entity attacker = source.func_76346_g();
        if (attacker instanceof EntityPlayer) {
            List nearLurkers = this.field_70170_p.func_72872_a(EntityLurker.class, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
            for (EntityLurker fellowLurker : nearLurkers) {
                fellowLurker.showDeadlyAffectionTowards(attacker);
            }
        }
        return super.func_70097_a(source, damage);
    }

    private void showDeadlyAffectionTowards(Entity entity) {
        this.field_70789_a = entity;
        this.anger = 200 + this.field_70146_Z.nextInt(100);
    }

    public boolean isLeaping() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public void setIsLeaping(boolean isLeaping) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(isLeaping ? 1 : 0)));
    }

    public boolean shouldMouthBeOpen() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    public void setShouldMouthBeOpen(boolean shouldMouthBeOpen) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)(shouldMouthBeOpen ? 1 : 0)));
    }

    public float getMouthMoveSpeed() {
        return this.field_70180_af.func_111145_d(22);
    }

    public void setMouthMoveSpeed(float mouthMoveSpeed) {
        this.field_70180_af.func_75692_b(22, (Object)Float.valueOf(mouthMoveSpeed));
    }

    public float getRotationPitch(float partialRenderTicks) {
        return this.rotationPitchBody * partialRenderTicks + this.prevRotationPitchBody * (1.0f - partialRenderTicks);
    }

    public float getMouthOpen(float partialRenderTicks) {
        return (this.mouthOpenTicks * partialRenderTicks + this.prevMouthOpenTicks * (1.0f - partialRenderTicks)) / 20.0f;
    }

    public float getTailYaw(float partialRenderTicks) {
        return this.tailYaw * partialRenderTicks + this.prevTailYaw * (1.0f - partialRenderTicks);
    }

    public float getTailPitch(float partialRenderTicks) {
        return this.tailPitch * partialRenderTicks + this.prevTailPitch * (1.0f - partialRenderTicks);
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:lurkerLiving";
    }

    protected String func_70621_aR() {
        this.setShouldMouthBeOpen(true);
        this.ticksUntilBiteDamage = 10;
        return "thebetweenlands:lurkerHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:lurkerDeath";
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_70099_a(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.LURKER_SKIN, 3), 0.0f);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74777_a("Anger", (short)this.anger);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.anger = tagCompound.func_74765_d("Anger");
    }

    @Override
    public String pageName() {
        return "lurker";
    }
}

