/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.entities.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.entityAI.EntityAIBLAvoidEntity;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.entities.mobs.IEntityBL;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.utils.AnimationMathHelper;

public class EntityLeech
extends EntityMob
implements IEntityBL {
    private static final int MAX_BLOOD_LEVEL = 5;
    private static final int TIME_TO_FLEE = 600;
    private EntityLivingBase target;
    public int attackCountDown = 20;
    public int hungerCoolDown;
    private int drainage;
    public float moveProgress;
    public boolean firstTickCheck;
    AnimationMathHelper mathSucking = new AnimationMathHelper();
    private final EntityAINearestAttackableTarget aiAttackTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true);
    private final EntityAIWander aiWander = new EntityAIWander((EntityCreature)this, 0.5);
    private final EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 0.5, false);
    private final EntityAIBLAvoidEntity avoidHarmer = new EntityAIBLAvoidEntity((EntityCreature)this, EntityPlayer.class, 6.0f, 0.5, 0.6);

    public EntityLeech(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.3f);
        this.field_70138_W = 0.0f;
        this.moveProgress = 0.0f;
        this.firstTickCheck = false;
        this.drainage = 0;
        this.setBloodConsumed(0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.aiAttackTarget);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected String func_70639_aQ() {
        return "thebetweenlands:snailLiving";
    }

    protected String func_70621_aR() {
        return "thebetweenlands:snailHurt";
    }

    protected String func_70673_aS() {
        return "thebetweenlands:snailDeath";
    }

    public void onCollideWithEntity(EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K && entity.field_70153_n == null && this.getBloodConsumed() <= 0) {
            this.func_70078_a((Entity)entity);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackTarget);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70788_c == 0 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 2.0f) {
                this.onCollideWithEntity(this.func_70638_az());
            }
            if (this.field_70154_o != null) {
                this.func_70101_b(this.field_70154_o.field_70177_z, this.field_70154_o.field_70125_A);
                if (this.field_70154_o.func_70027_ad() && this.field_70154_o instanceof EntityLivingBase) {
                    PotionEffect stomachContents = new PotionEffect(Potion.field_76436_u.field_76415_H, 120 + this.getBloodConsumed() * 200 / 5, 0);
                    ((EntityLivingBase)this.field_70154_o).func_70690_d(stomachContents);
                    this.setBloodConsumed(0);
                    this.func_110145_l(this.field_70154_o);
                    this.flee();
                    this.field_70154_o = null;
                }
            }
            if (this.getBloodConsumed() == 5 && this.field_70154_o != null) {
                this.func_110145_l(this.field_70154_o);
                this.field_70154_o = null;
            }
            if (this.field_70788_c > 0) {
                --this.field_70788_c;
                if (this.field_70788_c == 0) {
                    this.stopFleeing();
                }
            }
        }
        if (!this.firstTickCheck) {
            this.func_70078_a(null);
            this.field_70154_o = null;
            this.firstTickCheck = true;
        }
        if (--this.hungerCoolDown == 0 && this.getBloodConsumed() > 0) {
            this.setBloodConsumed(this.getBloodConsumed() - 1);
        }
        if (this.field_70154_o != null) {
            this.moveProgress = 1.0f + this.mathSucking.swing(1.0f, 0.15f, false);
            if (this.field_70146_Z.nextInt(10) == 0) {
                for (int i = 0; i < 8; ++i) {
                    this.field_70170_p.func_72869_a("reddust", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0);
                }
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.moveProgress = 0.0f + this.mathSucking.swing(1.0f, 0.15f, false);
        }
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityLivingBase && this.getBloodConsumed() < 5) {
            ++this.drainage;
            if (this.drainage >= this.attackCountDown && this.field_70725_aQ == 0) {
                this.field_70154_o.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.drainage = 0;
                this.setBloodConsumed(this.getBloodConsumed() + 1);
            }
        }
        super.func_70071_h_();
    }

    private void flee() {
        this.field_70788_c = 600;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.avoidHarmer);
        this.avoidHarmer.setTargetEntityClass(this.field_70154_o.getClass());
        this.field_70715_bh.func_85156_a((EntityAIBase)this.aiAttackTarget);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
    }

    private void stopFleeing() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.avoidHarmer);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.aiAttackTarget);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttackOnCollide);
    }

    public double func_70033_W() {
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityPlayer && this.field_70154_o == TheBetweenlands.proxy.getClientPlayer()) {
            return -2.0;
        }
        return this.field_70129_M;
    }

    public boolean func_70686_a(Class entity) {
        return entity != EntityLeech.class && (entity == EntityPlayer.class || entity == EntityPlayerMP.class || entity == EntitySwampHag.class);
    }

    public int getBloodConsumed() {
        return this.field_70180_af.func_75683_a(15);
    }

    public void setBloodConsumed(int amount) {
        this.hungerCoolDown = 500;
        this.field_70180_af.func_75692_b(15, (Object)((byte)amount));
        if (amount == 0 && this.field_70153_n == null) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.aiAttackTarget);
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    protected void func_70628_a(boolean hit, int amount) {
        int count = 1 + this.getBloodConsumed();
        this.func_145779_a(BLItemRegistry.sapBall, count);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("bloodLevel", this.getBloodConsumed());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setBloodConsumed(nbttagcompound.func_74762_e("bloodLevel"));
    }

    @Override
    public String pageName() {
        return "leech";
    }
}

